#include "Sequence/Debug/DSModelViewer.h"

#include "Camera3DOperation.h"
#include "CharacterDatabase.h"

using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	/// ǂݍރAj[V̍ő吔
	const int nKMaxAnimCount = 10;

	/// ǂݍރfƃAj[V̑gݍ킹
	struct SModelData
	{
		const TCHAR* const mModelFilePath;
		const TCHAR* const mAnimFilePaths[nKMaxAnimCount];
	};

	/// ǂݍރt@C̃Zbg
	const SModelData nKSModelDatas[] =
	{
		// SȂ̂ňUCO
		//_T("./Res/Model/Characters/00_MinakamiRyuto/Mesh.FBX"),
		//_T("./Res/Model/Characters/01_TillshePnimris/Mesh.FBX"),
		//_T("./Res/Model/Characters/02_CrumenaZenovia/Mesh.FBX"),
		//_T("./Res/Model/Characters/03_EelEugenie/Mesh.FBX"),
		//_T("./Res/Model/Characters/04_SienaEirene/Mesh.FBX"),
		//_T("./Res/Model/Characters/05_Redo/Mesh.FBX"),
		//_T("./Res/Model/Characters/06_Hinade/Mesh.FBX"),
		//_T("./Res/Model/Characters/07_SalaurelLadycate/Mesh.FBX"),
		//_T("./Res/Model/Characters/08_ChlorisRunvale/Mesh.FBX"),
		//_T("./Res/Model/Characters/09_TinaRunvale/Mesh.FBX"),
		//_T("./Res/Model/Characters/10_Uluru/Mesh.FBX"),
		//_T("./Res/Model/Characters/11_Suisen/Mesh.FBX"),
		//_T("./Res/Model/Characters/12_HarugaharaSusuki/Mesh.FBX"),
		//_T("./Res/Model/Characters/13_Palvie/Mesh.FBX"),
		//_T("./Res/Model/Characters/14_TsukatsukiNaretch/Mesh.FBX"),
		//_T("./Res/Model/Characters/15_PolaPola/Mesh.FBX"),
		//_T("./Res/Model/Characters/16_FalnaIGallbath/Mesh.FBX"),
		//_T("./Res/Model/Characters/17_DollseerReiren/Mesh.FBX"),
		//_T("./Res/Model/Characters/18_MakinoYutaka/Mesh.FBX"),
		//_T("./Res/Model/Characters/19_ZadielAlliluia/Mesh.FBX"),
		//_T("./Res/Model/Characters/20_MutsuIori/Mesh.FBX"),
		//_T("./Res/Model/Characters/21_Manaka/Mesh.FBX"),
		//_T("./Res/Model/Characters/22_RandyanWaltlee/Mesh.FBX"),
		//_T("./Res/Model/Characters/23_Kikuri/Mesh.FBX"),
		//_T("./Res/Model/Characters/24_Oryu/Mesh.FBX"),

		{ _T("./Res/Model/Characters/98_KirisameMarisa/KirisameMarisa.FBX"),
			{
				_T("./Res/Model/Characters/98_KirisameMarisa/KirisameMarisa_Anim_Stand_Take 001.fbx"),
				_T("./Res/Model/Characters/98_KirisameMarisa/KirisameMarisa_Anim_Walk_Take 001.fbx"),
			},
		},
		{ _T("./Res/Model/Characters/98_KirisameMarisa/KirisameMarisa_Skin.FBX"),
			{
				_T("./Res/Model/Characters/98_KirisameMarisa/KirisameMarisa_Anim_Stand_Take 001.fbx"),
				_T("./Res/Model/Characters/98_KirisameMarisa/KirisameMarisa_Anim_Walk_Take 001.fbx"),
			},
		},
		{ _T("./Res/Model/Characters/99_Celsius/Celsius.FBX"),
			{ _T(""), },
		},
		{ _T("./Res/Model/Characters/102_IzayoiSakuya/Mesh.FBX"), {}, },
		{ _T("./Res/Model/Characters/102_IzayoiSakuya/002_Skin.FBX"),
			{
				_T("./Res/Model/Characters/102_IzayoiSakuya/003_Anim_Stand.FBX"),
				_T("./Res/Model/Characters/102_IzayoiSakuya/004_Anim_Nod.FBX"),
				_T("./Res/Model/Characters/102_IzayoiSakuya/005_Anim_ShakeMyHead.FBX"),
				_T("./Res/Model/Characters/102_IzayoiSakuya/006_Anim_Walk_In.FBX"),
				_T("./Res/Model/Characters/102_IzayoiSakuya/007_Anim_Walk_Now.FBX"),
				_T("./Res/Model/Characters/102_IzayoiSakuya/007_Anim_Walk_Now_Take 001.FBX"),
			},
		},
	};

	/// ǂݍރt@C̃Zbg̐
	const int nKModelDataCount = SIZE_OF_ARRAY(nKSModelDatas);


	/// VF[_[̃t@CpX
	const TCHAR* const nKPShaderFilePaths[] =
	{
		_T("./Res/Shader/Character.fx"),
		_T("./Res/Shader/StandardConstant.fx"),
		_T("./Res/Shader/StandardLambert.fx"),
		_T("./Res/Shader/StandardPhong.fx"),
		_T("./Res/Shader/StandardPrimitive.fx"),
	};

	/// VF[_[̃t@CpX̐
	const int nKShaderFilePathCount = SIZE_OF_ARRAY(nKPShaderFilePaths);


	/// Aj[Vԍ
	int nAnimationNumber = -1;

	/// Aj[V̑x
	float nAnimationSpeedRatio = 1.0f;
	
	/// ǉCX^X̐BfobOj[ŎgB
	int nAddInstanceCount = 1;
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DSModelViewer::DSModelViewer()
	: SequenceBase(false)
{
}

/// fXgN^
DSModelViewer::~DSModelViewer()
{
}


/// 
void DSModelViewer::Initialize()
{
	// ̏
	SequenceBase::Initialize();

	// J
	mPCamera.SetPointer(NEW Camera3DOperation());
	mPCamera->SetLookAt(Vector3::UnitY() * 0.0f);
	mPCamera->SetPosition(Vector3(1, 1, -1) * 300.0f);

	// XYZ
	mPXYZAxis.SetPointer(NEW XYZAxisDX9());
	mPXYZAxis->SetCamera(mPCamera);
	mPXYZAxis->SetLength(100.0f);

	// Obh쐬
	mPGrid.SetPointer(NEW GridDX9());
	mPGrid->Create(1000.0f, 50.0f);
	mPGrid->SetCamera(mPCamera);

	// NXwA쐬
	mPCrosshair.SetPointer(NEW CrosshairDX9());
	mPCrosshair->Create(5);
	mPCrosshair->SetCamera(mPCamera);


	// fobOj[̖Oݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("<DSModelViewer>");

	// f̃Xgǉ
	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->SetName(_T("f"));
	pMEL->SetPosition(Vector3(10, 30, 0));
	mPDebugMenu->AddMenuEntryList(pMEL);
	
	SP<MenuEntryStrings> pME(NEW MenuEntryStrings());
	pME->SetName(_T("f"));
	pME->SetText(_T("f"));
	pMEL->AddMenuEntry(pME);
	for (int i = 0; i < nKModelDataCount; ++i)
	{
		const SModelData* kPData = &nKSModelDatas[i];
		pME->AddString(kPData->mModelFilePath);
	}

	// VF[_[
	SP<MenuEntryStrings> pMEShader(NEW MenuEntryStrings());
	pMEShader->SetName(_T("VF[_["));
	pMEShader->SetText(_T("VF[_["));
	pMEL->AddMenuEntry(pMEShader);
	for (int i = 0; i < nKShaderFilePathCount; ++i)
	{
		pMEShader->AddString(nKPShaderFilePaths[i]);
	}

	// Aj[Vԍ
	SP<MenuEntryNumeric<int>> pMEAnimNumber(NEW MenuEntryNumeric<int>());
	pMEAnimNumber->SetName(_T("Aj[Vԍ"));
	pMEAnimNumber->SetText(_T("Aj[Vԍ"));
	pMEAnimNumber->SetNumericPointer(&nAnimationNumber);
	pMEAnimNumber->SetLimitUnder(0);
	pMEAnimNumber->SetLimitOver(nKMaxAnimCount);
	pMEL->AddMenuEntry(pMEAnimNumber);

	// Aj[Vx
	SP< MenuEntryNumeric<float> > pMEAnimSpeed(NEW MenuEntryNumeric<float>());
	pMEAnimSpeed->SetName(_T("Ajx"));
	pMEAnimSpeed->SetText(_T("Ajx"));
	pMEAnimSpeed->SetNumericPointer(&nAnimationSpeedRatio);
	pMEAnimSpeed->SetLimitUnder(-8.0f);
	pMEAnimSpeed->SetLimitOver(8.0f);
	pMEAnimSpeed->SetStep(0.25f);
	pMEL->AddMenuEntry(pMEAnimSpeed);
	
	// CX^Xǉ
	SP<MenuEntryNumeric<int>> pMEInstanceAdd(NEW MenuEntryNumeric<int>());
	pMEInstanceAdd->SetNumericPointer(&nAddInstanceCount);
	pMEInstanceAdd->SetLimitUnder(1);
	pMEInstanceAdd->SetLimitOver(10);
	pMEInstanceAdd->SetStep(1);
	pMEInstanceAdd->SetName(_T("CX^Xǉ"));
	pMEInstanceAdd->SetText(_T("CX^Xǉ"));
	pMEL->AddMenuEntry(pMEInstanceAdd);
}

/// 
void DSModelViewer::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);

	// J̓͏
	SP<Camera3DOperation> pCamera;
	if (pCamera.DownCast(mPCamera))
	{
		pCamera->HandleInput(delta);
	}


	// 肵ǂݍ
	IKeyboard* pKB = InputManagerHelper::GetKeyboard();
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		// f̃GgIĂ鎞̂ݏ
		SP<IMenuEntry> pMenuEntry = mPDebugMenu->GetSelectedMenuEntryList()->GetSelectedMenuEntry();
		if ( _tcscmp(pMenuEntry->GetName(), _T("f")) == 0)
		{
			SP<MenuEntryStrings> pMEModelFilePath;
			SP<MenuEntryStrings> pMEShaderFilePath;
			pMEModelFilePath.DownCast(mPDebugMenu->GetSelectedMenuEntryList()->GetMenuEntry(_T("f")));
			pMEShaderFilePath.DownCast(mPDebugMenu->GetSelectedMenuEntryList()->GetMenuEntry(_T("VF[_[")));

			const int kSelectedModelIndex = pMEModelFilePath->GetSelectedIndex();
			const SModelData* kPModelData = &nKSModelDatas[kSelectedModelIndex];

			// fǂݍ
			mPSkinModel.SetPointer(NEW SkinModel());
			mPSkinModel->LoadMesh(kPModelData->mModelFilePath);

			// VF[_[͂ĂȂƃG[oBg܂킷ƃXg[̉eoĂ̂œǂݍݒB
			const TCHAR* kPShaderFilePath = pMEShaderFilePath->GetSelectedString();
			SP<ShaderEffectDX9> pShader(NEW ShaderEffectDX9());
			pShader->Load(kPShaderFilePath);
			mPSkinModel->SetShaderEffect(pShader);

			// Jݒ肵ȂƃG[o
			mPSkinModel->SetCamera(mPCamera);
			
			// HACK:ǉŃAj[VǂݍށB
			// fɗpӂ\bh̗pӂsSȂ̂łœǂݍŒǉĂB
			using namespace fbxsdk_2012_2;
			KFbxSdkManager* pFbxSdkManager = KFbxSdkManager::Create();
			KFbxImporter* pImporter = KFbxImporter::Create(pFbxSdkManager, "Importer");
			for (int i = 0; i < nKMaxAnimCount; ++i)
			{
				// t@CpXNULLȂ珈Ȃ
				if (kPModelData->mAnimFilePaths[i] == NULL)
				{
					continue;
				}

				using namespace Blast::String;
				CHAR animFilePath[128] = { '\0' };
				StringHelper::ToMultiByteChar(animFilePath, SIZE_OF_ARRAY(animFilePath), kPModelData->mAnimFilePaths[i]);
				bool isSucceeded = pImporter->Initialize(animFilePath);
				if (isSucceeded)
				{
					// Aj[Vǉ
					KFbxScene* pScene = NULL;
					pScene = KFbxScene::Create(pFbxSdkManager, "Scene");
					pImporter->Import(pScene);
					
					SP<AnimationSet> pAnimSet(NEW AnimationSet());
					pAnimSet->Initialize(pScene);

					mPSkinModel->GetAnimationController()->ResisterAnimationSet(pAnimSet);
					mPSkinModel->GetAnimationController()->SetTrackAnimationSet(0, pAnimSet);
				}
			}

			nAnimationNumber = 0;
		}
	}

	// Aj[VԍύXꂽAj[VύX
	SP<MenuEntryNumeric<int>> pMEAnimNumber;
	pMEAnimNumber.DownCast(mPDebugMenu->GetSelectedMenuEntryList()->GetMenuEntry(_T("Aj[Vԍ")));
	if (pMEAnimNumber->IsChange())
	{
		const int kAnimNumber = *(pMEAnimNumber->GetNumericPointer());
		SP<AnimationController> pAnimationController = mPSkinModel->GetAnimationController();
		if (pAnimationController &&
			kAnimNumber < pAnimationController->GetAnimationSetCount())
		{
			pAnimationController->ResetTime();
			pAnimationController->ChangeAnimation(kAnimNumber, 0.25);
		}
	}

	// Aj[VxύXꂽAj[VxύX
	SP< MenuEntryNumeric<float> > pMEAnimSpeed;
	pMEAnimSpeed.DownCast(mPDebugMenu->GetSelectedMenuEntryList()->GetMenuEntry(_T("Ajx")));
	if (pMEAnimSpeed->IsChange())
	{
		const float kAnimSpeed = *(pMEAnimSpeed->GetNumericPointer());
		mPSkinModel->GetAnimationController()->SetSpeedRatio(kAnimSpeed);
	}

	// CX^Xǉ
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		SP<IMenuEntry> pMESelected = mPDebugMenu->GetSelectedMenuEntryList()->GetSelectedMenuEntry();
		if ( _tcscmp(pMESelected->GetName(), _T("CX^Xǉ")) == 0 )
		{
			SP< MenuEntryNumeric<int> > pMEInstanceAdd;
			pMEInstanceAdd.DownCast(pMESelected);
			if (pMEInstanceAdd)
			{
				if (mPSkinModel)
				{
					mPSkinModel->AddInstance(*pMEInstanceAdd->GetNumericPointer());
				}
			}
		}
	}
}

/// XV
void DSModelViewer::Update(float delta)
{
	// ̍XV
	SequenceBase::Update(delta);

	// JXV
	SP<Camera3DOperation> pCamera;
	if (pCamera.DownCast(mPCamera))
	{
		pCamera->Update(delta);
	}

	// fXV
	if (mPSkinModel)
	{
		mPSkinModel->Update(delta);
	}

	// XYZXV
	if (mPXYZAxis)
	{
		mPXYZAxis->Update(delta);
	}


	// NXwÄʒuJ̒_ɑ
	mPCrosshair->SetPosition(mPCamera->GetLookAt());
}

/// `
void DSModelViewer::Render()
{
	// ̕`揈
	SequenceBase::Render();

	// XYZ`
	if (mPXYZAxis)
	{
		mPXYZAxis->Render();
	}

	// Obh`
	if (mPGrid)
	{
		mPGrid->Render();
	}

	// NXwA`
	if (mPCrosshair)
	{
		mPCrosshair->Render();
	}

	// f`
	if (mPSkinModel)
	{
		mPSkinModel->Render();
	}
}