#include "MessageText.h"

using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/* eLXg̏\ */

/// RXgN^
MessageText::SText::SText()
{
	mTextStr = _T("");
	mPosition = Vector3::Zero();
	mMoveTargetPosition = Vector3::Zero();
	mMoveLeftTime = 0;
	mEState = eSTATE_HIDE;
}

/// XV
void MessageText::SText::Update(float delta)
{
	// \Ԃŕ
	switch (mEState)
	{
		// \
		case eSTATE_HIDE:
			break;

		// 
		case eSTATE_ENTER:
			// ړ̎cbȂ
			if (0 < mMoveLeftTime)
			{
				// ړ̈ʒuZo
				Vector3 sub = mMoveTargetPosition - mPosition;
				Vector3 unit = sub / mMoveLeftTime;
				Vector3 movedPos = unit * delta + mPosition;
				mPosition = movedPos;
				
				// cbvZ
				mMoveLeftTime -= delta;
				if (mMoveLeftTime < 0)
				{
					mMoveLeftTime = 0;

					mEState = eSTATE_SHOW;
				}
			}
			break;

		// \
		case eSTATE_SHOW:
			break;

		// ޏ
		case eSTATE_LEAVE:
			// ړ̎cbȂ
			if (0 < mMoveLeftTime)
			{
				// ړ̈ʒuZo
				Vector3 sub = mMoveTargetPosition - mPosition;
				Vector3 unit = sub / mMoveLeftTime;
				Vector3 movedPos = unit * delta + mPosition;
				mPosition = movedPos;
				
				// cbvZ
				mMoveLeftTime -= delta;
				if (mMoveLeftTime < 0)
				{
					mMoveLeftTime = 0;

					mEState = eSTATE_EXIT;
				}
			}
			break;

		// I
		case eSTATE_EXIT:
			break;

		// ̑
		default:
			HALT(_T("ȃP[XłB"));
			break;
	}
}

/// `
void MessageText::SText::Render(SP<IFont> pFont)
{
	pFont->SetText(mTextStr.c_str());
	pFont->SetPosition(mPosition);
	pFont->Render();
}


/// wʒuɎw莞ԂĈړ
void MessageText::SText::Move(const Vector3& kRTarget, float time)
{
	mMoveTargetPosition = kRTarget;
	mMoveLeftTime = time;
}


/// \Ԃ擾
MessageText::SText::EState MessageText::SText::GetState() const
{
	return mEState;
}

/// \Ԃݒ
void MessageText::SText::SetState(EState eState)
{
	mEState = eState;
}


/// Iėǂǂ擾
bool MessageText::SText::IsExit() const
{
	return (mEState == eSTATE_EXIT);
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MessageText::MessageText()
{
}

/// fXgN^
MessageText::~MessageText()
{
}


/// tHgݒ
void MessageText::SetFont(const SP<Blast::Graphic::IFont> pFont)
{
	mPFont = pFont;
}


/// XV
void MessageText::Update(float delta)
{
	// eLXgXV
	const int kTextDataCount = mSTexts.size();
	for (int i = 0; i < kTextDataCount; ++i)
	{
		mSTexts.at(i).Update(delta);
	}


	// IԂ̃eLXgO
	std::vector<SText>::iterator it = mSTexts.begin();
	while (it != mSTexts.end())
	{
		if (it->IsExit())
		{
			it = mSTexts.erase(it);

			continue;
		}

		++it;
	}
}

/// `
void MessageText::Render()
{
	// eLXgɉĕ`
	const int kTextDataCount = mSTexts.size();
	for (int i = 0; i < kTextDataCount; ++i)
	{
		mSTexts.at(i).Render(mPFont);
	}
}


/// ǉ
void MessageText::AddText(const TCHAR* const kPText)
{
	SText sText;
	sText.mTextStr = kPText;

	// MEMO:\͈͂MMo邠ł̑ҋ@Kvł傤B
	sText.mPosition = mPFont->GetPosition();
	sText.mPosition.mY += static_cast<float>(mPFont->GetPointSize());

	mSTexts.push_back(sText);
}

/// ̕\
void MessageText::NextText(float lifeTime, float moveTime)
{
	bool isHideOnce = false;
	bool isShowOnce = false;

	// MEMO:ɂ炵Ă܂A_w肵ǂm܂B
	const int kTextCount = mSTexts.size();
	for (int i = 0; i < kTextCount; ++i)
	{
		SText& rSText = mSTexts.at(i);
		
		// ړʒuZo
		const int kScrollY = mPFont->GetPointSize();
		Vector3 targetPos = rSText.mPosition;
		targetPos.mY -= kScrollY;

		
		// ݂̏ԂŎ̏Ԃ
		switch (rSText.GetState())
		{
			// \Ȃ
			case SText::eSTATE_HIDE:
				if (!isHideOnce)
				{
					isHideOnce = true;
					rSText.SetState(SText::eSTATE_ENTER);
					rSText.Move(targetPos, moveTime);
				}
				break;

			// A\Ȃޏ
			case SText::eSTATE_SHOW:
				if (!isShowOnce)
				{
					isShowOnce = true;
					rSText.SetState(SText::eSTATE_LEAVE);
					rSText.Move(targetPos, moveTime);
				}
				break;

			default:
				break;
		}
	}
}


//====================================================================================================
// Transfar
//----------------------------------------------------------------------------------------------------

/// Jݒ
void MessageText::SetCamera(const SP<ICamera> pCamera)
{
	//mPFont->SetCamera(pCamera);
	HALT(_T("tHgɒڃJݒ肷͎̂2DA3D̐؂ւŒڐݒ肷͓̂ł͖̂ł߂܂B"));
}

/// ʒuݒ
void MessageText::SetPosition(const Vector3& kRPosition)
{
	mPFont->SetPosition(kRPosition);
}

/// ݒ
void MessageText::SetText(const TCHAR* const kPText)
{
	mPFont->SetText(kPText);
}