#include "MainGameStateConstruct.h"

#include "./Sequence/MainGameSequence.h"
#include "MainGameStateController.h"

#include "./Sequence/MainMenuSequence.h"
#include "ItemDatabase.h"

#include "ChipsetTag.h"
#include "ItemTag.h"
#include "CharacterTag.h"
#include "TrapTag.h"

using namespace Blast::Base;
using namespace Blast::Design;
using namespace Blast::Input;
using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainGameStateConstruct::MainGameStateConstruct(MainGameStateController* pStateController)
	: mPStateController(pStateController)
{
	// `ԑJڂ쐬
	mModeTransistor.Initialize(this);
	mModeTransistor.Add(
		eMODE_CONSTRUCT,
		&MainGameStateConstruct::ConstructOn,
		NULL,
		&MainGameStateConstruct::ConstructHandleInput,
		NULL,
		NULL);

	mModeTransistor.Add(
		eMODE_COMPLETE,
		&MainGameStateConstruct::CompleteOn,
		NULL,
		NULL,
		NULL,
		NULL);

	mModeTransistor.ChangeMode(eMODE_CONSTRUCT);
}

/// fXgN^
MainGameStateConstruct::~MainGameStateConstruct()
{
}

/// 
void MainGameStateConstruct::HandleInput(float delta)
{
	mModeTransistor.HandleInput(delta);
}

/// XV
void MainGameStateConstruct::Update(float delta)
{
	mModeTransistor.Update(delta);
}

/// `
void MainGameStateConstruct::Render()
{
	mModeTransistor.Render();

	// UNDONE:ԂȂ玟̒iKֈڍsł邱Ƃ
	if (mModeTransistor.IsCurrentMode(eMODE_CONSTRUCT) &&
		!mIsConstructing)
	{
		DP(10, 100, 0xffffffff, _T("MainGameStateConstruct̊I(EnterŎ)"));
	}
}


//====================================================================================================
// Mode
//----------------------------------------------------------------------------------------------------

/* `Ԏ̏ */
/// 
void MainGameStateConstruct::ConstructOn()
{
	// ł邱Ƃ
	mIsConstructing = true;

	// n`쐬BMVCm̕B
	mPStateController->GetSequence()->GetViewManager()->GetViewTerrain()->SetChipset(ChipsetTag::eCHIPSET_GLASSLAND);	///< UNDONE:ID̎w͂ł̓eLg[
	SP<TerrainGrid> pTerrainGrid = mPStateController->GetDataManager()->GetTerrainGrid();
	pTerrainGrid->CreateGrid(0);	///< UNDONE:ID̎w͂ł̓eLg[

	
	//--------------------------------------------------


	// lNXg}Xǉ
	SP<NextMassManager::SData> pSNextMassData(NEW NextMassManager::SData());
	pSNextMassData->mGridPosition = Point(5, 3);

	mPStateController->GetDataManager()->GetNextMassManager()->AddNextMass(pSNextMassData);


	//--------------------------------------------------

	
	// d̂ňU

	//// 㩂쐬B̓eLg[BCX^VOKvB
	//// 񂻂̂܂܂ManagerɔĈǂ̂ȂB
	const int kTrapCount = 3;
	const TrapTag::ETrapTag kTrapTags[] = 
	{
		TrapTag::eTRAP_SLIME,
		TrapTag::eTRAP_POISONPOLLEN,
		TrapTag::eTRAP_LAMIA,
	};
	const Point kTrapGridPoints[kTrapCount] =
	{
		Point(1, 5),
		Point(2, 6),
		Point(3, 7),
	};
	//for (int i = 0; i < kTrapCount; ++i)
	//{
	//	SP<FloorTrap> pFloorTrap(NEW FloorTrap());
	//	pFloorTrap->Initialize(kFloorTrapIDs[i]);
	//	pFloorTrap->SetCamera( mPStateController->GetDataManager()->GetCamera() );
	//	pFloorTrap->SetTilePosition(kTrapGridPoints[i]);

	//	SP<Terrain> pTerrain = mPStateController->GetDataManager()->GetTerrain();
	//	SP<Tile> pTile = pTerrain->GetTile(kTrapGridPoints[i].mX + kTrapGridPoints[i].mY * MapDataManager::MAX_TILE_HORIZON_COUNT);
	//	pFloorTrap->GetModel()->SetPosition(pTile->GetWorldPosition());

	//	mPStateController->GetDataManager()->GetFloorTraps()->push_back(pFloorTrap);
	//}

	// 㩂쐬
	for (int i = 0; i < kTrapCount; ++i)
	{
		SP<TrapManager::STrap> pTrap(NEW TrapManager::STrap());
		pTrap->mETrapTag = kTrapTags[i];
		pTrap->mGridPosition = kTrapGridPoints[i];

		mPStateController->GetDataManager()->GetTrapManager()->AddTrap(pTrap);
	}
	
	//--------------------------------------------------

	// d̂ňU

	//// ĂACẽf`bvZbg쐬
	//SP<DropItemChipset> pDropItemChipset = mPStateController->GetDataManager()->GetDropItemChipset();
	//pDropItemChipset->Initialize(0);	//< ͈ꗥB

	// ĂACȅzu쐬
	// ĂACeQ쐬B̓eLg[
	const int kDropItemCount = 3;
	const ItemTag::EItemTag kDropItemTags[kDropItemCount] =
	{
		ItemTag::eITEM_CATALOG_TAG_WEAPON_DAGGER,
		ItemTag::eITEM_CATALOG_TAG_WEAPON_UNDINESWORD,
		ItemTag::eITEM_CATALOG_TAG_SHIELD_GRASS,
	};
	const Point kDropItemTilePoints[kDropItemCount] =
	{
		Point(1, 1),
		Point(2, 2),
		Point(3, 3),
	};
	//// CX^VOpɏœĂCX^Xe
	//for (int i = 0; i < DropItemChipTag::eDROP_ITEM_CHIP_TAG_COUNT; ++i)
	//{
	//	SP<DropItemChipset> pChipset = mPStateController->GetSequence()->GetDataManager()->GetDropItemChipset();
	//	pChipset->GetChip(i)->GetModel()->RemoveInstance(0, 1);
	//}
	for (int i = 0; i < kDropItemCount; ++i)
	{
		// svɂȂ
		//const int kIndex = kDropItemTilePoints[i].mX + kDropItemTilePoints[i].mY * MapDataManager::MAX_TILE_HORIZON_COUNT;

		// svɂȂ
		//const Vector3& kRWorldPos = mPStateController->GetSequence()->GetDataManager()->GetTerrainGrid()->GetTileAt(kIndex)->mWorldPosition;

		//SP<DropItem> pDropItem(NEW DropItem());
		//pDropItem->Initialize(kDropItemTags[i], kDropItemTilePoints[i]);
		//pDropItem->SetWorldPostion(kRWorldPos);

		//std::list< SP<DropItem> >* pDropItems = mPStateController->GetSequence()->GetDataManager()->GetDropItems();
		//pDropItems->push_back(pDropItem);


		// MVC𖾊mɂ邽߂ɕ
		SP<DropItemManager::SData> pDropItem(NEW DropItemManager::SData);
		pDropItem->mEItemTag = kDropItemTags[i];
		pDropItem->mGridPosition = kDropItemTilePoints[i];
	
		mPStateController->GetDataManager()->GetDropItemManager()->AddDropItem(pDropItem);

	//	// ACeIDނ擾ACX^XɒǉނK؂ɑIԁB
	//	ItemDatabase* pIDB = ItemDatabase::GetInstance();
	//	const ItemDatabase::SCatalog* kPCatalog = pIDB->GetCatalogAt(kDropItemTags[i]);
	//	const int kChipIndex = kPCatalog->mKindID;	//< ނ̂܂܎QƍۂɂȂB^OłȂB

	//	// UNDONE:CX^XǉBACe̎ނɂĎQƐύXB
	//	SP<DropItemChipset> pChipset = mPStateController->GetSequence()->GetDataManager()->GetDropItemChipset();
	//	pChipset->GetChip(kChipIndex)->GetModel()->AddInstance(1);

	//	// OۂɕKvȂ̂ŁACX^X̃CfbNXێ
	//	const int kInstanceIndex = pChipset->GetChip(kChipIndex)->GetModel()->GetInstanceCount() - 1;
	//	pDropItem->SetInstanceIndex(kInstanceIndex);

	//	// CX^Ẍʒuݒ
	//	const int kIndex = kDropItemTilePoints[i].mX + kDropItemTilePoints[i].mY * MapDataManager::MAX_TILE_HORIZON_COUNT;
	//	const Vector3& kRWorldPos = mPStateController->GetSequence()->GetDataManager()->GetTerrain()->GetTile(kIndex)->GetWorldPosition();

	//	StaticModelDX9::SInstance& rData = pChipset->GetChip(kChipIndex)->GetModel()->GetInstanceDatas().back();
	//	rData.mPosition.x = kRWorldPos.mX;
	//	rData.mPosition.y = kRWorldPos.mY;
	//	rData.mPosition.z = kRWorldPos.mZ;
	}

	//--------------------------------------------------

	//// vC[LN^[쐬
	//// ̓t@NgNXg킸̂܂܍쐬ĂB͂łB
	//SP<Character> pChara = mPStateController->GetSequence()->GetDataManager()->GetPlayer();
	//pChara->Initialize();
	//pChara->Load(_T("./Res/Model/Characters/102_IzayoiSakuya/Mesh.FBX"));
	//
	//ResourceManager* pRM = ResourceManager::GetInstance();
	//SP<ShaderEffectDX9> pShader = pRM->Load<ShaderEffectDX9>( ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_CHARACTER) );
	//pChara->GetModel()->SetShaderEffect(pShader);

	//pChara->SetCamera( mPStateController->GetDataManager()->GetCamera() );

	// ViewUnitɏڍs

	// vC[ݒBł̐ݒ肪fɔfB
	mPStateController->GetSequence()->GetViewManager()->GetViewUnit()->SetPlayer(0);

	SP<Unit> pPlayerUnit(NEW Unit());
	pPlayerUnit->SetCharacterTag(CharacterTag::eCHARACTER_RYUTO);
	pPlayerUnit->SetRoleTag(Unit::eROLE_PLAYER);
	pPlayerUnit->SetGridPosition( Point(0, 0) );

	const SP<TerrainGrid::STile> kPTile = mPStateController->GetDataManager()->GetTerrainGrid()->GetTileAt( pPlayerUnit->GetGridPosition() );
	pPlayerUnit->SetWorldPosition( kPTile->mWorldPosition  );
	
	pPlayerUnit->SetDirection(Direction::eDIRECTION_8);
	mPStateController->GetSequence()->GetDataManager()->GetUnitManager()->AddUnit(pPlayerUnit);
	
	//--------------------------------------------------

	// ViewUnitɈڍs

	// d̂ňU

	//// G̃`bvZbg쐬
	//const int kEnemyChipsetID = 0;	//< eLg[IDłĂB{ȂtA[ɑČ肳͂̂
	//EnemyChipsetTag::EChipsetTag eChipsetTag = static_cast<EnemyChipsetTag::EChipsetTag>(kEnemyChipsetID);
	//mPStateController->GetSequence()->GetDataManager()->GetEnemyChipset()->Initialize(eChipsetTag);	

	//// ŒǉĂCX^XO
	//for (int i = 0; i < 3; ++i)	//< łBܘ_AN[ȂB
	//{
	//	SP<EnemyChipset> pChipset = mPStateController->GetDataManager()->GetEnemyChipset();
	//	pChipset->GetChip(i)->GetModel()->RemoveInstance(0, 1);
	//}

	// UNDONE:G̏zu
	const CharacterTag::ECharacterTag kEnemyTags[] =
	{
		CharacterTag::eCHARACTER_TILSHE,
		CharacterTag::eCHARACTER_ZENOVIA,
		CharacterTag::eCHARACTER_EEL,
	};
	const int kEnemyTagCount = SIZE_OF_ARRAY(kEnemyTags);
	const Point kEnemyTilePoints[kEnemyTagCount] =
	{
		Point(5, 4),
		Point(6, 5),
		Point(7, 6),
	};

	//for (int i = 0; i < kEnemyIDCount; ++i)
	//{
	//	const int kEnemyID = kEnemyIDs[i];
	//	SP<EnemyChip> pEnemyChip = mPStateController->GetSequence()->GetDataManager()->GetEnemyChipset()->GetChip(kEnemyID);
	//	pEnemyChip->GetModel()->AddInstance(1);

	//	const int kTileIndex = kEnemyTilePoints[i].mX + kEnemyTilePoints[i].mY * MapDataManager::MAX_TILE_HORIZON_COUNT;
	//	const Vector3& kRWorldPos = mPStateController->GetDataManager()->GetTerrain()->GetTile(kTileIndex)->GetWorldPosition();

	//	const int kNowAddedIndex = pEnemyChip->GetModel()->GetInstanceCount() - 1;
	//	D3DXVECTOR4& rPos = pEnemyChip->GetModel()->GetInstanceDatas().at(kNowAddedIndex).mPosition;
	//	rPos.x = kRWorldPos.mX;
	//	rPos.y = kRWorldPos.mY;
	//	rPos.z = kRWorldPos.mZ;
	//}

	// Gǉ
	for (int i = 0; i < kEnemyTagCount; ++i)
	{
		SP<Unit> pUnit(NEW Unit());
		pUnit->SetCharacterTag(kEnemyTags[i]);
		pUnit->SetRoleTag(Unit::eROLE_ENEMY);
		pUnit->SetGridPosition(kEnemyTilePoints[i]);
		pUnit->SetDirection(Direction::eDIRECTION_1);
		mPStateController->GetSequence()->GetDataManager()->GetUnitManager()->AddUnit(pUnit);
	}

	// 
	mIsConstructing = false;
}

/// 
void MainGameStateConstruct::ConstructHandleInput(float delta)
{
	// L[͂Ŏ̌`Ԃ֑Jڂ
	IKeyboard* pKB = InputManagerHelper::GetKeyboard();
	if (!mIsConstructing &&
		pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		// J
		mModeTransistor.ChangeMode(eMODE_COMPLETE);
	}
}

/* ̏ */
/// 
void MainGameStateConstruct::CompleteOn()
{
	// J
	mPStateController->ChangeState(MainGameStateController::eSTATE_NORMAL);
}