#include "FloorTrap.h"

#include "Blast/Graphic/DirectX9/BtModelDX9.h"

using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
FloorTrap::FloorTrap() :
mTrapID(-1),
mTilePosition(-1),
mPModel(NEW StaticModelDX9()),
mPCamera()
{
}

/// fXgN^
FloorTrap::~FloorTrap()
{
}


/// 
void FloorTrap::Initialize(int trapID)
{
	mTrapID = trapID;
}

/// XV
void FloorTrap::Update(float delta)
{
	// fXV
	if (mPModel)
	{
		mPModel->Update(delta);
	}
}

/// `
void FloorTrap::Render()
{
	// f`悷
	if (mPModel)
	{
		mPModel->SetCamera(mPCamera);
		mPModel->Render();
	}
}


/// fǂݍ
void FloorTrap::LoadModel(const TCHAR* const kPFullPath)
{
	mPModel->LoadMesh(kPFullPath);
}