#include "DatabaseDataList.h"

#include "Blast/IO/CSVFile.h"
#include "Blast/IO/CSVTable.h"

using namespace Blast::IO;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DatabaseDataList::DatabaseDataList()
{
}

/// fXgN^
DatabaseDataList::~DatabaseDataList()
{
}


/// ǂݍ
void DatabaseDataList::Load(const TCHAR* const kPFullPath)
{
	// CSVt@Cǂݍ
	CSVFile csv(kPFullPath);
	csv.Create();

	// e[u擾
	const SP<CSVTable> pTable = csv.GetDataTable();

	// R[hŃ[v
	const int kColumnCount = csv.GetColumnCount();
	const int kRowCount = csv.GetRowCount();
	for (int i = 0; i < kRowCount; ++i)
	{
		// R[h擾
		const SP<CSVRecord> kPRecord = pTable->GetRecord(i);
		
		// ǂݍ
		SP<IDatabaseData> pData = LoadData(kPRecord);

		// f[^Xgɒǉ
		mDatas.push_back(pData);
	}
}


/// f[^擾
const SP<IDatabaseData> DatabaseDataList::GetData(int id) const
{
	std::list< SP<IDatabaseData> >::const_iterator kIt;
	for (kIt = mDatas.begin(); kIt != mDatas.end(); ++kIt)
	{
		if (id == (*kIt)->GetID())
		{
			return (*kIt);
		}
	}

	// HALT:ȂȂ玀
	HALT(_T("f[^擾ł܂łB"));

	return SP<IDatabaseData>();
}


/// f[^Xg擾
const std::list< SP<IDatabaseData> >* DatabaseDataList::GetDatas() const
{
	return &mDatas;
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// ǂݍ
SP<IDatabaseData> DatabaseDataList::LoadData(const SP<Blast::IO::CSVRecord>)
{
	WARNING(NULL, _T("̃\bh͌p̃NXŎKv܂B"));

	return SP<IDatabaseData>();
}