#ifndef LINE3D_FX
#define LINE3D_FX

#include "stdafx.fx"


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/// AvP[V炭钸_obt@ւ̏
struct SAppData
{
	float3 mPosition	: POSITION;		///< ʒuW
};

/// _obt@sNZVF[_֓nf[^
struct SVertexOutput
{
    float4 mPosition	: POSITION;		/// ʒuW
};


//====================================================================================================
// VertexShader
//----------------------------------------------------------------------------------------------------

/// C
SVertexOutput MainVS(SAppData sIn)
{
	// o̓f[^p
	SVertexOutput sOut = (SVertexOutput)0;


	// ʒuWZo
	float4 pos = float4(sIn.mPosition, 1);
	pos = mul(pos, gWorld);
	pos = mul(pos, gView);
	pos = mul(pos, gProjection);
	pos = mul(pos, gViewport);
	
	sOut.mPosition = pos;


	// o
	return sOut;
}


//====================================================================================================
// PixelShader
//----------------------------------------------------------------------------------------------------

/// C
float4 MainPS(SVertexOutput sIn) : COLOR
{
	// fBt[YeNX`TvO
	float3 result = gAmbientColor;

    return float4(result, 1);
}


//====================================================================================================
// Technique and Pass
//----------------------------------------------------------------------------------------------------

/// RX^g
technique Constant
{
	// \bh`pX
    pass Pass0
    {
        // _[Xe[gݒ
        AlphaBlendEnable = False;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        Lighting = False;

#ifdef D3DX
	    CullMode = CCW;
#else
	    CullMode = CW;
#endif
        
        ZEnable = True;
        ZWriteEnable = True;
        
        FillMode = Solid;
        
        
        // eNX`Xe[WXe[gݒ
        TEXTURETRANSFORMFLAGS[0] = COUNT2;
        ColorOp[0] = MODULATE;
        ColorArg1[0] = TEXTURE;
        ColorArg2[0] = DIFFUSE;
        AlphaOp[0] = MODULATE;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = DIFFUSE;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 MainVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 MainPS();
    }
}

#endif // LINE3D_FX