#ifndef EFFECT_TECHNIQUES_FX
#define EFFECT_TECHNIQUES_FX

#include "Wireframe.fx"
#include "Constant.fx"
#include "Lambert.fx"
#include "Phong.fx"


//====================================================================================================
// Technique
//----------------------------------------------------------------------------------------------------

/// C[t[
technique Wireframe
{
    // C[t[`pX
    pass PassWireFrame
    {
        // _[Xe[gݒ
        AlphaBlendEnable = False;
        CullMode = CCW;
        ZEnable = True;
        ZWriteEnable = True;
        
        // C[t[w
        FillMode = WireFrame;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 WireframeVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 WireframePS();
    }
}

/// RX^g
technique Constant
{
	// \bh`pX
    pass PassSolid
    {
        // _[Xe[gݒ
        AlphaBlendEnable = True;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        Lighting = False;
        CullMode = CCW;
        ZEnable = True;
        ZWriteEnable = True;
        
        // \bhw
        //FillMode = WireFrame;
        FillMode = Solid;
        
        
        // eNX`Xe[WXe[gݒ
        TEXTURETRANSFORMFLAGS[0] = COUNT2;
        ColorOp[0] = MODULATE;
        ColorArg1[0] = TEXTURE;
        ColorArg2[0] = DIFFUSE;
        AlphaOp[0] = MODULATE;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = DIFFUSE;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 ConstantVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 ConstantPS();
    }
}

/// o[g
technique Lambert
{
	// \bh`pX
    pass PassSolid
    {
        // _[Xe[gݒ
        AlphaBlendEnable = True;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        Lighting = False;
        CullMode = CCW;
        ZEnable = True;
        ZWriteEnable = True;
        
        // \bhw
        FillMode = Solid;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 LambertVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 LambertPS();
    }
}

/// tH
technique Phong
{
	// \bh`pX
    pass PassSolid
    {
        // _[Xe[gݒ
        AlphaTestEnable = True;
        AlphaBlendEnable = True;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        Lighting = False;
        CullMode = CCW;
        ZEnable = True;
        ZWriteEnable = True;
        
        // \bhw
        FillMode = Solid;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 PhongVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 PhongPS();
    }
}


#endif // EFFECT_TECHNIQUES_FX
