#include "ViewNextMass.h"

#include "./Sequence/MainGameSequence.h"
#include "./MainGameViewManager.h"
#include "./MainGameDataManager.h"

using namespace Blast::Base;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
ViewNextMass::ViewNextMass(MainGameViewManager* pViewManager)
	: mPViewManager(pViewManager)
	, mIsVisible(true)
{
	// f쐬
	mPModel.SetPointer(NEW StaticModelDX9());
	mPModel->LoadMesh( _T("./Res/Model/NextFloor/00_MagicCircle/Mesh.FBX") );

	// VF[_[ǂݍ
	ResourceManager* pRM = ResourceManager::GetInstance();
	mPShader = pRM->Load<ShaderEffectDX9>(ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_STANDARD_CONSTANT));
	#if _DEBUG
	mPShader->SetTechnique(ShaderEffectDX9::ToTechniqueName(ShaderEffectDX9::eTECHNIQUE_CONSTANT_WIREFRAME));
	#else
	mPShader->SetTechnique(ShaderEffectDX9::ToTechniqueName(ShaderEffectDX9::eTECHNIQUE_CONSTANT));
	#endif	// _DEBUG
}

/// fXgN^
ViewNextMass::~ViewNextMass()
{
}

/// `
void ViewNextMass::Render()
{
	if (!mIsVisible)
	{
		return;
	}

	// f`
	const NextMassManager::NextMassList& kRMasses = GetDataMgr()->GetNextMassManager()->GetNextMassList();
	NextMassManager::NextMassList::const_iterator kIt = kRMasses.begin();
	for (kIt = kRMasses.begin(); kIt != kRMasses.end(); ++kIt)
	{
		// ʒu
		SP<TerrainGrid::STile> pTile = GetDataMgr()->GetTerrainGrid()->GetTileAt( (*kIt)->mGridPosition );
		if (!pTile)
		{
			continue;
		}

		mPModel->SetCamera( GetDataMgr()->GetCamera() );
		mPModel->SetPosition( pTile->mWorldPosition );
		mPModel->SetShaderEffect(mPShader);
		mPModel->Render();
	}
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

///< `tO擾
bool ViewNextMass::IsVisible() const
{
	return mIsVisible;
}

///< `tOݒ
void ViewNextMass::SetVisible(bool value)
{
	mIsVisible = value;
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// Ǘ擾
SP<MainGameDataManager> ViewNextMass::GetDataMgr()
{
	return mPViewManager->GetSequence()->GetDataManager();
}