#include "TrapManager.h"

using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
TrapManager::TrapManager()
{
}

/// fXgN^
TrapManager::~TrapManager()
{
}

/// 㩂ǉ
void TrapManager::AddTrap(SP<STrap> value)
{
	mTraps.push_back(value);
}

/// 㩂O
void TrapManager::RemoveTrap(SP<STrap> value)
{
	mTraps.remove(value);
}

/// 㩂SďO
void TrapManager::ClearTrap()
{
	mTraps.clear();
}

/// 㩂CfbNXwŎ擾
SP<TrapManager::STrap> TrapManager::GetTrapAt(int index)
{
	const bool kIsInOfRange = MathHelper::IsInOfRange<int>(index, mTraps.size());
	ASSERT_PF(kIsInOfRange, _T("CfbNX͈͊OwĂ܂B\nindex=%d"), index);
	if (!kIsInOfRange)
	{
		return SP<STrap>();
	}

	TrapList::iterator it = mTraps.begin();
	std::advance(it, index);
	return (*it);
}

/// 㩂̐擾
int TrapManager::GetTrapCount() const
{
	return mTraps.size();
}

/// 㩂1ȏ゠邩ƍ
bool TrapManager::IsEmpty() const
{
	return mTraps.empty();
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// 㩃Xg擾
const TrapManager::TrapList* TrapManager::GetTraps() const
{
	return &mTraps;
}