#include "TrapCSV.h"

#include "Blast/IO/CSVFile.h"
#include "Blast/IO/CSVTable.h"
#include "Blast/IO/CSVRecord.h"

#include "TrapTag.h"

#include "TagConverter.h"

using namespace Blast::IO;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
TrapCSV::TrapCSV()
{
	Reload();
}

/// fXgN^
TrapCSV::~TrapCSV()
{
}

/// ēǂݍ
void TrapCSV::Reload()
{
	LoadBaseData();
	// ADD:ɒǉĂB
}

/// {Q擾
const SP<TrapCSV::SBase> TrapCSV::GetBaseDatas() const
{
	return mSBaseDatas;
}
/// {擾
const TrapCSV::SBase* TrapCSV::GetBaseData(TrapTag::ETrapTag eTag) const
{
	return &mSBaseDatas[eTag];
}


//====================================================================================================
// Imeplement
//----------------------------------------------------------------------------------------------------

/// {̓ǂݍ
void TrapCSV::LoadBaseData()
{
	// CSVt@CWJ
	CSVFile csv(_T("./Res/DB/Trap/TrapBase.bin"));
	bool isCSVOk = csv.Create();
	if (!isCSVOk)
	{
		return;
	}

	// CSVt@C̏𔲐
	const SP<CSVTable> pDT = csv.GetDataTable();
	const int kRecordCount = pDT->GetRecordCount();

	mSBaseDatas.SetPointer(NEW SBase[kRecordCount], true);
	for (int i = 0; i < kRecordCount; ++i)
	{
		const SP<CSVRecord> kPRecord = pDT->GetRecord(i);

		SBase* pDst = &mSBaseDatas[i];
		pDst->mID = kPRecord->GetItem(_T("ID"))->GetValueRef().ToInteger();
		pDst->mETrapTag = TagConverter::ToTrapTag( kPRecord->GetItem(_T("^O"))->GetValueRef().ToCharacter() );
		_tcscpy_s( pDst->mName, SIZE_OF_ARRAY(pDst->mName), kPRecord->GetItem(_T("O"))->GetValueRef().ToCharacter() );
		_tcscpy_s( pDst->mDisplayName, SIZE_OF_ARRAY(pDst->mDisplayName), kPRecord->GetItem(_T("\"))->GetValueRef().ToCharacter() );
		pDst->mWorkRateNotFound = kPRecord->GetItem(_T("쓮m"))->GetValueRef().ToInteger();
		pDst->mWorkRateFound = kPRecord->GetItem(_T("쓮m"))->GetValueRef().ToInteger();
		_tcscpy_s( pDst->mModelFilePath, SIZE_OF_ARRAY(pDst->mModelFilePath), kPRecord->GetItem(_T("ft@CpX"))->GetValueRef().ToCharacter() );
		_tcscpy_s( pDst->mDiscription, SIZE_OF_ARRAY(pDst->mDiscription), kPRecord->GetItem(_T(""))->GetValueRef().ToCharacter() );
	}
}