#include "TitleStateTop.h"

#include "Blast/Input/PadInputTag.h"
#include "./Sequence/TitleSequence.h"
#include "TitleStateController.h"

using namespace Blast::Base;
using namespace Blast::Design;
using namespace Blast::Input;
using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
TitleStateTop::TitleStateTop(TitleStateController* pStateController)
	: mPStateController(pStateController)
{
	// `ԑJڂ쐬
	mModeTransistor.Initialize(this);
	mModeTransistor.Add(
		eMODE_TOP,
		&TitleStateTop::TopOn,
		NULL,
		&TitleStateTop::TopHandleInput,
		&TitleStateTop::TopUpdate,
		NULL);

	mModeTransistor.Add(
		eMODE_MENU,
		&TitleStateTop::MenuOn,
		NULL,
		&TitleStateTop::MenuHandleInput,
		&TitleStateTop::MenuUpdate,
		&TitleStateTop::MenuRender);

	mModeTransistor.ChangeMode(eMODE_TOP);
	
	// tF[hJn
	mPStateController->GetDataManager()->GetFade()->SetDirection(Fade::eDIRECTION_IN);
	mPStateController->GetDataManager()->GetFade()->SetDurationTime(0.25);
	mPStateController->GetDataManager()->GetFade()->StartFade();
}

/// fXgN^
TitleStateTop::~TitleStateTop()
{
}

/// 
void TitleStateTop::HandleInput(float delta)
{
	mModeTransistor.HandleInput(delta);
}

/// XV
void TitleStateTop::Update(float delta)
{
	mModeTransistor.Update(delta);
}

/// `
void TitleStateTop::Render()
{
	mModeTransistor.Render();
}


//====================================================================================================
// Mode
//----------------------------------------------------------------------------------------------------

/* eMODE_TOP */
/// 
void TitleStateTop::TopOn()
{
	// tgGhޏꂳ
	mPStateController->GetDataManager()->GetSprites()[TitleDataManager::eSPRITE_PRESSANYBUTTON]->SetVisible(true);
	mPStateController->GetDataManager()->GetMenu()->SetVisible(false);
}

/// 
void TitleStateTop::TopHandleInput(float delta)
{
	// ̓͂őJ
	IKeyboard* pKB = InputManagerHelper::GetKeyboard();
	if (pKB->IsJustDownAny())
	{
		mModeTransistor.ChangeMode(eMODE_MENU);
	}
}

/// XV
void TitleStateTop::TopUpdate(float delta)
{
}

/* eMODE_MENU */
/// 
void TitleStateTop::MenuOn()
{
	// tgGhޏꂳ
	mPStateController->GetDataManager()->GetSprites()[TitleDataManager::eSPRITE_PRESSANYBUTTON]->SetVisible(false);
	mPStateController->GetDataManager()->GetMenu()->SetVisible(true);
}

/// 
void TitleStateTop::MenuHandleInput(float delta)
{
	// j[
	mPStateController->GetDataManager()->GetMenu()->HandleInput(delta);
	switch (mPStateController->GetDataManager()->GetMenu()->GetInputResultTag())
	{
		case PadInputTag::eINPUT_RESULT_DECIDE:
			break;

		case PadInputTag::eINPUT_RESULT_CANCEL:
			mModeTransistor.ChangeMode(eMODE_TOP);
			break;

		case PadInputTag::eINPUT_RESULT_SELECT:
			break;
	}
}

/// XV
void TitleStateTop::MenuUpdate(float delta)
{
}

/// `
void TitleStateTop::MenuRender()
{
}