#include "Tile.h"

#include "Blast/Base/ResourceManager.h"

using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Base;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Tile::Tile()
	: mChipIndex(-1)
	, mChipInstanceIndex(-1)
	, mTilePosition(0)
	, mWorldPosition(0)
	, mPCrosshair()
{
	// NXwA쐬
	mPCrosshair.SetPointer(NEW CrosshairDX9());
	mPCrosshair->Create(10.0f);
}

/// fXgN^
Tile::~Tile()
{
}


/// 
void Tile::Initialize(int chipIndex, int chipInstanceIndex, const Point& kRTilePos, const Vector3& kRWorldPos)
{
	mChipIndex = chipIndex;
	mChipInstanceIndex = chipInstanceIndex;
	mTilePosition = kRTilePos;
	mWorldPosition = kRWorldPos;

	// NXwA
	mPCrosshair->SetPosition(kRWorldPos);
}

/// XV
void Tile::Update(float delta)
{
}

/// `
void Tile::Render()
{
	// NXwA`
	if (mPCamera && mPCrosshair)
	{
		mPCrosshair->SetCamera(mPCamera);
		mPCrosshair->Render();
	}
}
