#ifndef TAGCONVERTER_H
#define TAGCONVERTER_H

#include "Blast/Design/Noncopyable.h"
#include "ModelTag.h"
#include "RaceTag.h"
#include "AttributeTag.h"
#include "EnemyTag.h"

namespace ItemTag			{ enum EItemTag; }
namespace ItemCommandTag	{ enum EItemCommandTag; }
namespace TrapTag			{ enum ETrapTag; }


/// ^Oƃ^ȎݕϊS
class TagConverter : public Blast::Design::Noncopyable
{
	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

public:
	/// f{^Of{^Oɕϊ
	static ModelTag::EModelTag ToModelBaseTag(const TCHAR* const kPTagName);
	/// f{^Of{^Oɕϊ
	static const TCHAR* const ToModelBaseTagName(ModelTag::EModelTag eTag);
	
	/// 푮^O푮^Oɕϊ
	static RaceTag::ERaceTag ToRaceTag(const TCHAR* const kPTagName);
	/// 푮^O푮^Oɕϊ
	static const TCHAR* const ToRaceTagName(RaceTag::ERaceTag eTag);
	
	/// ^O𑮐^Oɕϊ
	static AttributeTag::EAttributeTag ToAttributeTag(const TCHAR* const kPTagName);
	/// ^O𑮐^Oɕϊ
	static const TCHAR* const ToAttributeTagName(AttributeTag::EAttributeTag eTag);
	
	/// G^OG^Oɕϊ
	static EnemyTag::EEnemyTag ToEnemyTag(const TCHAR* const kPTagName);
	/// G^OG^Oɕϊ
	static const TCHAR* const ToEnemyTagName(EnemyTag::EEnemyTag eTag);

	/// ^O𓹋^Oɕϊ
	static ItemTag::EItemTag ToItemTag(const TCHAR* const kPTagName);
	/// ^O𓹋^Oɕϊ
	static const TCHAR* const ToItemTagName(ItemTag::EItemTag eTag);

	/// R}h^O𓹋R}h^Oɕϊ
	static ItemCommandTag::EItemCommandTag ToItemCommandTag(const TCHAR* const kPTagName);
	/// R}h^O𓹋R}h^Oɕϊ
	static const TCHAR* const ToItemCommandTagName(ItemCommandTag::EItemCommandTag eTag);

	/// 㩃^O㩃^Oɕϊ
	static TrapTag::ETrapTag ToTrapTag(const TCHAR* const kPTagName);
	/// 㩃^O㩃^Oɕϊ
	static const TCHAR* const ToTrapTagName(TrapTag::ETrapTag eTag);

	// ADD:ɎXɒǉ


	//====================================================================================================
	// Implement
	//----------------------------------------------------------------------------------------------------

private:
	/// z񂩂v镶̃CfbNX擾
	static int GetIndexMatchedByName(const TCHAR* const kPName, const TCHAR* const kPNames[], int nameCount);
};

#endif // TAGCONVERTER_H