#include "TagConverter.h"

#include "ItemTag.h"
#include "ItemCommandTag.h"


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	/// f^OQ
	const TCHAR* const nKPModelTagNames[] =
	{
		#include "./Inc/Model/ModelBaseTagName.inc"
	};

	/// 푮^OQ
	const TCHAR* const nKPRaceTagNames[] =
	{
		#include "./Inc/Enemy/RaceTagName.inc"
	};

	/// ^OQ
	const TCHAR* const nKPAttributeTagNames[] =
	{
		#include "./Inc/Enemy/AttributeTagName.inc"
	};

	/// G^OQ
	const TCHAR* const nKPEnemyTagNames[] =
	{
		#include "./Inc/Enemy/EnemyTagName.inc"
	};

	/// ^OQ
	const TCHAR* const nKPItemTagNames[] =
	{
		_T(""),	//< _~[
	};

	/// R}h^OQ
	const TCHAR* const nKPItemCommandTagNames[] =
	{
		_T(""),	//< _~[
	};

	/// 㩃^OQ
	const TCHAR* const nKPTrapTagNames[] =
	{
		#include "./Inc/Trap/TrapTagName.inc"
	};

	// ADD:ɎXɒǉ
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// f^Of^Oɕϊ
ModelTag::EModelTag TagConverter::ToModelBaseTag(const TCHAR* const kPTagName)
{
	const int kMatchedIndex = GetIndexMatchedByName(kPTagName, nKPModelTagNames, SIZE_OF_ARRAY(nKPModelTagNames));
	ModelTag::EModelTag eTag = static_cast<ModelTag::EModelTag>(kMatchedIndex);

	return eTag;
}

/// f^Of^Oɕϊ
const TCHAR* const TagConverter::ToModelBaseTagName(ModelTag::EModelTag eTag)
{
	return nKPModelTagNames[eTag];
}

/// 푮^O푮^Oɕϊ
RaceTag::ERaceTag TagConverter::ToRaceTag(const TCHAR* const kPTagName)
{
	const int kMatchedIndex = GetIndexMatchedByName(kPTagName, nKPRaceTagNames, SIZE_OF_ARRAY(nKPRaceTagNames));
	RaceTag::ERaceTag eTag = static_cast<RaceTag::ERaceTag>(kMatchedIndex);

	return eTag;
}

/// 푮^O푮^Oɕϊ
const TCHAR* const TagConverter::ToRaceTagName(RaceTag::ERaceTag eTag)
{
	return nKPRaceTagNames[eTag];
}

/// ^O𑮐^Oɕϊ
AttributeTag::EAttributeTag TagConverter::ToAttributeTag(const TCHAR* const kPTagName)
{
	const int kMatchedIndex = GetIndexMatchedByName(kPTagName, nKPAttributeTagNames, SIZE_OF_ARRAY(nKPAttributeTagNames));
	AttributeTag::EAttributeTag eTag = static_cast<AttributeTag::EAttributeTag>(kMatchedIndex);

	return eTag;
}

/// ^O𑮐^Oɕϊ
const TCHAR* const TagConverter::ToAttributeTagName(AttributeTag::EAttributeTag eTag)
{
	return nKPAttributeTagNames[eTag];
}

/// G^OG^Oɕϊ
EnemyTag::EEnemyTag TagConverter::ToEnemyTag(const TCHAR* const kPTagName)
{
	const int kMatchedIndex = GetIndexMatchedByName(kPTagName, nKPEnemyTagNames, SIZE_OF_ARRAY(nKPEnemyTagNames));
	EnemyTag::EEnemyTag eTag = static_cast<EnemyTag::EEnemyTag>(kMatchedIndex);

	return eTag;
}

/// G^OG^Oɕϊ
const TCHAR* const TagConverter::ToEnemyTagName(EnemyTag::EEnemyTag eTag)
{
	return nKPEnemyTagNames[eTag];
}

/// ^O𓹋^Oɕϊ
ItemTag::EItemTag TagConverter::ToItemTag(const TCHAR* const kPTagName)
{
	const int kMatchedIndex = GetIndexMatchedByName(kPTagName, nKPItemTagNames, SIZE_OF_ARRAY(nKPItemTagNames));
	ItemTag::EItemTag eTag = static_cast<ItemTag::EItemTag>(kMatchedIndex);

	return eTag;
}
/// ^O𓹋^Oɕϊ
const TCHAR* const TagConverter::ToItemTagName(ItemTag::EItemTag eTag)
{
	return nKPItemTagNames[eTag];
}

/// R}h^O𓹋R}h^Oɕϊ
ItemCommandTag::EItemCommandTag TagConverter::ToItemCommandTag(const TCHAR* const kPTagName)
{
	const int kMatchedIndex = GetIndexMatchedByName(kPTagName, nKPItemCommandTagNames, SIZE_OF_ARRAY(nKPItemCommandTagNames));
	ItemCommandTag::EItemCommandTag eTag = static_cast<ItemCommandTag::EItemCommandTag>(kMatchedIndex);

	return eTag;
}

/// R}h^O𓹋R}h^Oɕϊ
const TCHAR* const TagConverter::ToItemCommandTagName(ItemCommandTag::EItemCommandTag eTag)
{
	return nKPItemCommandTagNames[eTag];
}

/// 㩃^O㩃^Oɕϊ
TrapTag::ETrapTag TagConverter::ToTrapTag(const TCHAR* const kPTagName)
{
	const int kMatchedIndex = GetIndexMatchedByName(kPTagName, nKPTrapTagNames, SIZE_OF_ARRAY(nKPTrapTagNames));
	return static_cast<TrapTag::ETrapTag>(kMatchedIndex);
}

/// 㩃^O㩃^Oɕϊ
const TCHAR* const TagConverter::ToTrapTagName(TrapTag::ETrapTag eTag)
{
	return nKPTrapTagNames[eTag];
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// z񂩂v镶̃CfbNX擾
int TagConverter::GetIndexMatchedByName(const TCHAR* const kPName, const TCHAR* const kPNames[], int nameCount)
{
	for (int i = 0; i < nameCount; ++i)
	{
		if (_tcscmp(kPName, kPNames[i]) == 0)
		{
			return i;
		}
	}

	ASSERT_PF(NULL, _T("v镶񂪂܂łBkPName=%s"), kPName);
	return -1;
}