#ifndef SKINMESH_H
#define SKINMESH_H

#include "Blast/Graphic/DirectX9/VertexBufferDX9.h"
#include "Blast/Graphic/DirectX9/IndexBufferDX9.h"
#include "Blast/Graphic/DirectX9/VertexDeclarationDX9.h"
#include "Blast/Graphic/DirectX9/ShaderEffectDX9.h"
#include "Blast/Graphic/SkeletonFbx.h"
#include "Blast/Graphic/ITexture2D.h"


/// FBXt@C̃bVێNX
class SkinMesh
	//: public Blast::Base::IResource	///< \[X֘Ȁ͖Ȃ̂ňUCO
	//public Blast::Graphic::IMesh		///< TubVŕ`̓𕪂邱ƂѓȂƂ̂̂Ȃ̂CO
{
public:
	//====================================================================================================
	// Enumerate
	//----------------------------------------------------------------------------------------------------

	/// _obt@̎
	enum EVertexBuffer
	{
		eVERTEXBUFFER_POSITION,			///< ʒu
		eVERTEXBUFFER_UV,				///< UV
		eVERTEXBUFFER_NORMAL,			///< @
		eVERTEXBUFFER_BONE_INDEX,		///< {[CfbNX
		eVERTEXBUFFER_BONE_WEIGHT,		///< {[EFCg
		eVERTEXBUFFER_INSTANCE_INDEX,	///< CX^XCfbNX

		/// 񋓗vf̐
		eVERTEXBUFFER_COUNT,
	};


	//====================================================================================================
	// Static
	//----------------------------------------------------------------------------------------------------

	/// CX^X̃CfbNX̍ő吔B
	/// VF[_[萔z̗vfĂKvB
	static const int MAX_INSTANCE_INDEX = 5;


	//====================================================================================================
	// Struct
	//----------------------------------------------------------------------------------------------------

	struct SSubMesh
	{
	public:
		/// RXgN^
		SSubMesh()
			: mIndexOffset(0)
			, mTriangleCount(0)
		{
		}

		/// CfbNX̃ItZbg
		int mIndexOffset;

		/// Op`|S̐
		int mTriangleCount;
	};


	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	SkinMesh();

	/// fXgN^
	virtual ~SkinMesh();

	/// 
	void Initialize(fbxsdk_2012_2::KFbxNode* pFbxNode, fbxsdk_2012_2::KFbxMesh* pFbxMesh);

	/// `̑OBVF[_[ŕ`悪JnOɌĂ΂́B
	void BeginRender();

	/// `
	virtual void Render(int materialIndex);


	/// CX^Xǉ
	void AddInstance(int count);
	/// CX^XO
	void RemoveInstance(int count);


	/// m[h擾
	fbxsdk_2012_2::KFbxNode* GetNode() { return mPFbxNode; }

	/// bV擾
	fbxsdk_2012_2::KFbxMesh* GetMesh() { return mPFbxMesh; }

	/// TubV̐擾
	int GetSubMeshCount() const { return mSubMeshes.GetCount(); }

private:
	/// Fbxm[h
	fbxsdk_2012_2::KFbxNode* mPFbxNode;

	/// FbxbV
	fbxsdk_2012_2::KFbxMesh* mPFbxMesh;

	/// _̐
	int mVertexCount;

	/// e풸_
	/// {[̃CfbNX̂ݗ]ɂȂĂB
	SP<float> mPVertices[eVERTEXBUFFER_COUNT];

	/// {[CfbNX̏
	/// floatł͂ȂBYTEȂ̂ŕʓrBƂӌɂ͓B
	SP<BYTE> mPBoneIndices;

	/// CfbNX
	SP<int> mPIndices;

	/// o[ebNXobt@Q
	SP<Blast::Graphic::VertexBufferDX9> mPVertexBuffers[eVERTEXBUFFER_COUNT];

	/// _`
	SP<Blast::Graphic::VertexDeclarationDX9> mPVertexDeclaration;

	/// CfbNXobt@Q
	SP<Blast::Graphic::IndexBufferDX9> mPIndexBuffer;

	/// TubVQ
	fbxsdk_2012_2::KArrayTemplate<SSubMesh*> mSubMeshes;

	/// CX^X̐BIWȉ1ƂăJEgB
	int mInstanceCount;

	bool mIsHasNormal;			///< @邩ǂ
	bool mIsHasUV;				///< UV邩ǂ
	bool mIsHasSkin;			///< XL邩ǂ
    bool mIsAllByControlPoint;	///< Save data in VBO by control point or by polygon vertex.


	//====================================================================================================
	// Implement
	//----------------------------------------------------------------------------------------------------

	/// CX^XύXɂobt@̍č쐬s
	void ReCreateBuffers();
};

#endif // SKINMESH_H