#include "Sequence/Debug/DebugSequenceMainMenu.h"

#include "Camera2D.h"
#include "../MainMenuSequence.h"
#include "DebugSequencePossession.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Input;
using namespace Blast::Math;
using namespace Blast::String;
using namespace Sequence::Debug;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	/// Gg[Q
	const TCHAR* const nKPEntryNames[] =
	{
		_T("MainMenu"),
		_T("Possession"),
	};

	/// Gg[̐
	const int nKEntryNameCount = SIZE_OF_ARRAY(nKPEntryNames);
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceMainMenu::DebugSequenceMainMenu()
	: SequenceBase(false)
	, mPCamera(NULL)
{
}

/// fXgN^
DebugSequenceMainMenu::~DebugSequenceMainMenu()
{
}

/// 
void DebugSequenceMainMenu::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// J쐬
	SP<Camera2D> pCamera2D(NEW Camera2D());
	mPCamera = pCamera2D;

	mPGameComponents->Add(pCamera2D);


	// fobOj[쐬
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("DebugSequenceMainMenu");

	// j[GgXg쐬
	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->GetPropertyRef().mNameStr = _T("<j[>");

	mPDebugMenu->AddMenuEntryList(pMEL);

	// Gg[ǉ
	for (int i = 0; i < nKEntryNameCount; ++i)
	{
		SP<MenuEntry> pME(NEW MenuEntry());
		pME->SetName(nKPEntryNames[i]);
		pME->SetText(nKPEntryNames[i]);

		pMEL->AddMenuEntry(pME);
	}
}

/// 
void DebugSequenceMainMenu::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);

	// ͏
	IKeyboard* pKB = InputManagerHelper::GetKeyboard();
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		SP<IMenuEntryList> pSelectedList = mPDebugMenu->GetSelectedMenuEntryList();
		SP<IMenuEntry> pME = pSelectedList->GetSelectedMenuEntry();

		// MainMenuV[PXǉ
		if (pME == pSelectedList->GetMenuEntry(nKPEntryNames[0]))
		{
			SequenceManager* pSM = SequenceManager::GetInstance();

			SP<MainMenuSequence> pMainMenuSequence(NEW MainMenuSequence(false));
			pSM->AddSequence(pMainMenuSequence);
		}

		// i𑀍삷V[PXǉB
		if (pME == pSelectedList->GetMenuEntry(nKPEntryNames[1]))
		{
			SequenceManager* pSM = SequenceManager::GetInstance();
			SP<DebugSequencePossession> pSeq(NEW DebugSequencePossession(false));
			pSM->AddSequence(pSeq);
		}
	}
}

/// XV
void DebugSequenceMainMenu::Update(float delta)
{
	// ̍XV
	SequenceBase::Update(delta);
}

/// `
void DebugSequenceMainMenu::Render()
{
	// ̕`揈
	SequenceBase::Render();
}