#include "Sequence/Debug/DebugSequenceMainGame.h"

#include "../MainGameSequence.h"
#include "Blast/Graphic/RenderOrderCriteria.h"
#include "Blast/Math/MathHelper.h"

using namespace Sequence::Debug::Dungeon;
using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceMainGame::DebugSequenceMainGame()
	: SequenceBase(false)
	, mCreateMapNumberDebug(0)
	, mCreateFloorNumberDebug(0)
{
}

/// fXgN^
DebugSequenceMainGame::~DebugSequenceMainGame()
{
}


/// 
void DebugSequenceMainGame::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// fobOj[̖Oݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("<DebugSequenceMainGame>");


	// tAɊւGg[Xg쐬
	SP<MenuEntryListScroll> pMELFloor(NEW MenuEntryListScroll());
	pMELFloor->GetPropertyRef().mNameStr = _T("<tA̍쐬>");
	mPDebugMenu->AddMenuEntryList(pMELFloor);

	// tAɊւfobOGg[ǉ
	SP<MenuEntryNumeric<int>> pMEMapNumber(NEW MenuEntryNumeric<int>());
	pMEMapNumber->SetName(_T("MapNumber"));
	pMEMapNumber->SetText(_T("}bv̔ԍ"));
	pMEMapNumber->SetNumericPointer(&mCreateMapNumberDebug);
	pMEMapNumber->SetLimitUnder(0);
	pMEMapNumber->SetLimitOver(0);
	pMELFloor->AddMenuEntry(pMEMapNumber);

	SP<MenuEntryNumeric<int>> pMEFloorNumber(NEW MenuEntryNumeric<int>());
	pMEFloorNumber->SetName(_T("FloorNumber"));
	pMEFloorNumber->SetText(_T("tÅKw"));
	pMEFloorNumber->SetNumericPointer(&mCreateFloorNumberDebug);
	pMEFloorNumber->SetLimitUnder(0);
	pMEFloorNumber->SetLimitOver(9);
	pMELFloor->AddMenuEntry(pMEFloorNumber);

	SP<MenuEntry> pMEFloorCreate(NEW MenuEntry());
	pMEFloorCreate->SetName(_T("FloorCreate"));
	pMEFloorCreate->SetText(_T("!쐬!"));
	pMELFloor->AddMenuEntry(pMEFloorCreate);
}

/// 
void DebugSequenceMainGame::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);


	// L[{[h擾
	IKeyboard* pKB = InputManagerHelper::GetKeyboard();

	// 肵ȂAe퍀ڂŏ
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		SP<IMenuEntryList> pList = mPDebugMenu->GetSelectedMenuEntryList();
		SP<IMenuEntry> pEntry = pList->GetSelectedMenuEntry();

		// 荀ڂtA̍쐬ȂA쐬
		if (_tcsicmp(pEntry->GetName(), _T("FloorCreate")) ==0)
		{
			// l쐬
			MainGameSequence::SInitialData sData;
			sData.mDungeonNumber = mCreateMapNumberDebug;
			sData.mFloorNumber = mCreateFloorNumberDebug;

			// V[PXǉ
			SequenceManager* pSM = Blast::Base::SequenceManager::GetInstance();
			SP<ISequence> pSeq(NEW MainGameSequence(&sData));
			pSM->AddSequence(pSeq);
		}
	}
}

/// XV
void DebugSequenceMainGame::Update(float delta)
{
	// ̍XV
	SequenceBase::Update(delta);
}

/// `
void DebugSequenceMainGame::Render()
{
	// ̕`揈
	SequenceBase::Render();
}
