#ifndef SEQUENCE_DEBUG_DEBUGSEQUENCEFILE_H
#define SEQUENCE_DEBUG_DEBUGSEQUENCEFILE_H

#include "Blast/Base/SequenceBase.h"


namespace Sequence
{
	namespace Debug
	{
		/// t@C̏̊mFs{V[PXNX
		class DebugSequenceFile : public Blast::Base::SequenceBase
		{
		public:
			//====================================================================================================
			// Enume
			//----------------------------------------------------------------------------------------------------

			/// ǂݍ݂̎
			enum ELoadMethod
			{
				/// Xg[g1sɓǂݍ
				eLOADMETHOD_STREAM_LINES,

				/// Xg[găXg[gĈꊇǂݍ
				eLOADMETHOD_STREAM_BULK,


				/// FILEg1sɓǂݍ
				eLOADMETHOD_FILE_LINE,

				/// FILEgĒPꂲƂɓǂݍ
				eLOADMETHOD_FILE_WORD,

				/// FILEgĈꊇǂݍ
				eLOADMETHOD_FILE_BULK,


				/// FileNXgčsƂɓǂݍ
				eLOADMETHOD_FILECLASS_LINE,


				/// CSVFileNXgēǂݍ
				eLOADMETHOD_CSVFILECLASS,


				/// 񋓗vf̐
				eLOADMETHOD_COUNT,
			};


			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// Gg[̔z
			static const TCHAR* const mStKPEntryNames[];


			/// t@C
			static const TCHAR* mStKPFileFullPaths[];

			/// t@C̐
			static const int mStKFileFullPathCount;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			DebugSequenceFile();

			/// fXgN^
			virtual ~DebugSequenceFile();


			/// 
			virtual void Initialize();

			/// 
			virtual void HandleInput(float);

		private:
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// Xg[g1sƂɓǂݍ
			void LoadStreamLines(const TCHAR* kPFullPath);

			/// Xg[gĈꊇǂݍ
			void LoadStreamBulk(const TCHAR* kPFullPath);


			/// FILEg1sƂɓǂݍ
			void LoadFileLine(const TCHAR* kPFullPath);

			/// FILEgĒPꂲƂɓǂݍ
			void LoadFileWord(const TCHAR* kPFullPath);

			/// FILEgĈꊇǂݍ
			void LoadFileBulk(const TCHAR* kPFullPath);


			/// FileNXg1sɓǂݍ
			void LoadFileClassLine(const TCHAR* kPFullPath);


			/// FileNXgĈꊇ
			void WriteFileBulk(const TCHAR* kPFullPath);


			/// CSVFileNXgēǂݍ
			void LoadFileCSV(const TCHAR* kPFullPath);
		};

	} // namespace Debug
} // namespace Sequence

#endif // SEQUENCE_DEBUG_DEBUGSEQUENCEFILE_H