#include "Sequence/Debug/DebugSequenceDirectory.h"

#include "Blast/Storage/Directory.h"

using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Storage;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceDirectory::DebugSequenceDirectory()
	: SequenceBase(false)
{
}

/// fXgN^
DebugSequenceDirectory::~DebugSequenceDirectory()
{
}


/// `
void DebugSequenceDirectory::Render()
{
	// ̕`揈
	SequenceBase::Render();


	// JgfBNgύX
	const tstring firstChangeTargetDirectoryPathStr = _T("C:/Blast/P1/Program/Projects/BlastLibrary/BlastLibraryLaboratory");
	Directory::SetCurrentDirectoryPath(firstChangeTargetDirectoryPathStr.c_str());

	DP(10, 10, 0xffff4400, _T("[JgfBNgύX]"));
	DP(10, 22, 0xffffffff, _T("%s"), firstChangeTargetDirectoryPathStr.c_str());

	// pX֘Ȁ`
	RenderPathWork(10, 50);


	// JgfBNgύX
	const tstring secondChangeTargetDirectoryPathStr = Directory::GetExeAbsolutePath();
	Directory::SetCurrentDirectoryPath(secondChangeTargetDirectoryPathStr.c_str());

	DP(10, 280, 0xffff4400, _T("[JgfBNgύX]"));
	DP(10, 292, 0xffffffff, _T("%s"), secondChangeTargetDirectoryPathStr.c_str());

	// xpX֘Ȁ`
	RenderPathWork(10, 350);
}

//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// `悷YWʒuZo
void DebugSequenceDirectory::CalculateRenderPositionY(int& rOutY, int& rLineIndex, int addLineIndex)
{
	// s
	const int kLineSpacing = 12;

	// CfbNXZ
	rLineIndex += addLineIndex;

	// Zo
	rOutY = kLineSpacing * rLineIndex;
}

/// pX֘Ȁ`
void DebugSequenceDirectory::RenderPathWork(int x, int y)
{
	// `ʒu
	int posX = x;
	int posY = y;


	// o̍s
	const int kSubheadSpacing = 12;

	// o̐F
	const UInt32 kSubheadColor = 0xff00ffff;

	// pX̐F
	const Blast::Graphic::Color kPathColor = 0xffffffff;

	// sCfbNX
	int lineIndex = 0;


	// JgfBNgpX`
	CalculateRenderPositionY(posY, lineIndex, 0);
	DP(posX, posY + y, kSubheadColor, _T("[JgfBNg]"));
	DP(posX, posY + y + kSubheadSpacing, kPathColor.GetARGB(), _T("%s"), Directory::GetCurrentDirectoryAbsolutePath().c_str());


	// ΃pX΃pXւ̕ϊ`
	const tstring kRelativePath = _T("./Res/Test/Model/");
	const tstring kTargetFileName = _T("TestModel.fbx");
	const tstring kRelativeFullPath = kRelativePath + kTargetFileName;
	tstring absPath = Directory::ToAbsolutePath(kRelativeFullPath.c_str());

	CalculateRenderPositionY(posY, lineIndex, 5);
	DP(posX, posY + y, kSubheadColor, _T("[΃pX]"));
	DP(posX, posY + y + kSubheadSpacing, kPathColor.GetARGB(), _T("%s"), kRelativePath.c_str());

	CalculateRenderPositionY(posY, lineIndex, 3);
	DP(posX, posY + y, kSubheadColor, _T("[΃pX]"));
	DP(posX, posY + y + kSubheadSpacing, kPathColor.GetARGB(), _T("%s"), absPath.c_str());


	// ΃tpX̃fBNg擾`
	tstring absFullPath = Directory::GetDirectoryPath(absPath.c_str());
	
	CalculateRenderPositionY(posY, lineIndex, 5);
	DP(posX, posY + y, kSubheadColor, _T("[΃fBNgpX]"));
	DP(posX, posY + y + kSubheadSpacing, kPathColor.GetARGB(), _T("%s"), absFullPath.c_str());
}