#include "ModelCSV.h"

#include "Blast/IO/CSVFile.h"
#include "Blast/IO/CSVTable.h"
#include "Blast/IO/CSVRecord.h"

#include "ModelTag.h"
#include "TagConverter.h"

using namespace Blast::IO;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
ModelCSV::ModelCSV()
{
	Reload();
}

/// fXgN^
ModelCSV::~ModelCSV()
{
}

/// ēǂݍ
void ModelCSV::Reload()
{
	LoadBaseData();
	// ADD:ɒǉĂB
}

/// {Q擾
const SP<ModelCSV::SBase> ModelCSV::GetBaseDatas() const
{
	return mSBaseDatas;
}
/// {擾
const ModelCSV::SBase* ModelCSV::GetBaseData(ModelTag::EModelTag eTag) const
{
	return &mSBaseDatas[eTag];
}


//====================================================================================================
// Imeplement
//----------------------------------------------------------------------------------------------------

/// {̓ǂݍ
void ModelCSV::LoadBaseData()
{
	// CSVt@CWJ
	CSVFile csv(_T("./Res/DB/Model/ModelBase.bin"));
	bool isCSVOk = csv.Create();
	if (!isCSVOk)
	{
		return;
	}

	// CSVt@C̏𔲐
	const SP<CSVTable> pDT = csv.GetDataTable();
	const int kRecordCount = pDT->GetRecordCount();

	mSBaseDatas.SetPointer(NEW SBase[kRecordCount], true);
	for (int i = 0; i < kRecordCount; ++i)
	{
		const SP<CSVRecord> kPRecord = pDT->GetRecord(i);

		SBase* pDst = &mSBaseDatas[i];
		pDst->mID			= kPRecord->GetItem(_T("ID"))->GetValueRef().ToInteger();
		pDst->mEModelTag	= TagConverter::ToModelBaseTag( kPRecord->GetItem(_T("^O"))->GetValueRef().ToCharacter() );
		_tcscpy_s(pDst->mFilePath, SIZE_OF_ARRAY(pDst->mFilePath), kPRecord->GetItem(_T("t@CpX"))->GetValueRef().ToCharacter());
	}
}