#include "MessageWindow.h"

#include "Blast/Graphic/DirectX9/SpriteFontDX9.h"

using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MessageWindow::MessageWindow()
{
}

/// fXgN^
MessageWindow::~MessageWindow()
{
}


/// XV
void MessageWindow::Update(float delta)
{
	// EBhEXV
	if (mPGameWindow)
	{
		mPGameWindow->Update(delta);
	}
	
	// bZ[WeLXgXV
	if (mPMessageText)
	{
		mPMessageText->Update(delta);
	}
}

/// `
void MessageWindow::Render()
{
	// EBhE`
	if (mPGameWindow)
	{
		mPGameWindow->Render();
	}

	// bZ[WeLXg`
	if (mPMessageText)
	{
		mPMessageText->Render();
	}
}


/// 쐬
bool MessageWindow::Create(const Vector3& kRWindowPosition, const Vector2& kRWindowSize)
{
	// EBhE쐬
	mPGameWindow.SetPointer(NEW GameWindow());
	mPGameWindow->SetPosition(kRWindowPosition);
	mPGameWindow->SetSize(kRWindowSize);


	// bZ[WeLXg쐬
	mPMessageText.SetPointer(NEW MessageText());

	SP<SpriteFontDX9> pFont(NEW SpriteFontDX9(Font::stKPFontName, 24, Font::stKFontWeight));
	mPMessageText->SetFont(pFont);

	// \ʒuݒ
	const Vector2 kHalfWindowSize(kRWindowSize.mX / 2, kRWindowSize.mY / 2);
	const Vector2 kTextStartOffset(8.0f, 0.0f);

	Vector3 textStartPos;
	textStartPos.mX = kRWindowPosition.mX - kHalfWindowSize.mX;
	textStartPos.mY = kRWindowPosition.mY - kHalfWindowSize.mY + pFont->GetPointSize() + kTextStartOffset.mY;

	mPMessageText->SetPosition(textStartPos);

	mPMessageText->SetText(_T("̓eXg\nłB"));


	return true;
}


//====================================================================================================
// Transfar
//----------------------------------------------------------------------------------------------------

/// Jݒ
void MessageWindow::SetCamera(const SP<ICamera> pCamera)
{
	// EBhEɃJݒ
	mPGameWindow->SetCamera(pCamera);

	// bZ[WeLXgɃJݒ
	mPMessageText->SetCamera(pCamera);
}


/// ǉ
void MessageWindow::AddText(const TCHAR* const kPText)
{
	mPMessageText->AddText(kPText);
}

/// ̕\
void MessageWindow::NextText(float lifeTime, float moveTime)
{
	mPMessageText->NextText(lifeTime, moveTime);
}
