#include "MainMenuStateTop.h"

#include "Blast/Input/PadInputTag.h"
#include "./Sequence/MainMenuSequence.h"
#include "MainMenuStateController.h"

using namespace Blast::Frontend;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainMenuStateTop::MainMenuStateTop(MainMenuStateController* pStateController)
	: mPStateController(pStateController)
{
	// tgGh
	GetDataManager()->GetFETop()->SetHandleInput(true);
	GetDataManager()->GetFETop()->SetVisible(true);
	GetDataManager()->GetFEItem()->SetHandleInput(false);
	GetDataManager()->GetFEItem()->SetVisible(false);
	GetDataManager()->GetFEConduct()->SetHandleInput(false);
	GetDataManager()->GetFEConduct()->SetVisible(false);
	GetDataManager()->GetFEDescription()->SetHandleInput(false);
	GetDataManager()->GetFEDescription()->SetVisible(false);
}

/// fXgN^
MainMenuStateTop::~MainMenuStateTop()
{
}

/// 
void MainMenuStateTop::HandleInput(float delta)
{
	// UNDONE:j[̓͌ʂŏ𕪊
	SP<FEMenu> pMenu = GetDataManager()->GetFETop()->GetMenu();
	PadInputTag::EPadInputTag eResult = pMenu->GetInputResultTag();
	switch (eResult)
	{
		// 
		case PadInputTag::eINPUT_RESULT_DECIDE:
		{
			MainMenuFETop::EMenuEntry eEntry = (MainMenuFETop::EMenuEntry)pMenu->GetSelectedIndex();
			switch (eEntry)
			{
				case MainMenuFETop::eMENUENTRY_ITEM:
				{
					// j[̏ԂɑJ
					GetDataManager()->GetFETop()->SetHandleInput(false);
					GetDataManager()->GetFETop()->SetVisible(false);
					mPStateController->ChangeState(MainMenuStateController::eSTATE_ITEM);
				}
					break;
				case MainMenuFETop::eMENUENTRY_STEP:
					// 
					//mPStateController->ChangeState(MainMenuStateController::eSTATE_STEP);
					break;
				case MainMenuFETop::eMENUENTRY_FUNCTION:
					// 
					//mPStateController->ChangeState(MainMenuStateController::eSTATE_OPTION);
					break;

				default:
					break;
			}
		}
			break;

		// 
		case PadInputTag::eINPUT_RESULT_CANCEL:
			break;

		// I
		case PadInputTag::eINPUT_RESULT_SELECT:
			break;

		// ̑
		default:
			break;
	}
}

/// XV
void MainMenuStateTop::Update(float delta)
{
}

/// `
void MainMenuStateTop::Render()
{
	DP(10, 10, 0xffffffff, _T("MainMenuStateTopB"));
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// Ǘ擾
SP<MainMenuDataManager> MainMenuStateTop::GetDataManager()
{
	return mPStateController->GetSequence()->GetDataManager();
}