#include "MainMenuFEConduct.h"

#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"
#include "Blast/Frontend/FEMenuEntryText.h"
#include "ItemDatabase.h"

#include "ItemTag.h"
#include "ItemCommandTag.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;
using namespace Blast::Frontend;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	/// Gg[̍ő吔BSĕ`悷Ƃ͌ȂB
	const int nKEntryCount = 7;

	/// UNDONE:ނɂ鍀ڂ̊UBJeSł̂̂┠Ȃǂ̍ږ͕ς邼I@@ACe̕ǂH
	const TCHAR* nEntryNamesWeapon[] =
	{
		_T(""), _T(""), _T("u"), _T(""),
	};
	const int nEntryNameCountWeapon = SIZE_OF_ARRAY(nEntryNamesWeapon);

	const TCHAR* nEntryNamesShield[] =
	{
		_T(""), _T(""), _T("u"), _T(""),
	};
	const int nEntryNameCountShield = SIZE_OF_ARRAY(nEntryNamesShield);

	const TCHAR* nEntryNamesPendant[] =
	{
		_T(""), _T(""), _T("u"), _T(""),
	};
	const int nEntryNameCountPendant = SIZE_OF_ARRAY(nEntryNamesPendant);

	const TCHAR* nEntryNamesExe[] =
	{
		_T("N"), _T(""), _T("u"), _T(""),
	};
	const int nEntryNameCountExe = SIZE_OF_ARRAY(nEntryNamesExe);

	const TCHAR* nEntryNamesBox[] =
	{
		_T(""), _T(""),  _T("o"), _T(""), _T("u"), _T(""),
	};
	const int nEntryNameCountBox = SIZE_OF_ARRAY(nEntryNamesBox);

	const TCHAR* nEntryNamesPatch[] =
	{
		_T("N"), _T(""), _T("u"), _T(""),
	};
	const int nEntryNameCountPatch = SIZE_OF_ARRAY(nEntryNamesPatch);

	const TCHAR* const nKConductNames[][nKEntryCount] =
	{
		{ _T(""), _T(""), _T("u"), _T(""), },
		{ _T(""), _T(""), _T("u"), _T(""), },
		{ _T(""), _T(""), _T("u"), _T(""), },
		{ _T(""), _T(""), _T("u"), _T(""), },
		{ _T(""), _T(""),  _T("o"), _T(""), _T("u"), _T(""), },
		{ _T("N"), _T(""), _T("u"), _T(""), },
	};

	/// {̓ACeƂɌ܂ĂeB
	const ItemCommandTag::EItemCommandTag nKETestTags[] =
	{
		ItemCommandTag::eITEM_COMMAND_LAUNCH,
		ItemCommandTag::eITEM_COMMAND_THROW,
		ItemCommandTag::eITEM_COMMAND_PUT,
		ItemCommandTag::eITEM_COMMAND_DESCRIPTION,
	};

	/// DataManagerAItemCommandXmlȂǁA֌W̍ꏊɒûǂB
	/// R}h^O\p擾
	/// ^OItemCommandTag.hɋLڂĂB
	const TCHAR* GetCommandName(ItemCommandTag::EItemCommandTag eTag)
	{
		const TCHAR* const nKPCommandNames[ItemCommandTag::eITEM_COMMAND_COUNT] =
		{
			_T("gp"),
			_T("N"),
			_T(""),
			_T("Hׂ"),
			_T(""),
			_T("u"),
			_T("`"),
			_T(""),
			_T("o"),
			_T("Lq"),
			_T(""),
		};

		return nKPCommandNames[eTag];
	};
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainMenuFEConduct::MainMenuFEConduct()
	: mPCamera(NULL)
	, mPWindow(NULL)
	, mIsHandleInput(true)
	, mIsEnable(true)
	, mIsVisible(true)
	, mESelectedCommandTag(ItemCommandTag::eITEM_COMMAND_INVALID)
{
	// 2DJZbgAbv
	mPCamera.SetPointer(NEW Camera2D());
	
	// EBhE쐬
	mPWindow.SetPointer(NEW SpriteDX9());
	mPWindow->SetCamera(mPCamera);

	ResourceManager* pRM = ResourceManager::GetInstance();
	SP<FileTexture2DDX9> pTex = pRM->Load<FileTexture2DDX9>(_T("./Res/Sprite/Window/ItemConductWindow.png"));
	mPWindow->SetTexture(pTex);
	mPWindow->FitTextureSize();

	// HACK:eɂȂĂ
	const Vector3 kLeftUpPosition(800, 128, 0);
	Vector3 pos = kLeftUpPosition;
	mPWindow->SetPosition(pos);

	mPWindow->SetOrigin(SpriteDX9::eORIGIN_UP_LEFT);

	// j[쐬
	mPMenu.SetPointer(NEW FEMenu());
	mPMenu->SetPosition( Vector3(800, 128, 0) );
}

/// fXgN^
MainMenuFEConduct::~MainMenuFEConduct() { }


/// 
void MainMenuFEConduct::Initialize()
{
}

/// 
void MainMenuFEConduct::HandleInput(float delta)
{
	if (!mIsHandleInput)
	{
		return;
	}

	// j[̓
	mPMenu->HandleInput(delta);

	// IĂR}h̃^O擾
	mESelectedCommandTag = nKETestTags[ mPMenu->GetSelectedIndex() ];
}

/// XV
void MainMenuFEConduct::Update(float delta)
{
	if (!mIsEnable)
	{
		return;
	}

	// J̍XV
	mPCamera->Update(delta);

	// EBhE̍XV
	if (mPWindow)
	{
		mPWindow->Update(delta);
	}

	// j[̍XV
	mPMenu->Update(delta);
}

/// `
void MainMenuFEConduct::Render()
{
	if (!mIsVisible)
	{
		return;
	}

	// EBhE̕`
	if (mPWindow)
	{
		mPWindow->Render();
	}

	// j[̕`
	mPMenu->Render();

	// ̎
	DP(10, 500, ColorCode::ToCode(ColorCode::eCOLOR_WHITE), _T("Fڂ̑I"));
}

/// \R}h̓ݒ
void MainMenuFEConduct::SetItem(ItemTag::EItemTag eTag)
{
	mPMenu->Clear();

	// UNDONE:IĂACȅ񂩂AKvȃR}h擾B
	for (int i = 0; i < ItemCommandTag::eITEM_COMMAND_COUNT; ++i)	//< Sđ
	{
		ItemCommandTag::EItemCommandTag eCommandTag = static_cast<ItemCommandTag::EItemCommandTag>(i);

		// HACK:for̃lXg͌Â炢ȁB̓\bhŗpӂĂƔėpIŕ֗B
		for (int j = 0; j < SIZE_OF_ARRAY(nKETestTags); ++j)
		{
			if (eCommandTag == nKETestTags[j])	//< nKETestTags[j]̓eLg[B{͓Ƃɐݒ肳ĂB
			{
				const TCHAR* const kPConductName = GetCommandName(eCommandTag);
				if (kPConductName && _tcscmp(kPConductName, _T("")) != 0)	//< |C^̗LƁA󕶎̔Ă
				{
					SP<FEMenuEntryText> pFEText(NEW FEMenuEntryText());
					pFEText->SetCamera(mPCamera);
					pFEText->SetText(kPConductName);

					mPMenu->AddItem(pFEText);
				}

				break;
			}
		}
	}
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// ̓tO擾
bool MainMenuFEConduct::IsHandleInput() const
{
	return mIsHandleInput;
}

/// ̓tOݒ
void MainMenuFEConduct::SetHandleInput(bool value)
{
	mIsHandleInput = value;
}

/// XVtO擾
bool MainMenuFEConduct::IsEnbale() const
{
	return mIsEnable;
}

/// XVtOݒ
void MainMenuFEConduct::SetEnable(bool value)
{
	mIsEnable = value;
}

/// `tO擾
bool MainMenuFEConduct::IsVisible() const
{
	return mIsVisible;
}

/// `tOݒ
void MainMenuFEConduct::SetVisible(bool value)
{
	mIsVisible = value;
}

/// j[擾
SP<FEMenu> MainMenuFEConduct::GetMenu()
{
	return mPMenu;
}

/// IĂR}h̃^O擾
ItemCommandTag::EItemCommandTag MainMenuFEConduct::GetSelectedCommandTag() const
{
	return mESelectedCommandTag;
}
