#include "MainGameDataManager.h"

using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainGameDataManager::MainGameDataManager()
	: mPCamera3D(NEW Camera3DOperation())
	, mPEnemyChipset(NEW EnemyChipset())
	, mPPlayer(NEW Character())
#if _DEBUG
	, mPXYZAxis(NEW XYZAxisDX9())
	, mPGrid(NEW GridDX9())
	, mPCrosshair(NEW CrosshairDX9())
#endif // _DEBUG
{
	// J쐬
	Vector3 cameraInitPos(0.0f, 2.0f, -1.0f);
	cameraInitPos *= 300;
	mPCamera3D->SetPosition(cameraInitPos);

#if _DEBUG
	// XYZ
	mPXYZAxis->SetCamera(mPCamera3D);
	mPXYZAxis->SetLength(100000.0f);

	// Obh쐬
	mPGrid->Create();
	mPGrid->SetCamera(mPCamera3D);

	// NXwA쐬
	mPCrosshair.SetPointer(NEW CrosshairDX9());
	mPCrosshair->Create(100.0f);
	mPCrosshair->SetCamera(mPCamera3D);
#endif // _DEBUG

	// n`
	mPTerrainGrid.SetPointer(NEW TerrainGrid());

	// Ǘ
	mPDropItemManager.SetPointer(NEW DropItemManager());

	// ̊Ǘ
	mPUnitManager.SetPointer(NEW UnitManager());

	// 㩂̊Ǘ
	mPTrapManager.SetPointer(NEW TrapManager());

	// lNXg}X̊Ǘ
	mPNextMassManager.SetPointer(NEW NextMassManager());
}

/// fXgN^
MainGameDataManager::~MainGameDataManager()
{
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// J擾
SP<Camera3DOperation> MainGameDataManager::GetCamera() { return mPCamera3D; }

/// G̃`bvZbg擾
SP<EnemyChipset> MainGameDataManager::GetEnemyChipset() { return mPEnemyChipset; }

/// ĂACeQ
std::list< SP<DropItem> >* MainGameDataManager::GetDropItems() { return &mDropItems; }

/// vC[LN^[擾
SP<Character> MainGameDataManager::GetPlayer() { return mPPlayer; }

/// 㩌Q擾
std::list< SP<FloorTrap> >* MainGameDataManager::GetFloorTraps() { return &mFloorTraps; }

#if _DEBUG
/// XYZ擾
SP<XYZAxisDX9> MainGameDataManager::GetXYZAxis() { return mPXYZAxis; }

/// Obh擾
SP<GridDX9> MainGameDataManager::GetGrid() { return mPGrid; }

/// NXwA擾
SP<CrosshairDX9> MainGameDataManager::GetCrossHair() { return mPCrosshair; }
#endif // _DEBUG

/// n`擾
SP<TerrainGrid> MainGameDataManager::GetTerrainGrid() { return mPTerrainGrid; }

/// ̊Ǘ擾
SP<DropItemManager> MainGameDataManager::GetDropItemManager() { return mPDropItemManager; }

/// ̊Ǘ擾
SP<UnitManager> MainGameDataManager::GetUnitManager() { return mPUnitManager; }

/// 㩂̊Ǘ擾
SP<TrapManager> MainGameDataManager::GetTrapManager() { return mPTrapManager; }

/// lNXg}X̊Ǘ擾
SP<NextMassManager> MainGameDataManager::GetNextMassManager() { return mPNextMassManager; }
