#ifndef CHARACTERDATABASE_H
#define CHARACTERDATABASE_H

#include <list>
#include "Blast/Design/Singleton.h"


/// LN^[̊Of[^SNX
class CharacterDatabase :
	public Blast::Design::Singleton<CharacterDatabase>
{
public:
	//====================================================================================================
	// Struct
	//----------------------------------------------------------------------------------------------------

	/// \z
	struct SConsititution
	{
	public:
		/// RXgN^
		SConsititution()
		{
			Construct();
		}

	private:
		/// ̏
		void Construct()
		{
			mID = -1;
			mETag = -1;
			ZeroMemory(mName, sizeof(mName));
			_tcscpy_s(mName, SIZE_OF_ARRAY(mName), _T("Missing"));
			_tcscpy_s(mDisplayName, SIZE_OF_ARRAY(mDisplayName), _T("Missing"));
			mLevel = -1;
			mHP = -1;
			mOffence = -1;
			mDefence = -1;
			mExperience = -1;
			mElementID = -1;
			mLvUpID = -1;
			mLvDownID = -1;
			_tcscpy_s(mModelFilePath, SIZE_OF_ARRAY(mModelFilePath), _T("Missing"));
		}

	public:
		int mID;					///< ID
		int mETag;					///< ^O
		TCHAR mName[32];			///< O
		TCHAR mDisplayName[32];		///< \
		int mLevel;					///< x
		int mHP;					///< HP
		int mOffence;				///< U
		int mDefence;				///< h
		int mExperience;			///< ol
		int mElementID;				///< ID
		int mLvUpID;				///< LvUpID
		int mLvDownID;				///< LvDownID
		TCHAR mModelFilePath[128];	///< ft@CpX
	};

	/// 
	struct SElement
	{
		/// RXgN^
		SElement() { }

		int mID;			///< ID
		int mETag;			///< ^O
		TCHAR mName[32];	///< O
	};


	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	CharacterDatabase();
	/// fXgN^
	virtual ~CharacterDatabase();

	/// \f[^ǂݍ
	void LoadConsititution(const TCHAR* const kPFullPath);
	/// f[^ǂݍ
	void LoadElement(const TCHAR* const kPFullPath);

	/// \f[^擾
	const SP<SConsititution> GetConsititutionData(int id) const;
	/// f[^擾
	const SP<SElement> GetElementData(int id) const;

	/// \f[^z擾
	const std::list< SP<SConsititution> >* GetConsititutionDatas() const;
	/// f[^z擾
	const std::list< SP<SElement> >* GetElementDatas() const;

private:
	/// \f[^
	std::list< SP<SConsititution> > mSConsititutionDatas;

	/// f[^
	std::list< SP<SElement> > mSElementDatas;
};

#endif // CHARACTERDATABASE_H