#include "Character.h"

using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Character::Character()
	: mNameStr(_T(""))
	, mDisplayNameStr(_T(""))
	, mTilePosition(0)
	, mECharacterType(eCHARACTER_INITIAL)
	, mDirection()
	, mSParameter()
{
	// NXwA쐬
	mPCrosshair.SetPointer(NEW CrosshairDX9());
	mPCrosshair->Create(10.0f);
}

/// fXgN^
Character::~Character()
{
}


/// ǂݍ
bool Character::Load(const TCHAR* const kPFullPath)
{
	mPModel.SetPointer(NEW SkinModel());
	mPModel->LoadMesh(kPFullPath);

	return true;
}

/// XV
void Character::Update(float delta)
{
	// fXV
	if (mPModel)
	{
		mPModel->Update(delta);
	}

	// NXwAXV
	if (mPCrosshair)
	{
		mPCrosshair->Update(delta);
	}
}

/// `
void Character::Render()
{
	// f`
	if (mPModel)
	{
		mPModel->SetCamera(mPCamera);
		mPModel->Render();
	}

	// NXwA`
	if (mPCrosshair)
	{
		mPCrosshair->SetCamera(mPCamera);
		mPCrosshair->Render();
	}
}


/// ύX
void Character::ChangeDirection(Direction::EDirection e)
{	
	// ێ
	mDirection.SetDirection(e);

	// ɍ킹ĉ]lݒ
	float rotRad = Direction::GetRotation(e);
	mPModel->SetRotation(Vector3::UnitY() * rotRad);
}


/// HPɃ_[W󂯂
int Character::DamageHP(int value)
{
	mSParameter.mHP -= value;

	return mSParameter.mHP;
}

/// 񂾂ǂ擾
bool Character::IsDead() const
{
	return (mSParameter.mHP <= 0);
}