#include "Camera3D.h"

using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Camera3D::Camera3D()
{
	Initialize();
}

/// fXgN^
Camera3D::~Camera3D()
{
}


/// 
void Camera3D::Initialize()
{
	// Q[R|[lg
	GameComponent::Initialize();


	mPosition = Vector3(1.0f, 1.0f, -1.0f) * 50;
	mLookAt = Vector3::Zero();
	mWorldUpUnit = Vector3::UnitY();

	UpdateRotation();

	// MEMO:3DpJ̏l͓ϊɂĂ܂B
	mEProjection = Projection::ePROJECTION_PARSEPECTIVE_FOV;

	// MEMO:45.0fx
	mFieldOfViewY = D3DX_PI / 4.0f;

	// XN[TCYݒ
	mWidth = SCREEN_SIZE_WIDTH;
	mHeight = SCREEN_SIZE_HEIGHT;

	// MEMO:MSDNł́u𕝂ŏZvƕ\Ă܂As쐬̎̂ŋtɂĂ܂B
	mAspectRatio = mWidth / mHeight;

	// MEMO:܂ɂĂƐ`悳Ȃ\܂B
	mNearClip = 50.0f;
	mFarClip = 2000.0f;

	UpdateView();
	UpdateProjection();
	UpdateViewport();
}

/// XV
void Camera3D::Update(float delta)
{
	// sXV
	UpdateView();
	UpdateProjection();
	UpdateViewport();
}


/// O̒PʃxNg擾
Vector3 Camera3D::GetFrontUnit() const
{
	// ̒PʃxNgZo
	Vector3 eye = mLookAt - mPosition;
	Vector3 eyeUnit = eye.Normalize();

	return eyeUnit;
}

/// E̒PʃxNg擾
Vector3 Camera3D::GetRightUnit() const
{
	// O̒PʃxNgZo
	Vector3 frontUnit = GetFrontUnit();

	// MEMO:OɌĎZo܂B
	// ̃xNgƂ̊OςZo
	Vector3 rightUnit = Vector3::Cross(frontUnit, mWorldUpUnit);

	return rightUnit;
}

/// ̒PʃxNg擾
Vector3 Camera3D::GetUpUnit() const
{
	// E̒PʃxNg擾
	Vector3 rightUnit = GetRightUnit();

	// O̒PʃxNg擾
	Vector3 frontUnit = GetFrontUnit();

	// MEMO:EOɌĎZo܂B
	// Oς擾
	Vector3 upUnit = Vector3::Cross(rightUnit, frontUnit);

	return upUnit;
}


/// ʒuݒ
void Camera3D::SetPosition(float x, float y, float z, bool isLookAtWith)
{
	/// _Ȃ
	if (isLookAtWith)
	{
		// ݂̈ʒu̒_̈ʒu擾
		Vector3 sub = mLookAt - mPosition;

		// VʒȗΈʒuŐݒ
		SetLookAt(x + sub.mX, y + sub.mY, z + sub.mZ);
	}

	mPosition.mX = x;
	mPosition.mY = y;
	mPosition.mZ = z;
}

/// ʒuݒ
void Camera3D::SetPosition(const Vector3& kRPos, bool isLookAtWith)
{
	SetPosition(kRPos.mX, kRPos.mY, kRPos.mZ, isLookAtWith);
}


/// _ݒ
void Camera3D::SetLookAt(float x, float y, float z)
{
	mLookAt.mX = x;
	mLookAt.mY = y;
	mLookAt.mZ = z;
}

/// _ݒ
void Camera3D::SetLookAt(const Vector3& kRLookAt)
{
	mLookAt = kRLookAt;
}


/// [h̏̒PʃxNgݒ
void Camera3D::SetWorldUpUnit(float x, float y, float z)
{
	mWorldUpUnit.mX = x;
	mWorldUpUnit.mY = y;
	mWorldUpUnit.mZ = z;
}

/// [h̏̒PʃxNgݒ
void Camera3D::SetWorldUpUnit(const Vector3& kRUpUnit)
{
	mWorldUpUnit = kRUpUnit;
}


/// ]ݒ
void Camera3D::SetRotationZXY(float x, float y, float z)
{
	// ʒu璍_ւ̃xNg擾
	Vector3 toLookAt = mLookAt - mPosition;

	// ʒuƒ_Ƃ̋擾
	float distance = toLookAt.Length();

	// MEMO:]lS0̏ꍇA_Zɂ܂B
	// Z+̒PʃxNgɏZ
	Vector3 rotZeroLookAt = Vector3::UnitZ() * distance;


	// ]s쐬
	Matrix rotMat;
	rotMat.CreateRotationZXY(x, y, z);

	// ]
	Vector3 rotated = rotZeroLookAt;
	rotated.Multiply(rotMat);


	// ]̒SʒuZ
	Vector3 result = rotated + mPosition;


	// _ɑ
	mLookAt = result;


	// ]l͒ڑ
	mRotation.mX = x;
	mRotation.mY = y;
	mRotation.mZ = z;
}

/// ]ݒ
void Camera3D::SetRotationZXY(const Vector3& kRRotation)
{
	SetRotationZXY(kRRotation.mX, kRRotation.mY, kRRotation.mZ);
}


/// ʒuړ
void Camera3D::Move(float x, float y, float z, bool isLookAtWith)
{
	// _Ȃ
	if (isLookAtWith)
	{
		// _ړ
		MoveLookAt(x, y, z);
	}

	// ړʂZo
	Vector3 move;
	move += GetRightUnit() * x;
	move += GetUpUnit() * y;
	move += GetFrontUnit() * z;

	// ʒuɈړʂZ
	mPosition += move;
}

/// ʒuړ
void Camera3D::Move(const Vector3& kRMove, bool isLookAtWith)
{
	Move(kRMove.mX, kRMove.mY, kRMove.mZ, isLookAtWith);
}


/// ʒuɉĈړ
void Camera3D::MoveAxis(float x, float y, float z, bool isLookAtWith)
{
	mPosition.mX += x;
	mPosition.mY += y;
	mPosition.mZ += z;

	// _ړȂ
	if (isLookAtWith)
	{
		MoveLookAtAxis(x, y, z);
	}
}

/// ʒuɉĈړ
void Camera3D::MoveAxis(const Vector3& kRPos, bool isLookAtWith)
{
	mPosition += kRPos;

	// _ړȂ
	if (isLookAtWith)
	{
		MoveLookAtAxis(kRPos);
	}
}


/// _ړ
void Camera3D::MoveLookAt(float x, float y, float z)
{
	// ړʂZo
	Vector3 move;
	move += GetRightUnit() * x;
	move += GetUpUnit() * y;
	move += GetFrontUnit() * z;

	// _ɈړʂZ
	mLookAt += move;
}

/// _ړ
void Camera3D::MoveLookAt(const Vector3& kRMove)
{
	MoveLookAt(kRMove.mX, kRMove.mY, kRMove.mZ);
}


/// _ɉĈړ
void Camera3D::MoveLookAtAxis(float x, float y, float z)
{
	mLookAt.mX += x;
	mLookAt.mY += y;
	mLookAt.mZ += z;
}

/// _ɉĈړ
void Camera3D::MoveLookAtAxis(const Vector3& kRLookAt)
{
	mLookAt += kRLookAt;
}


/// ]
void Camera3D::RotateZXY(float x, float y, float z)
{
	// ʒu璍_ւ̃xNg擾
	Vector3 toLookAt = mLookAt - mPosition;


	// ]s쐬
	Matrix rotMat;
	rotMat.CreateRotationZXY(x, y, z);

	// ]
	Vector3 rotated = toLookAt;
	rotated.Multiply(rotMat);


	// ]̒SʒuZ
	Vector3 result = rotated + mPosition;


	// _Ɍʂ
	mLookAt = result;


	// ]lXV
	UpdateRotation();
}

/// ]
void Camera3D::RotateZXY(const Vector3& kRRotate)
{
	RotateZXY(kRRotate.mX, kRRotate.mY, kRRotate.mZ);
}


/// _𒆐SɌ]
void Camera3D::RevolveZXY(float radX, float radY, float radZ)
{
	// _ʒuւ̃xNg擾
	Vector3 toPosition = mPosition - mLookAt;


	// [JWn̎Zo
	Vector3 localUnitX = Vector3::UnitX();
	Vector3 localUnitY = Vector3::UnitY();
	Vector3 localUnitZ = Vector3::UnitZ();
	localUnitX.Multiply(mRotateMatrixZXY);
	localUnitY.Multiply(mRotateMatrixZXY);
	localUnitZ.Multiply(mRotateMatrixZXY);


	// X̉]px-90xA90xƋsɂȂ̂ŃNv
	const float kRadXMin = MathHelper::ToRadian(-88.0f);
	const float kRadXMax = MathHelper::ToRadian(88.0f);
	if (radX + mRotation.mX < kRadXMin)
	{
		radX = MathHelper::Absolute(mRotation.mX) - MathHelper::Absolute(kRadXMin);
	}
	else if (kRadXMax < radX + mRotation.mX)
	{
		radX = MathHelper::Absolute(kRadXMax) - MathHelper::Absolute(mRotation.mX);
	}


	// ]s쐬
	Matrix rotMatX, rotMatY, rotMatZ, rotMat;
	rotMatX.CreateRotationAxis(localUnitX, radX);
	rotMatY.CreateRotationAxis(localUnitY, radY);
	rotMatZ.CreateRotationAxis(localUnitZ, radZ);
	rotMat = rotMatZ * rotMatX * rotMatY;

	// ]
	Vector3 rotated = toPosition;
	rotated.Multiply(rotMat);


	// ]̒SS̈ʒuZ
	Vector3 result = rotated + mLookAt;


	// ʒuɌʂ
	mPosition = result;
	

	// ]lXV
	UpdateRotation();
}

/// _𒆐SɌ]
void Camera3D::RevolveZXY(const Vector3& kRRevolve)
{
	RevolveZXY(kRRevolve.mX, kRRevolve.mY, kRRevolve.mZ);
}


/// Y[
void Camera3D::Zoom(float zoom)
{
	mFieldOfViewY += zoom;
}


/// ]lXV
void Camera3D::UpdateRotation()
{
	// Oւ̒PʃxNg擾
	const Vector3 kFrontUnit = GetFrontUnit();

	// YW0ɐݒ
	Vector3 zxPlane = kFrontUnit;
	zxPlane.mY = 0;

	// Pʉ
	Vector3 zxPlaneUnit = zxPlane.Normalize();

	// Y]l
	float radY = 0;

	// Z̒l0łȂȂ
	if (zxPlaneUnit.mZ != 0)
	{
		// Z+X+ւ̌łY]p擾
		radY = atan2(zxPlaneUnit.mX, zxPlaneUnit.mZ);
	}


	// Y̋t]s쐬
	Matrix invRotY;
	invRotY.CreateRotationY(-radY);

	// Oւ̒PʃxNgYŋt]
	Vector3 zyPlane = kFrontUnit;
	zyPlane.Multiply(invRotY);

	// Pʉ
	Vector3 zyPlaneUnit = zyPlane.Normalize();

	// X]l
	float radX = 0;

	// Y̒l0łȂȂ
	if (zyPlaneUnit.mY != 0)
	{
		// MEMO:t̗lȋCł傤B
		// Z+Y+ւ̌łX]p擾
		radX = -atan2(zyPlaneUnit.mY, zyPlaneUnit.mZ);
	}


	// MEMO:Z]lɂ͎oȂł܂B
	// ]p
	mRotation.mX = radX;
	mRotation.mY = radY;


	// e]s쐬
	Matrix rotMatX = Matrix::CreateRotationX(mRotation.mX, NULL);
	mRotateMatrixY.CreateRotationY(mRotation.mY);
	Matrix rotMatZ = Matrix::CreateRotationZ(mRotation.mZ, NULL);
	mRotateMatrixZXY = rotMatZ * rotMatX * mRotateMatrixY;
}


#ifdef _DEBUG

//====================================================================================================
// Debug
//----------------------------------------------------------------------------------------------------

/// \
void Camera3D::DebugRender(int x, int y)
{
	// s
	const int kMatrixSpacing = 70;

	// os
	const int kSubheadSpacing = 12;

	// sCfbNX
	int dataIndex = 0;


	// ʒu
	int posX = x;
	int posY = y;

	// r[s\
	posY = y + kMatrixSpacing * dataIndex;

	DP(posX, posY, 0xffff8888, _T("r[s"));
	mViewMatrix.DebugRender(posX, posY + kSubheadSpacing);

	// ˉes\
	++dataIndex;
	posY = y + kMatrixSpacing * dataIndex;

	DP(posX, posY, 0xffff8888, _T("ˉes"));
	mProjectionMatrix.DebugRender(posX, posY + kSubheadSpacing);
}

#endif // _DEBUG


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// r[sXV
void Camera3D::UpdateView()
{
	mViewMatrix.CreateViewLH(mPosition, mLookAt, mWorldUpUnit);
}

/// ˉesXV
void Camera3D::UpdateProjection()
{
	// ˉe@ŕ
	switch (mEProjection)
	{
		/// plϊ
		case Projection::ePROJECTION_PARSEPECTIVE_FOV:
			mProjectionMatrix.CreateParsepectiveFovLH(mFieldOfViewY, mAspectRatio, mNearClip, mFarClip);
			break;

		// ˉesȂ
		case Projection::ePROJECTION_ORTHOGRAPHIC:
			mProjectionMatrix.CreateOrthoGraphicLH(mWidth, mHeight, mNearClip, mFarClip);
			break;

		// P[XOȂ
		default:
			HALT(_T("ˉe@ɂ镪򏈗łB"));
			break;
	}
}

/// r[|[gsXV
void Camera3D::UpdateViewport()
{
	mViewportMatrix.Identity();
}