#include "BitFlag.h"


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
BitFlag::BitFlag()
	: mBit(0)
{
}

/// fXgN^
BitFlag::~BitFlag()
{
}


/// rbg𗧂Ă
void BitFlag::SetBit(int flag)
{
	mBit |= flag;
}

/// rbg𗧂ĂB̓rbg̈ʒunB
void BitFlag::SetBitAt(int bit)
{
	unsigned shifted = (1 << bit);
	SetBit(shifted);
}

/// rbg낷
void BitFlag::UnsetBit(int flag)
{
	unsigned and = (mBit & flag);
	mBit ^= and;
}

/// rbg낷B̓rbg̒lnB
void BitFlag::UnsetBitAt(int bit)
{
	unsigned shifted = (1 << bit);
	UnsetBit(shifted);
}

/// rbgĂ邩ǂ
bool BitFlag::IsBitUp(int flag)
{
	return 0 < (mBit & flag);
}

/// rbgĂ邩ǂ擾B̓rbg̒lnB
bool BitFlag::IsBitUpAt(int bit)
{
	unsigned shifted = (1 << bit);
	return IsBitUp(shifted);
}