#ifndef STANDARDPRIMITIVE_FX
#define STANDARDPRIMITIVE_FX

#include "stdafx.fx"


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/// AvP[V炭钸_obt@ւ̏
struct SAppData
{
	float3 mPosition	: POSITION;		///< ʒuW
	float4 mNormal		: NORMAL;		///< @
};

/// RX^gsNZVF[_֓nf[^
struct SVertexOutput
{
    float4 mPosition	: POSITION;		///< ʒuW
	float3 mLightVector	: TEXCOORD0;	///< ւ̌
	float3 mWorldNormal	: TEXCOORD1;	///< @([hn)
};


//====================================================================================================
// VertexShader
//----------------------------------------------------------------------------------------------------

/// o[gf̃o[ebNXVF[_
SVertexOutput MainVS(SAppData sIn)
{
	// o̓f[^p
	SVertexOutput sOut = (SVertexOutput)0;
	
	
	// ʒuWZo
	float4 pos = float4(sIn.mPosition.xyz, 1);
	sOut.mPosition = mul(pos, gWVP);
	
	// @Zo
	sOut.mWorldNormal = mul(sIn.mNormal, gWorldIT).xyz;
	
	// ւ̃xNgZo([hn)
	float3 pw = mul(pos, gWorld).xyz;
	sOut.mLightVector = (gPointPosition - pw);


	// o
	return sOut;
}


//====================================================================================================
// PixelShader
//----------------------------------------------------------------------------------------------------

/// C̃sNZVF[_
float4 MainPS(SVertexOutput sIn) : COLOR
{
	// elPʉ
	float3 ln = normalize(sIn.mLightVector);
	float3 nn = normalize(sIn.mWorldNormal);

	// ւ̊0ȉȂ0ɃNv
	float ldn = dot(ln, nn);
	ldn = max(ldn, 0);

	// CeBOZo
	float3 result = (ldn * gPointColor + gAmbientColor);

    return float4(result, 1);
}

/// C[t[p
float4 WireframePS(SVertexOutput sIn) : COLOR
{
	// elPʉ
	float3 ln = normalize(sIn.mLightVector);
	float3 nn = normalize(sIn.mWorldNormal);

	// ւ̊0ȉȂ0ɃNv
	float ldn = dot(ln, nn);
	ldn = max(ldn, 0);

	// CeBOZo
	float3 result = (ldn * gPointColor + gAmbientColor);

	// یFɂȂȂ悤ɔ]
	result = float3(1, 1, 1) - result;

    return float4(result, 1);
}

//====================================================================================================
// Technique and Pass
//----------------------------------------------------------------------------------------------------

/// o[gf
technique Lambert
{
	// \bh`pX
    pass PassSolid
    {
        // _[Xe[gݒ
        AlphaBlendEnable = True;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        Lighting = False;

#ifdef D3DX
	    CullMode = CCW;
#else
	    CullMode = CW;
#endif
        
        ZEnable = True;
        ZWriteEnable = True;
        
        FillMode = Solid;
        
        
        // eNX`Xe[WXe[gݒ
        TEXTURETRANSFORMFLAGS[0] = COUNT2;
        ColorOp[0] = MODULATE;
        ColorArg1[0] = TEXTURE;
        ColorArg2[0] = DIFFUSE;
        AlphaOp[0] = MODULATE;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = DIFFUSE;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 MainVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 MainPS();
    }
	
	// ʂ猩Ă݂悤ɃC[t[`
    pass PassWireframe
    {        
        FillMode = Wireframe;
        
#ifdef D3DX
	    CullMode = CW;
#else
	    CullMode = CCW;
#endif
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 MainVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 WireframePS();
    }
}

/// o[gC[t[
technique LambertWireFrame
{
	// \bh`pX
    pass PassSolid
    {
        // _[Xe[gݒ
        AlphaBlendEnable = True;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        Lighting = False;

#ifdef D3DX
	    CullMode = CCW;
#else
	    CullMode = CW;
#endif
        
        ZEnable = True;
        ZWriteEnable = True;
        
        FillMode = Solid;
        
        
        // eNX`Xe[WXe[gݒ
        TEXTURETRANSFORMFLAGS[0] = COUNT2;
        ColorOp[0] = MODULATE;
        ColorArg1[0] = TEXTURE;
        ColorArg2[0] = DIFFUSE;
        AlphaOp[0] = MODULATE;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = DIFFUSE;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 MainVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 MainPS();
    }
	
	// C[t[`pX
    pass PassWireframe
    {        
        FillMode = Wireframe;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 MainVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 WireframePS();
    }
}

#endif // STANDARDPRIMITIVE_FX