#ifndef STANDARDCONSTANT_FX
#define STANDARDCONSTANT_FX

#include "stdafx.fx"


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/// AvP[V炭钸_obt@ւ̏
struct SAppData
{
	float3 mPosition	: POSITION;		///< ʒuW
	float4 mColor		: COLOR0;		///< F
};

/// _obt@sNZVF[_֓nf[^
struct SVertexOutput
{
    float4 mPosition	: POSITION;		/// ʒuW
	float4 mColor		: COLOR0;		///< F
};


//====================================================================================================
// VertexShader
//----------------------------------------------------------------------------------------------------

/// C
SVertexOutput MainVS(SAppData sIn)
{
	// o̓f[^p
	SVertexOutput sOut = (SVertexOutput)0;

	// ʒuWZo
	float4 pos = float4(sIn.mPosition, 1);
	pos = mul(pos, gWorld);
	pos = mul(pos, gView);
	pos = mul(pos, gProjection);
	pos = mul(pos, gViewport);
	sOut.mPosition = pos;
	
	// F̓Xg[̏񂻂̂܂܂
	sOut.mColor = sIn.mColor;

	// o
	return sOut;
}


//====================================================================================================
// PixelShader
//----------------------------------------------------------------------------------------------------

/// C
float4 MainPS(SVertexOutput sIn) : COLOR
{
	// H̐FԂ
    return sIn.mColor;
}


//====================================================================================================
// Technique and Pass
//----------------------------------------------------------------------------------------------------

/// C
technique Main
{
    pass PassMain
    {
        // _[Xe[gݒ
        AlphaBlendEnable = True;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        Lighting = False;
#ifdef D3DX
	    CullMode = CCW;
#else
	    CullMode = CW;
#endif
        ZEnable = True;
        ZWriteEnable = True;
        FillMode = Solid;
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 MainVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 MainPS();
    }
}

#endif // STANDARDCONSTANT_FX