#ifndef CONSTANT_FX
#define CONSTANT_FX

#include "EffectFunction.fx"


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/// RX^gsNZVF[_֓nf[^
struct CONSTANT_VS_OUTPUT
{
    float4 mPosition		: POSITION;
    float2 mUV				: TEXCOORD0;
};


//====================================================================================================
// Shader
//----------------------------------------------------------------------------------------------------

/// RX^go[ebNXVF[_
CONSTANT_VS_OUTPUT ConstantVS(
	float4 position	: POSITION,	// _W
	float2 uv		: TEXCOORD	// eNX`W
)
{
	// o̓f[^p
	CONSTANT_VS_OUTPUT sOut = (CONSTANT_VS_OUTPUT)0;


	// ʒuWݒ
	//sOut.mPosition = mul(position, gWVP);
	float4 pos = float4(position.xyz, 1.0f);
	pos = mul(pos, gWorld);
	pos = mul(pos, gView);
	pos = mul(pos, gProjection);
	pos = mul(pos, gViewport);
	
	sOut.mPosition = pos;


	// MEMO:Ȃvf0ŏ̂ŖI1ŏ܂B
	// UVWݒ
	float4 uv4 = float4(uv.x, uv.y, 1.0f, 1.0f);
	sOut.mUV = mul(uv4, gUVMatrix).xy;


	// o
	return sOut;
}

/// RX^gsNZVF[_
float4 ConstantPS(CONSTANT_VS_OUTPUT sIn) : COLOR
{
	// fBt[YeNX`TvO
	float3 color = DiffuseTextureSampling(sIn.mUV).rgb * gAmbientColor.rgb;

    return float4(color.rgb, 1);
}


#endif // CONSTANT_FX
