#include "Blast/Math/WorldProperty.h"

using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
WorldProperty::WorldProperty()
{
	// 
	Initialize();
}

/// fXgN^
WorldProperty::~WorldProperty()
{
}


/// 
void WorldProperty::Initialize()
{
	mScale = Vector3::One();
	mRotation = Vector3::Zero();
	mPosition = Vector3::Zero();

	mScaleMatrix.Identity();
	mRotateXMatrix.Identity();
	mRotateYMatrix.Identity();
	mRotateZMatrix.Identity();
	mTranslateMatrix.Identity();

	mSRTMatrix.Identity();
}

/// [hsXV
void WorldProperty::UpdateMatrix()
{
	// gks쐬
	Matrix::CreateScale(mScale, &mScaleMatrix);

	// X]s쐬
	Matrix::CreateRotationX(mRotation.mX, &mRotateXMatrix);

	// Y]s쐬
	Matrix::CreateRotationY(mRotation.mY, &mRotateYMatrix);

	// Z]s쐬
	Matrix::CreateRotationZ(mRotation.mZ, &mRotateZMatrix);

	// sړs쐬
	Matrix::CreateTranslate(mPosition, &mTranslateMatrix);


	// MEMO:]鏇ԂZXY̏łB
	// MEMO:䂭䂭͏Ԃ񋓑̂Ŏw肷Ȃ肷Kv邩܂B
	// es
	mSRTMatrix.Identity();
	mSRTMatrix *= mScaleMatrix;
	mSRTMatrix *= mRotateZMatrix;
	mSRTMatrix *= mRotateXMatrix;
	mSRTMatrix *= mRotateYMatrix;
	mSRTMatrix *= mTranslateMatrix;
}


/// gkݒ
void WorldProperty::SetScale(float x, float y, float z)
{
	mScale.mX += x;
	mScale.mY += y;
	mScale.mZ += z;
}

/// gkݒ
void WorldProperty::SetScale(const Blast::Math::Vector3& kRScale)
{
	SetScale(kRScale.mX, kRScale.mY, kRScale.mZ);
}

/// gk
void WorldProperty::Scaling(float x, float y, float z)
{
	// MEMO:XP[͉Zł͂ȂZ܂B
	// MEMO:Ǝv܂Â炢̂ŁAZɂ܂B

	mScale.mX += x;
	mScale.mY += y;
	mScale.mY += z;
}

/// gk
void WorldProperty::Scaling(const Vector3& kRScaling)
{
	Scaling(kRScaling.mX, kRScaling.mY, kRScaling.mZ);
}


/// ]l擾
const Vector3& WorldProperty::GetRotation() const
{
	return mRotation;
}

/// ]l擾
Vector3& WorldProperty::GetRotation()
{
	return mRotation;
}

/// ]lݒ
void WorldProperty::SetRotation(float x, float y, float z)
{
	mRotation.mX = x;
	mRotation.mY = y;
	mRotation.mZ = z;
}

/// ]lݒ
void WorldProperty::SetRotation(const Blast::Math::Vector3& kRRotation)
{
	SetRotation(kRRotation.mX, kRRotation.mY, kRRotation.mZ);
}


/// ]l擾
const Vector3& WorldProperty::GetScale() const
{
	return mScale;
}

/// ]l擾
Vector3& WorldProperty::GetScale()
{
	return mScale;
}

/// ]
void WorldProperty::Rotate(float x, float y, float z)
{
	mRotation.mX += x;
	mRotation.mY += y;
	mRotation.mZ += z;
}

/// ]
void WorldProperty::Rotate(const Vector3& kRRotate)
{
	Rotate(kRRotate.mX, kRRotate.mY, kRRotate.mZ);
}


/// ʒu擾
const Vector3& WorldProperty::GetPosition() const
{
	return mPosition;
}

/// ʒu擾
Vector3& WorldProperty::GetPosition()
{
	return mPosition;
}

/// ʒuݒ
void WorldProperty::SetPosition(float x, float y, float z)
{
	mPosition.mX = x;
	mPosition.mY = y;
	mPosition.mZ = z;
}

/// ʒuݒ
void WorldProperty::SetPosition(const Blast::Math::Vector3& kRPosition)
{
	SetPosition(kRPosition.mX, kRPosition.mY, kRPosition.mZ);
}

/// sړ
void WorldProperty::Translate(float x, float y, float z)
{
	mPosition.mX += x;
	mPosition.mY += y;
	mPosition.mZ += z;
}

/// sړ
void WorldProperty::Translate(const Vector3& kRMove)
{
	Translate(kRMove.mX, kRMove.mY, kRMove.mZ);
}


/// SRTs擾
Matrix& WorldProperty::GetSRTMatrixRef()
{
	return mSRTMatrix;
}

/// SRTs擾
const Matrix& WorldProperty::GetSRTMatrixRef() const
{
	return mSRTMatrix;
}


/// O擾
Vector3 WorldProperty::GetForwardUnit() const
{
	// -ZPʃxNgZo
	return CalcUnitSRTransform(Vector3::UnitZ() * -1);
}

/// 擾
Vector3 WorldProperty::GetLeftUnit() const
{
	// +XPʃxNgZo
	return CalcUnitSRTransform(Vector3::UnitX());
}

/// E擾
Vector3 WorldProperty::GetRightUnit() const
{
	// -XPʃxNgZo
	return CalcUnitSRTransform(Vector3::UnitX() * -1);
}

/// 擾
Vector3 WorldProperty::GetBackUnit() const
{
	// +ZPʃxNgZo
	return CalcUnitSRTransform(Vector3::UnitZ());
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// ړ𖳎s̒lŕϊPʃxNg擾
Vector3 WorldProperty::CalcUnitSRTransform(const Vector3& kRVUnit) const
{
	Vector3 out;

	// s̈ړ𖳌
	Matrix srMat = mSRTMatrix;
	srMat.m41 = 0;
	srMat.m42 = 0;
	srMat.m43 = 0;

	// PʃxNgŏZ
	Vector3 trans = kRVUnit;
	trans.Multiply(srMat);

	// MEMO:sɂ̓XP[lcĂ邩łB
	// Pʉ
	out = Vector3::Normalize(trans);

	return out;
}