#include "Blast/Math/Vector2.h"

using namespace Blast::Math;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// (0, 0)擾
const Vector2& Vector2::Zero()
{
	return mStKZero;
}

/// (1, 0)擾
const Vector2& Vector2::UnitX()
{
	return mStKUnitX;
}

/// (0, 1)擾
const Vector2& Vector2::UnitY()
{
	return mStKUnitY;
}

/// (1, 1)擾
const Vector2& Vector2::One()
{
	return mStKOne;
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// ftHgRXgN^
Vector2::Vector2() :
mX(0),
mY(0)
{
}

/// RXgN^BXYɓl
Vector2::Vector2(float a) :
mX(a),
mY(a)
{
}

/// RXgN^BXYɒl
Vector2::Vector2(float a, float b) :
mX(a),
mY(b)
{
}

/// fXgN^
Vector2::~Vector2()
{
}


/// eZ
void Vector2::Add(float a, float b)
{
	mX += a;
	mY += b;
}

/// eZ
void Vector2::Add(const Vector2& kRV)
{
	Add(kRV.mX, kRV.mY);
}


/// eZ
void Vector2::Subtract(float a, float b)
{
	mX -= a;
	mY -= b;
}

/// eZ
void Vector2::Subtract(const Vector2& kRV)
{
	Subtract(kRV.mX, kRV.mY);
}


/// eZ
void Vector2::Multiply(float a, float b)
{
	mX *= a;
	mY *= b;
}

/// eɒlZ
void Vector2::Multiply(float a)
{
	Multiply(a, a);
}

/// eZ
void Vector2::Multiply(const Vector2& kRV)
{
	Multiply(kRV.mX, kRV.mY);
}


/// eZ
void Vector2::Divide(float a, float b)
{
	mX /= a;
	mY /= b;
}

/// eZ
void Vector2::Divide(float a)
{
	Divide(a, a);
}

/// eZ
void Vector2::Divide(const Vector2& kRV)
{
	Divide(kRV.mX, kRV.mY);
}


/// ςZo
float Vector2::Dot(const Vector2& kRV)
{
	float outValue = (mX * kRV.mX) + (mY * kRV.mY);

	return outValue;
}

/// OςZo
float Vector2::Cross(const Vector2& kRV)
{
	float outValue = 0;
	
	outValue = (mX * kRV.mY) - (mY * kRV.mX);

	return outValue;
}


//====================================================================================================
// Overload
//----------------------------------------------------------------------------------------------------

/// +Zqł̉Z\
Vector2 Vector2::operator+ (const Vector2& a) const
{
	Vector2 v = *this;

	v.Add(a);

	return v;
}

/// -Zqł̌Z\
Vector2 Vector2::operator- (const Vector2& a) const
{
	Vector2 v = *this;

	v.Subtract(a);

	return v;
}

/// *Zqł̏Z\
Vector2 Vector2::operator* (volatile const Vector2& a) const
{
	Vector2 v = *this;

	v.Multiply(a.mX, a.mY);

	return v;
}

/// /Zqł̏Z\
Vector2 Vector2::operator/ (const Vector2& a) const
{
	Vector2 v = *this;

	v.Divide(a);

	return v;
}

/// +=Zqł̉Z\
void Vector2::operator+= (const Vector2& a)
{
	Add(a);
}

/// -=Zqł̌Z\
void Vector2::operator-= (const Vector2& a)
{
	Subtract(a);
}

/// *=Zqł̏Z\
void Vector2::operator*= (const Vector2& a)
{
	Multiply(a);
}

/// /=Zqł̏Z\
void Vector2::operator/= (const Vector2& a)
{
	Divide(a);
}

/// YZq[]ł̒l擾\
float& Vector2::operator[] (int index)
{
	// CfbNXŕ
	switch (index)
	{
		// 0Ȃ
		case 0:		return mX;

		// 1Ȃ
		case 1:		return mY;

		// ȊOȂ
		default:

			// HALT:sȃCfbNXł邱Ƃ͖炩Ȃ̂Ŏ
			HALT(_T("Vector2ɑ΂Y01̂ݗLłB^ꂽÝw%dxłB"), index);

			break;
	}

	// MEMO:QƕԂȂ̂ŃoϐԂKv܂B
	return mX;
}


#if _DEBUG

//====================================================================================================
// Debug
//----------------------------------------------------------------------------------------------------

/// o
void Vector2::DebugOutput() const
{
	PFL(_T("Vector2(% f, % f)"), mX, mY);
}

/// o
void Vector2::DebugRender(int x, int y) const
{
	DP(x, y, 0xffffffff, _T("Vector2(% f, % f)"), mX, mY);
}

#endif // _DEBUG


//====================================================================================================
// PrivateStatic
//----------------------------------------------------------------------------------------------------

/// (0, 0)
const Vector2 Vector2::mStKZero(0, 0);

/// (1, 0)
const Vector2 Vector2::mStKUnitX(1, 0);

/// (0, 1)
const Vector2 Vector2::mStKUnitY(0, 1);

/// (1, 1)
const Vector2 Vector2::mStKOne(1, 1);
