#include "Blast/Graphic/TextRendererColorTag.h"

#include "Blast/Graphic/IFont.h"

using namespace Blast::Math;
using namespace Blast::Graphic;
using namespace Blast::String;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// J[R[hƂ݂ȂL
const TCHAR TextRendererColorTag::mStKPColorCodeSymbol = _T('#');

/// CtB[hƂ݂Ȃ
const TCHAR TextRendererColorTag::mStKPLineFeed = _T('\n');


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

	/* eLXg */

	/// RXgN^
	TextRendererColorTag::STextData::STextData()
	{
		mTextStr.clear();
		mPrivateColor = 0xffffffff;
		mIsUsePrivateColor = false;
		mRelativePosition = Vector3::Zero();
		mRotation = Vector3::Zero();
	}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
TextRendererColorTag::TextRendererColorTag(SP<IFont> pFont)
{
	// tHgێ
	mPFont = pFont;


	// ʒu[|Cgɐݒ
	mPosition = Vector3::Zero();

	// ]l[ɐݒ
	mRotation = Vector3::Zero();


	// NA
	mOriginalTextStr.c_str();

	// WF𔒂ɐݒ
	mBasicColor = 0xffffffff;


	// eLXgQNA
	mSTextDatas.clear();
}

/// fXgN^
TextRendererColorTag::~TextRendererColorTag()
{
}


/// `
void TextRendererColorTag::Render()
{
	// ASSERT:tHgȂ玀
	ASSERT_PRINTF(mPFont, _T("tHgݒ肳Ă܂B"));

	// eLXg͂̕s
	if (mIsNeedAnalyze)
	{
		mIsNeedAnalyze = false;
		AnalyzeText();
	}

	// eLXg̐Ń[v
	for (unsigned i = 0; i < mSTextDatas.size(); ++i)
	{
		// eLXgQ
		const STextData& kRSTextData = mSTextDatas.at(i);


		// ݒ
		const tstring& kRText = kRSTextData.mTextStr;
		mPFont->SetText(kRText.c_str());

		// Fݒ
		if (kRSTextData.mIsUsePrivateColor)
		{
			mPFont->SetColor(kRSTextData.mPrivateColor);
		}
		else
		{
			mPFont->SetColor(mBasicColor);
		}

		// `ʒuZo
		Vector3 pos = mPosition + kRSTextData.mRelativePosition;
		mPFont->SetPosition(pos);

		// ]lݒ
		Vector3 rot = mRotation + kRSTextData.mRotation;
		mPFont->SetRotation(rot);


		// `
		mPFont->Render();
	}
}


/// `ʒu擾
const Vector3& TextRendererColorTag::GetPosition() const
{
	return mPosition;
}

/// `ʒuݒ
void TextRendererColorTag::SetPosition(const Vector3& kRPosition)
{
	mPosition = kRPosition;
}


/// eLXg擾
const TCHAR* const TextRendererColorTag::GetText() const
{
	return mOriginalTextStr.c_str();
}

/// eLXgݒ
void TextRendererColorTag::SetText(const TCHAR* kPText)
{
	// eLXgێ
	mOriginalTextStr = kPText;

	mIsNeedAnalyze = true;
}


/// WF擾
const Color& TextRendererColorTag::GetBasicColor() const
{
	return mBasicColor;
}

/// WFݒ
void TextRendererColorTag::SetBasicColor(const Color& kRBasicColor)
{
	mBasicColor = kRBasicColor;
}


/// tHg擾
const SP<IFont> TextRendererColorTag::GetFont() const
{
	return mPFont;
}

/// tHgݒ
void TextRendererColorTag::SetFont(const SP<IFont> pFont)
{
	mPFont = pFont;
}


/// Jݒ
void TextRendererColorTag::SetCamera(const SP<ICamera> pCamera)
{
	ASSERT_PF(mPFont, _T("Jݒ肳Ă܂Bɐݒ肷Kv܂B"));
	// MEMO:J𒼐ڃtHgɏ[Ă̂́AėpȂB2DA3DŁB
	//mPFont->SetCamera(pCamera);
	HALT(_T("tHgɒڃJɏ[Ă̂͂߂܂B"));
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// ͂s
void TextRendererColorTag::AnalyzeText()
{
	// eLXgQNA
	mSTextDatas.clear();

	// eLXg̓tFCY
	enum EAnalysisPhase
	{
		eANALYSISPHASE_RENDER,		//< `悷镶񂻂̂܂܁B
		eANALYSISPHASE_COLOR,		//< FBF̉́B
		eANALYSISPHASE_LINEFEED,	//< sBCtB[hB

		// 񋓗vf̐
		eANALYSISPHASE_COUNT,
	};
	EAnalysisPhase ePhase = eANALYSISPHASE_RENDER;

	// ʐF
	Color color = mBasicColor;
	bool isUsePrivateColor = false;

	// Έʒu
	Vector3 relativePosition = Vector3::Zero();


	// 擾
	const unsigned kCharacterCount = _tcslen( mOriginalTextStr.c_str() );

	// Ń[v
	for (unsigned i = 0; i < kCharacterCount; ++i)
	{
		// Q
		const TCHAR kCharacter = mOriginalTextStr.at(i);

		// Ƃĕێ
		tstring kCharacterStr;
		kCharacterStr = kCharacter;

		// tFCYŕ
		switch (ePhase)
		{
			// `pȂ
			case eANALYSISPHASE_RENDER:
			{
				// J[R[hƌȂLȂ
				if (kCharacter == mStKPColorCodeSymbol)
				{
					// tFCYύX
					ePhase = eANALYSISPHASE_COLOR;
				}
				// CtB[hƌȂLȂ
				else if (kCharacter == mStKPLineFeed)
				{
					// tFCYύX
					ePhase = eANALYSISPHASE_LINEFEED;
				}
				// ̋Lł͂ȂȂ
				else
				{
					// eLXg쐬
					STextData sTextData;
					sTextData.mTextStr = kCharacterStr;
					sTextData.mPrivateColor = color;
					sTextData.mIsUsePrivateColor = isUsePrivateColor;
					sTextData.mRelativePosition = relativePosition;
					sTextData.mRotation = Vector3::Zero();	//< MEMO:[ɐݒ肵Ă܂B

					mSTextDatas.push_back(sTextData);

					// ̕ւ̑ΈʒuZo
					int relativePositionX = mPFont->MeasureString(kCharacterStr.c_str());
					relativePosition.mX += static_cast<float>(relativePositionX);
				}
			}
				break;

			// FȂ
			case eANALYSISPHASE_COLOR:
			{
				// 16iŕ\ꂽJ[R[h̕
				const int kColorCodeStringLength = 8;

				// J[R[h̕𒊏o
				tstring colorCodeStr = mOriginalTextStr.substr(i, kColorCodeStringLength);

				// MEMO:-1̓[v̓xɃCNg镪lĂ܂B
				// oA[vJE^i߂
				i += kColorCodeStringLength - 1;


				// lɕϊ
				unsigned colorCode = 0;
				_stscanf_s(colorCodeStr.c_str(), _T("%x"), &colorCode);

				// Fݒ
				color = colorCode;

				// ȍ~͌̕ʐFgp
				isUsePrivateColor = true;

				// tFCYύX
				ePhase = eANALYSISPHASE_RENDER;
			}
				break;

			// CtB[hȂ
			case eANALYSISPHASE_LINEFEED:
			{
				// tHgTCY擾
				int fontSize = mPFont->GetPointSize();

				// ʒuύX
				relativePosition.mX = 0;
				relativePosition.mY += fontSize;


				// [vJE^iޕ\ߌZ
				i -= 1;
				
				// tFCYύX
				ePhase = eANALYSISPHASE_RENDER;
			}
				break;

			// P[XOȂ
			default:	HALT(_T("P[XO̓̕tFCYłB"));
				break;
		};
	}
}