#include "Blast/String/StringHelper.h"

using namespace Blast::String;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// P[
const TCHAR* const StringHelper::mStKPLocaleName = _T("japanese");


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// tH[}bgϊs
void StringHelper::Format(TCHAR* pDst, int count, const TCHAR* pSrc, ...)
{
	// ψztH[}bgwqɉĕϊ
	va_list	argp;

	va_start(argp, pSrc);
	{
		_vstprintf_s(pDst, count, pSrc, argp);
	}

	va_end(argp);
}

/// tH[}bgϊs
tstring StringHelper::Format(const TCHAR* const pSrc, ...)
{
	TCHAR buffer[mStKDefaultBufferSize];
	ZeroMemory(buffer, sizeof(buffer));

	// ψztH[}bgwqɉĕϊ
	va_list	argp;

	va_start(argp, pSrc);
	{
		_vstprintf_s(buffer, mStKDefaultBufferSize, pSrc, argp);
	}

	va_end(argp);

	return tstring(buffer);
}


/// Ov
bool StringHelper::IsMatchHead(const TCHAR* kPSrc, const TCHAR* kPSearch)
{
	// ̕擾
	const int kSearchLength = _tcslen(kPSearch);

	// 擪當
	int result = _tcsncmp(kPSrc, kPSearch, kSearchLength);

	// O̕񂪈vȂ
	if (0 == result)
	{
		return true;
	}

	return false;
}


/// u
tstring StringHelper::Replace(const tstring& kRSrcStr, const tstring& kRSearchStr, const tstring& kRReplaceStr)
{
	// o͗pϐ
	tstring outStr;
	outStr.clear();

	// uJnʒu
	int searchStartIndex = 0;

	// ʈʒu
	int resultIndex = 0;

	// [vJE^
	int loopCounter = 0;

	// CAUTION:[v
	while (true)
	{
		// 
		resultIndex = kRSrcStr.find(kRSearchStr, searchStartIndex);

		// 񂪂Ȃ
		if (resultIndex != tstring::npos)
		{
			// Jn猋ʂ܂ł̕ǉ
			int count = resultIndex - searchStartIndex;
			outStr += kRSrcStr.substr(searchStartIndex, count);

			// u̕ǉ
			outStr += kRReplaceStr;

			// MEMO:Ώە񕪂͉ZĂ܂B
			// ̌Jnʒu𒲐
			searchStartIndex = resultIndex + 1;
		}
		// 񂪖Ȃ
		else
		{
			// Jn猳̍̕Ō܂Œǉ
			int count = kRSrcStr.length() - searchStartIndex;
			outStr += kRSrcStr.substr(searchStartIndex, count);

			break;
		}

		// JEgAbv
		++loopCounter;

		// ASSERT:10000񏈗玀
		ASSERT_PRINTF(loopCounter < 10000, _T("[v񐔂ُłB[v̉\܂B"));
	}

	return outStr;
}


/// 
void StringHelper::Split(std::vector<tstring>* pOut, const tstring& kRSrcStr, const TCHAR* kPDelimiter, EDelimiter eDelimiter)
{
	// ASSERT:f~^󕶎Ȃ玀B
	ASSERT_PRINTF(_tcslen(kPDelimiter) != 0, _T("f~^󕶎ɂȂĂ܂B"));


	// o͕ϐ
	pOut->clear();

	// 񂪋Ȃ
	if (kRSrcStr.empty())
	{
		return;
	}


	// f~^̒擾
	const int kDelimiterLength = _tcslen(kPDelimiter);

	// JnCfbNX
	int startIndex = 0;


	// CAUTION:[v
	while (true)
	{
		// Ƀf~^Ɠ̕CfbNX擾
		const int kDelimiterIndex = kRSrcStr.find(kPDelimiter, startIndex, kDelimiterLength);

		// 镶
		int extractCount = 0;

		// f~^Ȃ
		if (kDelimiterIndex != tstring::npos)
		{
			// 镶Zo
			extractCount = kDelimiterIndex - startIndex;
		}
		// f~^Ȃ
		else
		{
			// Ō܂Œo悤ɔ镶Zo
			extractCount = kRSrcStr.length() - startIndex;
		}


		// o
		tstring sub = kRSrcStr.substr(startIndex, extractCount);

		// f~^̏ŕ
		switch (eDelimiter)
		{
			// ܂܂ȂȂ
			case eDELIMITER_EXCLUDE:

				// MEMO:܂B

				break;

			// ړɕtȂ
			case eDELIMITER_PREFIX:

				// JnCfbNX0łȂȂ
				if (startIndex != 0)
				{
					sub = kPDelimiter + sub;
				}

				break;

			// ڔɕtȂ
			case eDELIMITER_SUFFIX:
			
				// f~^Ȃ
				if (kDelimiterIndex != tstring::npos)
				{
					sub = sub + kPDelimiter;
				}

				break;

			default:
				break;
		}

		// o͕ϐɑ
		pOut->push_back(sub);


		// JnCfbNXXV
		startIndex += extractCount + kDelimiterLength;


		// JnCfbNX̕𒴂
		int srcLength = kRSrcStr.length();
		if (srcLength < startIndex)
		{
			break;
		}
	}
}


/// 
int StringHelper::Split(TCHAR* pSrc, const TCHAR* delimiters, TCHAR* pOutResults[], int* pOutCount)
{
	// ɕKvȕϐ\ߐ錾
	TCHAR* pExtract = pSrc;
	TCHAR* pContext = pSrc;
	int splitCount = 0;


	// ASSERT:ʏo͗p̕ϐNULLȂ玀B
	ASSERT_PRINTF(pOutResults, _T("o͐ƂȂ|C^NULLłB"));

	// ʏo͗p̕ϐNULLȂ
	if (!pOutResults)
	{
		return splitCount;
	}


	// CAUTION:[vӁB
	// |C^ɂȂ܂Ń[v
	while(pExtract != NULL)
	{
		// MEMO:Ô߃ReLXgp̃|C^ɑĂ܂B
		// g[N
		pExtract = _tcstok_s(pSrc, delimiters, &pContext);
		pSrc = pContext;


		// oLȂ
		if (pExtract != NULL)
		{
			// ӏ̃|C^ێ
			pOutResults[splitCount] = pExtract;


			// JEgZ
			++splitCount;
		}
	}


	// JEg̏o͕ϐLȂ
	if (pOutCount)
	{
		// 
		*pOutCount = splitCount;
	}

	return splitCount;
}


/// A
tstring StringHelper::Concat(TCHAR* pDest, int bufferSize, const TCHAR* kPSrc)
{
	// A
	_tcscat_s(pDest, bufferSize, kPSrc);

	return pDest;
}


/// }`oCgChɕϊ
void StringHelper::ToWideChar(u32* pResultSize, WCHAR* pDest, u32 bufferSize, const CHAR* pSrc, u32 maxCount)
{
	// ϊ
	mbstowcs_s(pResultSize, pDest, bufferSize, pSrc, maxCount);
}

/// }`oCgChɕϊ
void StringHelper::ToWideChar(WCHAR* pDest, u32 bufferSize, const CHAR* pSrc)
{
	// ̕NULLȂ
	if (!pSrc)
	{
		return;
	}

	// Ϗ
	ToWideChar(NULL, pDest, bufferSize, pSrc);
}

/// }`oCgChɕϊ
tstring StringHelper::ToWideChar(const CHAR* pSrc)
{
	WCHAR chars[mStKDefaultBufferSize];
	mbstowcs_s(NULL, chars, mStKDefaultBufferSize, pSrc, _TRUNCATE);

	return wstring(chars);
}


/// Ch}`oCgɕϊ
void StringHelper::ToMultiByteChar(u32* pResultSize, CHAR* pDest, u32 bufferSize, const WCHAR* pSrc, u32 maxCount)
{
	// ϊ
	wcstombs_s(pResultSize, pDest, bufferSize, pSrc, maxCount);
}

/// Ch}`oCgɕϊ
void StringHelper::ToMultiByteChar(CHAR* pDest, u32 bufferSize, const WCHAR* pSrc)
{
	// ̕NULLȂ
	if (!pSrc)
	{
		return;
	}

	// Ϗ
	ToMultiByteChar(NULL, pDest, bufferSize, pSrc);
}

/// Ch}`oCgɕϊ
std::string StringHelper::ToMultiByteChar(const WCHAR* pSrc)
{
	CHAR chars[mStKDefaultBufferSize];
	wcstombs_s(NULL, chars, mStKDefaultBufferSize, pSrc, _TRUNCATE);

	return std::string(chars);
}


/// P[ݒ
void StringHelper::SetLocale(const TCHAR* kPLocale, int category, TCHAR* pOut)
{
	// P[ݒ	
	const TCHAR* kPState = _tsetlocale(category, kPLocale);
	PFL(_T("P[ݒ=%s"), kPState);

	// ASSERT:P[ݒłȂ玀
	ASSERT_PF(kPState, _T("P[̐ݒɎs܂B\nkPLocale=%s\ncategory=%d"), kPLocale, category);


	// o͕ϐLȂ
	if (pOut)
	{
		// 
		const int kSize = _tcslen(kPState) * sizeof(TCHAR);
		memcpy(pOut, kPState, kSize);
	}
}

/// P[{ɐݒ
void StringHelper::SetLocaleJapan()
{
	SetLocale(mStKPLocaleName, LC_ALL);
}