#include "Blast/Graphic/SpriteImage.h"

#include "Blast/Graphic/SpriteBatch.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
SpriteImage::SpriteImage()
	: mSize(0.0f)
	, mOrigin(0)
	, mScale(1)
	, mRotation(0)
	, mPosition(0)
	, mColor(ColorCode::ToCode(ColorCode::eCOLOR_WHITE))
{
}

/// fXgN^
SpriteImage::~SpriteImage()
{
}

/// XV
void SpriteImage::Update(float delta)
{
	// sXV
	UpdateWorldMatrix();
}

/// `
void SpriteImage::Render()
{
	// XvCgob`ɕ`C
	SpriteBatch* pSB = SpriteBatch::GetInstance();

	// XvCgob`Begin܂ȂȀBeginEndsđ`悷B
	if (pSB->IsHasBegun())
	{
		pSB->Render(this);
	}
	else
	{
		pSB->Begin();
		pSB->Render(this);
		pSB->End();
	}
}

/// TCYeNX`TCYɑ
void SpriteImage::FitSizeToTextureSize()
{
	// eNX`Ȃ
	ASSERT_PRINTF(mPTexture.GetSource(), _T("eNX`ݒ肳Ă܂B"));
	if (mPTexture.GetSource())
	{
		Float32 width = static_cast<float>(mPTexture->GetWidth());
		Float32 height = static_cast<float>(mPTexture->GetHeight());

		mSize.mX = width;
		mSize.mY = height;
	}
}

/// gk
void SpriteImage::Scaling(const Vector2& kRScale)
{
	mScale += kRScale;
}

/// ]
void SpriteImage::Rotate(const Vector3& kRRotate)
{
	mRotation += kRRotate;
}

/// ʒuړ
void SpriteImage::Translate(const Vector3& kRTranslate)
{
	mPosition += kRTranslate;
}

/// _ݒ
void SpriteImage::SetOrigin(EOrigin eOrigin)
{
	Vector2 origin;
	const Vector2 kHalfSize = mSize * 0.5f;

	// _̎ނŕB
	// ł̐ݒ̓XN[Wł͂Ȃ[hWł邱ƂɗӁB
	switch (eOrigin)
	{
		case eORIGIN_UP_LEFT:		origin = Vector2(-kHalfSize.mX,	-kHalfSize.mY);	break;
		case eORIGIN_UP_CENTER:		origin = Vector2(0,				-kHalfSize.mY);	break;
		case eORIGIN_UP_RIGHT:		origin = Vector2(kHalfSize.mX,	-kHalfSize.mY);	break;
		case eORIGIN_LEFT:			origin = Vector2(-kHalfSize.mX,	0);				break;
		case eORIGIN_CENTER:		origin = Vector2::Zero();						break;
		case eORIGIN_RIGHT:			origin = Vector2(kHalfSize.mX,	0);				break;
		case eORIGIN_DOWN_LEFT:		origin = Vector2(-kHalfSize.mX,	kHalfSize.mY);	break;
		case eORIGIN_DOWN:			origin = Vector2(0,				kHalfSize.mY);	break;
		case eORIGIN_DOWN_RIGHT:	origin = Vector2(kHalfSize.mX,	kHalfSize.mY);	break;
		default:	break;
	};

	SetOrigin(origin);
}

/// _ړ
void SpriteImage::TranslateOrigin(const Vector2& kRTranslate)
{
	mOrigin += kRTranslate;
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// TCY擾
const Vector2& SpriteImage::GetSize() const { return mSize; }
/// TCYݒ
void SpriteImage::SetSize(const Vector2& value) { mSize = value; }

/// _擾
const Vector2& SpriteImage::GetOrigin() const { return mOrigin; }
/// _ݒ
void SpriteImage::SetOrigin(const Vector2& value) { mOrigin = value; }

/// gk擾
const Vector2& SpriteImage::GetScale() const { return mScale; }
/// gkݒ
void SpriteImage::SetScale(const Vector2& value) { mScale = value; }

/// ]l擾
const Vector3& SpriteImage::GetRotation() const { return mRotation; }
/// ]lݒ
void SpriteImage::SetRotation(const Vector3& value) { mRotation = value; }

/// ʒu擾
const Vector3& SpriteImage::GetPosition() const { return mPosition; }
/// ʒuݒ
void SpriteImage::SetPosition(const Vector3& value) { mPosition = value; }

/// F擾
const Color& SpriteImage::GetColor() const { return mColor; }
/// Fݒ
void SpriteImage::SetColor(Color& value) { mColor = value; }

/// [hs擾
const Matrix& SpriteImage::GetWorld() const { return mWorld; }

/// eNX`擾
const SP<ITexture2D> SpriteImage::GetTexture() const { return mPTexture; }
/// eNX`擾
SP<ITexture2D> SpriteImage::GetTexture() { return mPTexture; }
/// eNX`ݒ
void SpriteImage::SetTexture(SP<ITexture2D> value) { mPTexture = value; }


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// [hsXV
void SpriteImage::UpdateWorldMatrix()
{
	// MEMO:PʒlȂ̂Ŋgsŕ₦܂B
	// TCYɍ킹ׂ̍s쐬
	Matrix sizeMat;
	sizeMat.CreateScale(mSize.mX, mSize.mY, 1);

	// MEMO:l͋tɂ܂B
	// _ړs쐬
	Matrix centerMat;
	centerMat.CreateTranslate(-mOrigin.mX, -mOrigin.mY, 0);

	// gks쐬
	Matrix scaleMat;
	scaleMat.CreateScale(mScale.mX, mScale.mY, 1);

	// ]s쐬
	Matrix rotMat;
	rotMat.CreateRotationZXY(mRotation);

	// sړs쐬
	Matrix transMat;
	transMat.CreateTranslate(mPosition);


	// [hsXV
	mWorld = sizeMat
		* centerMat
		* scaleMat
		* rotMat
		* transMat;
}