#include "Blast/Graphic/DirectX9/SpriteFontDX9.h"

#include "Blast/Graphic/ICamera.h"
#include "Blast/Graphic/ITexture2D.h"
#include "Blast/Graphic/DirectX9/FontTexture2DDX9.h"
#include "Blast/Graphic/SpriteBatch.h"

using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/* eNX` */

/// RXgN^
SpriteFontDX9::SFontTextureDatas::SFontTextureDatas()
{
	mCode = 0;
	mCharacter = '\0';
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
SpriteFontDX9::SpriteFontDX9(const TCHAR* kPFontName, int fontSize, int fontWeight)
{
	// tHgݒ
	mFaceNameStr = kPFontName;
	mPointSize = fontSize;
	mWeight = fontWeight;

	// C[W쐬
	mPImage.SetPointer(NEW SpriteImage());

	// XvCg쐬
	mPSprite.SetPointer(NEW SpriteDX9());

	// eNjbNݒ
	mPSprite->GetShaderEffect()->SetTechnique(ShaderEffectDX9::eTECHNIQUE_SOLID_WIREFRAME);

	// eNX`QNA
	mSFontTextureDataMap.clear();
}

/// fXgN^
SpriteFontDX9::~SpriteFontDX9()
{
}


/// `悷镶ݒ
void SpriteFontDX9::SetText(const TCHAR* kPText)
{
	// ێ
	mTextStr = kPText;


	// ̐Ń[v
	for (unsigned i = 0; i < mTextStr.size(); ++i)
	{
		// MEMO:UNICODEŖƐ삵Ȃł傤B
		// 1̂ݎ擾
		TCHAR character = mTextStr.at(i);
		unsigned code = character;


		// ܂ǉĂȂȂ
		SFontTextureDataMap::iterator it = mSFontTextureDataMap.find(code);
		if (it == mSFontTextureDataMap.end())
		{
			// tHgeNX`쐬
			FontTexture2DDX9* pTexture = NEW FontTexture2DDX9();
			pTexture->CreateTexture(code, mFaceNameStr.c_str(), mPointSize, mWeight);


			// eNX`쐬
			SFontTextureDatas sFCD;
			sFCD.mCode = code;
			sFCD.mCharacter = character;
			sFCD.mPTexture.SetPointer(pTexture);
			
			// eNX`}bvɒǉ
			SFontTextureDataMap::value_type pair(code, sFCD);
			mSFontTextureDataMap.insert(pair);

#ifdef _DEBUG
			/* _v */

			// tHg擾
			const GLYPHMETRICS& kRSGM = pTexture->GetGlyphMetricsRef();

			// tHgo
			PFL(_T("=%c, R[h=%#x, gmBlackBoxX=%d, gmBlackBoxY=%d, gmptGlyphOriginX=%d, gmptGlyphOriginY=%d, gmCellIncX=%d, gmCellIncY=%d"),
				character,
				code,
				kRSGM.gmBlackBoxX,
				kRSGM.gmBlackBoxY,
				kRSGM.gmptGlyphOrigin.x,
				kRSGM.gmptGlyphOrigin.y,
				kRSGM.gmCellIncX,
				kRSGM.gmCellIncY
				);
#endif // _DEBUG
		}
	}
}


/// `
void SpriteFontDX9::Render()
{
	// hbgoChbgɕKvȈʒu̕␳l
	const float kDBDOffsetX = -0.5f;
	const float kDBDOffsetY = 0.5f;

	// `ʒuXWl
	float posX = mPosition.mX;

	// ̐Ń[v
	SpriteBatch::GetInstance()->Begin();
	for (unsigned i = 0; i < mTextStr.size(); ++i)
	{
		// eNX`擾
		unsigned code = mTextStr.at(i);

		SFontTextureDataMap::iterator it = mSFontTextureDataMap.find(code);
		bool isFind = (it != mSFontTextureDataMap.end());
		ASSERT_PRINTF(isFind, _T("eNX`񂪂܂B=%c, R[h=%x\n"), mTextStr.at(i), code);
		if (!isFind)
		{
			continue;
		}

		// Q
		SFontTextureDatas& rSFCD = (*it).second;

		// eNX`LXg
		SP<FontTexture2DDX9> pTexture;
		bool isSucceed = pTexture.DownCast(rSFCD.mPTexture);

		// eNX`̃LXgɐȂ
		if (isSucceed)
		{
			// tHg擾
			const GLYPHMETRICS& kRSGM = pTexture->GetGlyphMetricsRef();

			// eNX`ݒ
			mPImage->SetTexture(pTexture);
			mPSprite->SetTexture(pTexture);

			// TCYݒ
			mPImage->FitSizeToTextureSize();
			mPSprite->FitTextureSize();
			mPSprite->FitTextureSourceRectangle();

			// _ݒ
			mPImage->SetOrigin(SpriteImage::eORIGIN_UP_LEFT);
			mPSprite->SetOrigin(SpriteDX9::eORIGIN_UP_LEFT);

			// ʒuݒ
			const float kBaseLineY = mPosition.mY;
			Vector3 pos(
				posX + kRSGM.gmptGlyphOrigin.x + kDBDOffsetX,
				kBaseLineY - kRSGM.gmptGlyphOrigin.y - kDBDOffsetY,
				mPosition.mZ);
			mPImage->SetPosition(pos);
			mPSprite->SetPosition(pos);

			// ]ݒ
			mPImage->SetRotation(mRotation);
			mPSprite->SetRotation(mRotation);

			// Fݒ
			mPImage->SetColor(mColor);
			mPSprite->SetColor(mColor);

			// Jݒ
			mPSprite->SetCamera(mPCamera);


			// [hsXV
			mPImage->UpdateWorldMatrix();
			mPSprite->UpdateWorldMatrix();

			// `
			mPImage->Render();
			//mPSprite->Render();


			// ̌̕_ʒu܂ł̋Z
			posX += kRSGM.gmCellIncX;
		}
	}
	SpriteBatch::GetInstance()->End();
}


/// ̗̈̒擾
int SpriteFontDX9::MeasureString(const TCHAR* const kPString) const
{
	// o͗pϐ
	int out = 0;

	// 擾
	int count = _tcslen(kPString);
	for (int i = 0; i < count; ++i)
	{
		// Q
		unsigned code = kPString[i];
		
		// eNX`擾
		SFontTextureDataMap::const_iterator it = mSFontTextureDataMap.find(code);

		// eNX`񂪎擾łȂ
		if (it != mSFontTextureDataMap.end())
		{
			// eNX`Q
			SP<ITexture2D> pTexture2D = (*it).second.mPTexture;

			// LXg
			FontTexture2DDX9* pFontTexture2DDX9 = dynamic_cast<FontTexture2DDX9*>(pTexture2D.GetSource());

			// LXgɐȂ
			if (pFontTexture2DDX9)
			{
				// ̕܂ł̈ʒuZ
				out += pFontTexture2DDX9->GetGlyphMetricsRef().gmCellIncX;
			}
		}
	}

	return out;
}


/// XV
void SpriteFontDX9::Update(float delta)
{
	// ̐Ń[v
	for (unsigned i = 0; i < mTextStr.size(); ++i)
	{
		// 1擾
		TCHAR code = mTextStr.at(i);

		// eNX`擾
		SFontTextureDataMap::iterator it = mSFontTextureDataMap.find(code);

		// eNX`񂪂Ȃ
		if (it != mSFontTextureDataMap.end())
		{
			// eNX`Q
			SFontTextureDatas& rSFCD = (*it).second;
		}
	}

	// XvCgXV
	mPSprite->Update(delta);

	// C[WXV
	mPImage->Update(delta);
}