#include "Blast/Graphic/SpriteBatch.h"

#include "Blast/Graphic/DirectX9/Texture2DDX9.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
SpriteBatch::SpriteBatch()
	: mIsHasBegun(false)
	, mPassCount(0)
{
	// bV쐬
	mPMesh.SetPointer( NEW MeshSpriteDX9() );

	// VF[_[GtFNgǂݍ
	ResourceManager* pRM = ResourceManager::GetInstance();
	mPShader = pRM->Load<ShaderEffectDX9>(ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_SPRITE2D));
}

/// fXgN^
SpriteBatch::~SpriteBatch()
{
}

/// ob`Jn
void SpriteBatch::Begin()
{
	// dJn͔F߂Ȃ
	ASSERT_PF(!mIsHasBegun, _T("BeginAčs悤Ƃ܂BBeginEnd1΂ŌĂԕKv܂B"));

	mIsHasBegun = true;
	
	// VF[_[Begins
	mPShader->Begin(&mPassCount);
}

/// ob`IBɎۂ̕`揈s
void SpriteBatch::End()
{
	// dI͔F߂Ȃ
	ASSERT_PF(mIsHasBegun, _T("EndAčs悤Ƃ܂BBeginEnd1΂ŌĂԕKv܂B"));

	// VF[_[͖YꂸɏIĂ
	mPShader->End();

	mIsHasBegun = false;
	mPassCount = 0;	//< Ô
}

/// 摜`
void SpriteBatch::Render(SpriteImage* pImage)
{
	// [hϊsݒ
	mPShader->SetMatrix(ShaderEffectDX9::eVARIABLE_WORLD, &MathHelperDX::ToD3DXMATRIX( pImage->GetWorld() ));

	// JȂAr[ƎˉeȂǂ̕ϊsݒ
	ASSERT_PRINTF(mPCamera, _T("Jݒ肳Ă܂B"));
	if (mPCamera)
	{
		mPShader->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEW, &MathHelperDX::ToD3DXMATRIX(mPCamera->GetViewMatrixRef()));
		mPShader->SetMatrix(ShaderEffectDX9::eVARIABLE_PROJECTION, &MathHelperDX::ToD3DXMATRIX(mPCamera->GetProjectionMatrixRef()));
		mPShader->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEWPORT, &MathHelperDX::ToD3DXMATRIX(mPCamera->GetViewportMatrixRef()));
	}
	// JȂ
	else
	{
		// Pʍsݒ
		D3DXMATRIX mat;
		D3DXMatrixIdentity(&mat);

		mPShader->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEW, &mat);
		mPShader->SetMatrix(ShaderEffectDX9::eVARIABLE_PROJECTION, &mat);
		mPShader->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEWPORT, &mat);
	}

	// ݒ
	mPShader->SetFloatArray(ShaderEffectDX9::eVARIABLE_AMBIENT_COLOR, pImage->GetColor().GetArray(), Color::mStKColorFactorCount - 1);

	// fBt[YJ[ɐݒ肷̂Ó̂͂AɊŏĂ̂łbŎcĂ
	mPShader->SetFloatArray(ShaderEffectDX9::eVARIABLE_DIFFUSE_COLOR, pImage->GetColor().GetArray(), Color::mStKColorFactorCount - 1);

	// eNX`ݒ
	Texture2DDX9* pTexture = dynamic_cast<Texture2DDX9*>(pImage->GetTexture().GetSource());
	if (pTexture)
	{
		mPShader->SetTexture(ShaderEffectDX9::eVARIABLE_DIFFUSE_TEXTURE, pTexture->GetTexturePtrRef().GetInterface());
	}

	// pX`
	for (int passIndex = 0; passIndex < (int)mPassCount; ++passIndex)
	{
		mPShader->BeginPass(passIndex);
		mPShader->CommitChanges();
		mPMesh->Render();
		mPShader->EndPass();
	}
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// J擾
SP<ICamera> SpriteBatch::GetCamera()
{
	return mPCamera;
}

/// Jݒ
void SpriteBatch::SetCamera(SP<ICamera> value)
{
	mPCamera = value;
}

/// Beginς݂ǂ擾
bool SpriteBatch::IsHasBegun() const
{
	return mIsHasBegun;
}