#include "Blast/Graphic/DirectX9/SpriteAnimationDX9.h"

#include "Blast/Graphic/ICamera.h"

using namespace Blast::Graphic;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------


	/* ö̏ */


	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	SpriteAnimationDX9::SSourceRectangle::SSourceRectangle()
	{
		// 
		Initialize();
	}

	/// 
	void SpriteAnimationDX9::SSourceRectangle::Initialize()
	{
		mRectangle.Initialize();
		mDurationTime = 1;
	}


	/* XvCgAj[ṼvpeB */


	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	SpriteAnimationDX9::SAnimationProperty::SAnimationProperty()
	{
		Initialize();
	}

	/// 
	void SpriteAnimationDX9::SAnimationProperty::Initialize()
	{
		mSourceRectangles.clear();
		mSpeed = 1;
	}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
SpriteAnimationDX9::SpriteAnimationDX9()
{
}

/// fXgN^
SpriteAnimationDX9::~SpriteAnimationDX9()
{
}


// 
void SpriteAnimationDX9::Initialize()
{
	// Aj[VɊւ
	mAnimationProperty.Initialize();

	// ݂̒öCfbNX
	mCurrentIndex = 0;

	// oߎԂ
	mElapsedTime = 0;

	// ̏s
	SpriteDX9::Initialize();
}

// XV
void SpriteAnimationDX9::Update(float delta)
{
	// ö̐1ȏȂ
	if (!mAnimationProperty.mSourceRectangles.empty())
	{
		// x0ȏłȂȂ
		if (0 <= mAnimationProperty.mSpeed)
		{
			// ێԂ̍v
			float totalDurationTime = 0;

			// ö̐Ń[v
			for (unsigned i = 0; i < mAnimationProperty.mSourceRectangles.size(); ++i)
			{
				// ێԂ擾
				float durationTime = mAnimationProperty.mSourceRectangles.at(i).mDurationTime;

				// x̋tZ
				durationTime *= (1.0f / mAnimationProperty.mSpeed);

				totalDurationTime += durationTime;
			}

			// CAUTION:[v
			// oߎԂێԂ̍v𒴂Ă
			while (totalDurationTime <= mElapsedTime)
			{
				// oߎԂێԂ̍vŌZ
				mElapsedTime -= totalDurationTime;
			}


			// ێԂ̍vZbg
			totalDurationTime = 0;

			// ö̐Ń[v
			for (unsigned i = 0; i < mAnimationProperty.mSourceRectangles.size(); ++i)
			{
				// öQ
				const SSourceRectangle& kRSourceRectangleRef = mAnimationProperty.mSourceRectangles.at(i);

				// ێԂ̍vZ
				totalDurationTime += kRSourceRectangleRef.mDurationTime * (1.0f / mAnimationProperty.mSpeed);

				// oߎԂێԈȉȂ
				if (mElapsedTime < totalDurationTime)
				{
					// CfbNX
					mCurrentIndex = i;

					break;
				}
			}
			
			// ASSERT:CfbNX0ȏłȂȂ玀
			ASSERT_PRINTF(0 <= mCurrentIndex, _T("CfbNX0ȏłȂ΂܂B"));


			// CfbNX璊öQ
			const SSourceRectangle& kRSR = mAnimationProperty.mSourceRectangles.at(mCurrentIndex);

			// öݒ
			SetSourceRectangle(
				static_cast<float>(kRSR.mRectangle.mTopX),
				static_cast<float>(kRSR.mRectangle.mTopY),
				static_cast<float>(kRSR.mRectangle.mBottomX),
				static_cast<float>(kRSR.mRectangle.mBottomY)
				);


			// MEMO:VłBǂŃZbgȂƑςȂƂɂȂł傤B
			// oߎԂXV
			mElapsedTime += delta;
		}
	}


	// NX̍XV
	SpriteDX9::Update(delta);
}