#include "Blast/Graphic/SkeletonStaticFbx.h"

#include "Blast/String/StringHelper.h"

using namespace fbxsdk_2012_2;
using namespace Blast::Math;
using namespace Blast::Graphic;
using namespace Blast::String;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	
	/// UNDONE:BtModelStaticDX9ɂ܂B
	/// Get the matrix of the given pose
	/// |[Yϊs擾
	KFbxXMatrix GetPoseMatrix(KFbxPose* pPose, int pNodeIndex)
	{
		KFbxXMatrix oseMatrix;
		KFbxMatrix lMatrix = pPose->GetMatrix(pNodeIndex);

		memcpy((double*)oseMatrix, (double*)lMatrix, sizeof(lMatrix.mData));

		return oseMatrix;
	}

	/// UNDONE:BtModelStaticDX9ɂ܂B
	/// m[h̃O[oȈʒuA܂胍[Jł͂Ȃʒu擾B
	KFbxXMatrix GetGlobalPosition(
		KFbxNode* pNode,
		const KTime& pTime,
		KFbxPose* pPose,
		KFbxXMatrix* pParentGlobalPosition
		)
	{
		KFbxXMatrix globalPosition;
		bool isPositionFound = false;

		if (pPose)
		{
			const int kNodeIndex = pPose->Find(pNode);

			if (-1 < kNodeIndex)
			{
				// The bind pose is always a global matrix.
				// If we have a rest pose, we need to check if it is
				// stored in global or local space.
				if (pPose->IsBindPose() || !pPose->IsLocalMatrix(kNodeIndex))
				{
					globalPosition = GetPoseMatrix(pPose, kNodeIndex);
				}
				else
				{
					// We have a local matrix, we need to convert it to
					// a global space matrix.
					KFbxXMatrix lParentGlobalPosition;

					if (pParentGlobalPosition)
					{
						lParentGlobalPosition = *pParentGlobalPosition;
					}
					else
					{
						if (pNode->GetParent())
						{
							lParentGlobalPosition = GetGlobalPosition(pNode->GetParent(), pTime, pPose, NULL);
						}
					}

					KFbxXMatrix lLocalPosition = GetPoseMatrix(pPose, kNodeIndex);
					globalPosition = lParentGlobalPosition * lLocalPosition;
				}

				isPositionFound = true;
			}
		}

		if (!isPositionFound)
		{
			globalPosition = pNode->EvaluateGlobalTransform(pTime);
		
#if CONFIRM || 1
			static int stCount = 0;
			if (stCount < 10)
			{
				++stCount;

				KFbxVector4 fbxS = globalPosition.GetS();
				KFbxVector4 fbxR = globalPosition.GetR();
				/* WA\ɂȂRgO */
				//for (int i = 0; i < 4; ++i)
				//{
				//	fbxR[i] = MathHelper::ToRadian(fbxR[i]);
				//}
				KFbxVector4 fbxT = globalPosition.GetT();
				#if 0	//< _vp
				PFL(_T("m[hu%svEvaluateGlobalTransform()̓(S%d/10):\n\tS(%lf, %lf, %lf)\n\tR(%lf, %lf, %lf)\n\tT(%lf, %lf, %lf)"),
					StringHelper::ToWideChar(pNode->GetName()).c_str(),
					stCount,
					fbxS[0], fbxS[1], fbxS[2],
					fbxR[0], fbxR[1], fbxR[2],
					fbxT[0], fbxT[1], fbxT[2]
					);
				#endif
			}
#endif // CONFIRM
		}

		return globalPosition;
	}

	/// UNDONE:BtModelStaticDX9ɂ܂B
	/// WIgɕۑꂽό`擾
	KFbxXMatrix GetGeometry(KFbxNode* kPNode)
	{
		return KFbxXMatrix();

		// MEMO:ԂFBX̗xNgɍ킹č珇ɑǂł傤H
		// KFbxMatrix̃RXgN^TRS̏Ŏ󂯎낤ƂĂ̂łɍ킹܂B
		KFbxVector4 geoT = kPNode->GetGeometricTranslation(KFbxNode::eSOURCE_SET);
		KFbxVector4 geoR = kPNode->GetGeometricRotation(KFbxNode::eSOURCE_SET);
		KFbxVector4 geoS = kPNode->GetGeometricScaling(KFbxNode::eSOURCE_SET);

		return KFbxXMatrix(geoT, geoR, geoS);
	}
	
	//Compute the transform matrix that the cluster will transform the vertex.
	// NX^̏ɉĒ_ό`BNX^Ƃ͂{[Ɠ`B
	void ComputeClusterDeformation(
		KFbxXMatrix& rGlobalPosition, 
		KFbxMesh* pMesh,
		KFbxCluster* pCluster, 
		KFbxXMatrix& rVertexTransformMatrix,
		KTime pTime, 
		KFbxPose* pPose)
	{
		KFbxCluster::ELinkMode dClusterMode = pCluster->GetLinkMode();

		KFbxXMatrix lReferenceGlobalInitPosition;
		KFbxXMatrix lReferenceGlobalCurrentPosition;
		KFbxXMatrix lAssociateGlobalInitPosition;
		KFbxXMatrix lAssociateGlobalCurrentPosition;
		KFbxXMatrix lClusterGlobalInitPosition;
		KFbxXMatrix lClusterGlobalCurrentPosition;

		KFbxXMatrix lReferenceGeometry;
		KFbxXMatrix lAssociateGeometry;
		KFbxXMatrix lClusterGeometry;

		KFbxXMatrix lClusterRelativeInitPosition;
		KFbxXMatrix lClusterRelativeCurrentPositionInverse;
		
		if (dClusterMode == KFbxLink::eADDITIVE && pCluster->GetAssociateModel())
		{
			pCluster->GetTransformAssociateModelMatrix(lAssociateGlobalInitPosition);
			// Geometric transform of the model
			lAssociateGeometry = GetGeometry(pCluster->GetAssociateModel());
			lAssociateGlobalInitPosition *= lAssociateGeometry;
			lAssociateGlobalCurrentPosition = GetGlobalPosition(pCluster->GetAssociateModel(), pTime, pPose, NULL);

			pCluster->GetTransformMatrix(lReferenceGlobalInitPosition);
			// Multiply lReferenceGlobalInitPosition by Geometric Transformation
			lReferenceGeometry = GetGeometry(pMesh->GetNode());
			lReferenceGlobalInitPosition *= lReferenceGeometry;
			lReferenceGlobalCurrentPosition = rGlobalPosition;

			// Get the link initial global position and the link current global position.
			pCluster->GetTransformLinkMatrix(lClusterGlobalInitPosition);
			// Multiply lClusterGlobalInitPosition by Geometric Transformation
			lClusterGeometry = GetGeometry(pCluster->GetLink());
			lClusterGlobalInitPosition *= lClusterGeometry;
			lClusterGlobalCurrentPosition = GetGlobalPosition(pCluster->GetLink(), pTime, pPose, NULL);

			// Compute the shift of the link relative to the reference.
			//ModelM-1 * AssoM * AssoGX-1 * LinkGX * LinkM-1*ModelM
			rVertexTransformMatrix =
				lReferenceGlobalInitPosition.Inverse()
				* lAssociateGlobalInitPosition * lAssociateGlobalCurrentPosition.Inverse()
				* lClusterGlobalCurrentPosition * lClusterGlobalInitPosition.Inverse() * lReferenceGlobalInitPosition;
		}
		else
		{
			pCluster->GetTransformMatrix(lReferenceGlobalInitPosition);
			lReferenceGlobalCurrentPosition = rGlobalPosition;
			// Multiply lReferenceGlobalInitPosition by Geometric Transformation
			lReferenceGeometry = GetGeometry(pMesh->GetNode());
			lReferenceGlobalInitPosition *= lReferenceGeometry;

			// Get the link initial global position and the link current global position.
			pCluster->GetTransformLinkMatrix(lClusterGlobalInitPosition);
			lClusterGlobalCurrentPosition = GetGlobalPosition(pCluster->GetLink(), pTime, pPose, NULL);

			// Compute the initial position of the link relative to the reference.
			lClusterRelativeInitPosition = lClusterGlobalInitPosition.Inverse() * lReferenceGlobalInitPosition;

			// Compute the current position of the link relative to the reference.
			lClusterRelativeCurrentPositionInverse = lReferenceGlobalCurrentPosition.Inverse() * lClusterGlobalCurrentPosition;

			// Compute the shift of the link relative to the reference.
			rVertexTransformMatrix =
				lClusterRelativeCurrentPositionInverse
				* lClusterRelativeInitPosition;
		}
	}
} // namespace Nameless


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
SkeletonStaticFbx::SkeletonStaticFbx() :
mPSkinDeformer(NULL),
mClusterCount(0),
mPClusterDeformations(NULL)
{
}

/// fXgN^
SkeletonStaticFbx::~SkeletonStaticFbx()
{
}


/// 
void SkeletonStaticFbx::Initialize(KFbxNode* pNode, KFbxMesh* pMesh)
{
	// XLAj[V̏SĂftH[}[ȂAȂ
	const int kDeformerCount = pMesh->GetDeformerCount(KFbxDeformer::eSKIN);
	if (kDeformerCount <= 0)
	{
		return;
	}
	
	// ftH[}[1݂̂T|[g
	ASSERT_PF(kDeformerCount <= 1, _T("Deformer̐2ȏ㑶݂Ă܂B̓T|[gOłB"));
	if (!(kDeformerCount <= 1))
	{
		return;
	}
	

	// 擪̃ftH[}[擾āAXLێNXɃLXg
	mPSkinDeformer = KFbxCast<KFbxSkin>(pMesh->GetDeformer(0, KFbxDeformer::eSKIN));


	// XL̃NX^̐擾BXL͐擪1݂̂T|[g
	const int kSkinIndex = 0;
	mClusterCount = mPSkinDeformer->GetClusterCount();
	ASSERT_PF(mClusterCount <= MAX_BONE_MATRICES, _T("dlݒ\ȃ{[𒴂Ă܂Bf\[X̃{[炵ĂB\ngp\ȃ{[=%d\nf\[X̃{[%d"), MAX_BONE_MATRICES, mClusterCount);

	// ϊs͕KvȐmۂ
	mPClusterDeformations.SetPointer(NEW KFbxXMatrix[mClusterCount], true);
	ZeroMemory(mPClusterDeformations.GetSource(), mClusterCount * sizeof(KFbxXMatrix));
}

/// |[Ys̍XV
void SkeletonStaticFbx::UpdatePose(
	KFbxXMatrix& rGlobalPosition,
	KFbxMesh* pMesh,
	KTime& pTime,
	KFbxPose* pPose)
{
	// XLAj[V̏SĂftH[}[ȂAȂ
	const int kDeformerCount = pMesh->GetDeformerCount(KFbxDeformer::eSKIN);
	if (kDeformerCount <= 0)
	{
		return;
	}

	// ftH[}[1݂̂T|[g
	ASSERT_PF(kDeformerCount <= 1, _T("Deformer̐2ȏ㑶݂Ă܂B̓T|[gOłB"));
	if (!(kDeformerCount <= 1))
	{
		return;
	}


	// Z[hȂPʉĂ
	KFbxCluster::ELinkMode eClusterMode = mPSkinDeformer->GetCluster(0)->GetLinkMode();
	if (eClusterMode == KFbxCluster::eADDITIVE)
	{
		for (int i = 0; i < mClusterCount; ++i)
		{
			mPClusterDeformations[i].SetIdentity();
		}
	}


	// XLɂ^Cv̂ŁAʓrB
	KFbxSkin::ESkinningType eSkinningType = mPSkinDeformer->GetSkinningType();
	if (eSkinningType == KFbxSkin::eLINEAR || eSkinningType == KFbxSkin::eRIGID)
	{
		// NX^ꂼ̕ϊsZoB
		const int kClusterCount = mPSkinDeformer->GetClusterCount();
		for (int clusterIndex = 0; clusterIndex < kClusterCount; ++clusterIndex)
		{
			// ̃NX^ɃNȂ珈XLbv
			KFbxCluster* pCluster = mPSkinDeformer->GetCluster(clusterIndex);
			if (!pCluster->GetLink())
			{
				continue;
			}

			// NX^̃ftH[s
			KFbxXMatrix vertexTransformMatrix;
			ComputeClusterDeformation(rGlobalPosition, pMesh, pCluster, vertexTransformMatrix, pTime, pPose);
			memcpy(&mPClusterDeformations[clusterIndex], &vertexTransformMatrix, sizeof(vertexTransformMatrix));
		}
	}
	else if (eSkinningType == KFbxSkin::eDUALQUATERNION)
	{
		HALT(_T("ueSkinningType == KFbxSkin::eDUALQUATERNIONv͖̏łB"));
	}
	else if (eSkinningType == KFbxSkin::eBLEND)
	{
		HALT(_T("ueSkinningType == KFbxSkin::eBLENDv͖̏łB"));
	}
}
