#include "Blast/Graphic/DirectX9/ShaderEffectDX9.h"

#include "Blast/Graphic/ITexture.h"
#include "Blast/Graphic/DirectX9/ITextureDX9.h"

#include "Blast/Math/DirectX/MathHelperDX.h"
#include "Blast/String/StringHelper.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::String;
using namespace Blast::Math;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// 񋓑̂ɑΉVF[_[GtFNg̃t@CpX擾
const TCHAR* const ShaderEffectDX9::ToFilePath(EShaderEffect eSE)
{
	// MEMO:͈͊OANZX͑܂B
	return stKPFullPaths[eSE];
}

/// 񋓑̂ɑΉVF[_[ϐ擾
const CHAR* const ShaderEffectDX9::ToVariableName(EVariable eVariable)
{
	// MEMO:͈͊OANZX͑܂B
	return stKPVariableNames[eVariable];
}

/// 񋓑̂ɑΉeNjbN擾
const CHAR* const ShaderEffectDX9::ToTechniqueName(ETechnique eTechnique)
{
	// MEMO:͈͊OANZX͑܂B
	return stKPTechniqueNames[eTechnique];
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
ShaderEffectDX9::ShaderEffectDX9()
	: mFilePathStr(_T(""))
	, mIsBegan(false)
{
}

/// fXgN^
ShaderEffectDX9::~ShaderEffectDX9()
{
}

/// VF[_[GtFNgǂݍ
bool ShaderEffectDX9::Load(const TCHAR* const kPFullPath)
{
	// foCX擾
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();

	// pXێ
	mFilePathStr = kPFullPath;

	// ǂݍ
	LPD3DXBUFFER pError = NULL;
	HRESULT hr = D3DXCreateEffectFromFile(
		pDevice,
		kPFullPath,
		NULL,
		NULL,
		0,
		NULL,
		mPShaderEffect.ToCreator(),
		&pError);

	// G[obt@LȂ
	if (pError)
	{
		// G[e擾
		const CHAR* pMBs = static_cast<CHAR*>(pError->GetBufferPointer());
		u32 bufferSize = pError->GetBufferSize();

#ifdef UNICODE

		// }`oCgChɕϊ܂B
		WCHAR pWCs[StringHelper::mStKDefaultBufferSize];
		ZeroMemory(pWCs, sizeof(pWCs));

		StringHelper::ToWideChar(NULL, pWCs, bufferSize, pMBs);

		// HALT:G[fĎɂ܂B
		HALT(_T("VF[_[GtFNg̓ǂݍ݂Ɏs܂B\npX=%s\n%s"), kPFullPath, pWCs);

#else

		// o
		HALT(_T("VF[_[GtFNg̓ǂݍ݂Ɏs܂B\ntpX=%s\n%s"), kPFullPath, pMBs);

#endif // UNICODE
	}

	return mPShaderEffect;
}

/// VF[_[GtFNgǂݍ
bool ShaderEffectDX9::Load(EShaderEffect eShaderEffect)
{
	// tpX擾
	const TCHAR* kPFullPath = stKPFullPaths[eShaderEffect];

	// ǂݍ
	return Load(kPFullPath);
}

/// Jn
void ShaderEffectDX9::Begin(unsigned* pOutPassCount, unsigned long flag)
{
	HRESULT hr = mPShaderEffect->Begin(pOutPassCount, flag);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[̊JnɎs܂B"));

	mIsBegan = true;
}

/// I
void ShaderEffectDX9::End()
{
	HRESULT hr = mPShaderEffect->End();
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[̏IɎs܂B"));

	mIsBegan = false;
}


/// pXJn
void ShaderEffectDX9::BeginPass(int index)
{
	HRESULT hr = mPShaderEffect->BeginPass(index);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[̃pXJnɎs܂B"));
}

/// pXI
void ShaderEffectDX9::EndPass()
{
	HRESULT hr = mPShaderEffect->EndPass();
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[̃pXIɎs܂B"));
}

/// lݒ
void ShaderEffectDX9::SetValue(D3DXHANDLE handle, void* pData, unsigned size)
{
	HRESULT hr = mPShaderEffect->SetValue(handle, pData, size);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[ϐw%sxւ̒l̐ݒ肪s܂B"), handle);
}

/// lݒ
void ShaderEffectDX9::SetValue(EVariable eVariable, void* pData, unsigned size)
{
	SetValue(stKPVariableNames[eVariable], pData, size);
}


/// float^zݒ
void ShaderEffectDX9::SetFloatArray(D3DXHANDLE handle, const FLOAT kValues[], unsigned count)
{
	HRESULT hr = mPShaderEffect->SetFloatArray(handle, kValues, count);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[ϐw%sxւfloat^z̐ݒ肪s܂B"), handle);
}

/// float^zݒ
void ShaderEffectDX9::SetFloatArray(EVariable eVariable, const FLOAT kValues[], unsigned count)
{
	SetFloatArray(stKPVariableNames[eVariable], kValues, count);
}


/// D3DXVECTOR4^zݒ
void ShaderEffectDX9::SetVectorArray(D3DXHANDLE handle, const D3DXVECTOR4 kValues[], unsigned count)
{
	HRESULT hr = mPShaderEffect->SetVectorArray(handle, kValues, count);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[ϐw%sxւD3DXVECTOR4^z̐ݒ肪s܂B"), StringHelper::ToWideChar(handle).c_str());
}

/// D3DXVECTOR4^zݒ
void ShaderEffectDX9::SetVectorArray(EVariable eVariable, const D3DXVECTOR4 kValues[], unsigned count)
{
	SetVectorArray(stKPVariableNames[eVariable], kValues, count);
}


/// float4x4ݒ
void ShaderEffectDX9::SetMatrix(D3DXHANDLE handle, const D3DXMATRIX* kPMatrixDX)
{
	HRESULT hr = mPShaderEffect->SetMatrix(handle, kPMatrixDX);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[ϐw%sxւ̍s̐ݒ肪s܂B"), handle);
}

/// Matrixݒ
void ShaderEffectDX9::SetMatrix(D3DXHANDLE handle, const Matrix* kPMatrix)
{
	SetMatrix(handle, &MathHelperDX::ToD3DXMATRIX(*kPMatrix));
}

/// float4x4ݒ
void ShaderEffectDX9::SetMatrix(EVariable eVariable, const D3DXMATRIX* kPMatrixDX)
{
	SetMatrix(stKPVariableNames[eVariable], kPMatrixDX);
}

/// Matrixݒ
void ShaderEffectDX9::SetMatrix(EVariable eVariable, const Matrix* kPMatrix)
{
	SetMatrix(eVariable, &MathHelperDX::ToD3DXMATRIX(*kPMatrix));
}


/// float4x4z擾
void ShaderEffectDX9::GetMatrixArray(D3DXHANDLE handle, D3DXMATRIX* pOut, unsigned count)
{
	HRESULT hr = mPShaderEffect->GetMatrixArray(handle, pOut, count);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[ϐw%sx̍sz̎擾s܂B"), handle);
}

/// float4x4z擾
void ShaderEffectDX9::GetMatrixArray(EVariable eVariable, D3DXMATRIX* pOut, unsigned count)
{
	GetMatrixArray(stKPVariableNames[eVariable], pOut, count);
}

/// float4x4zݒ
void ShaderEffectDX9::SetMatrixArray(D3DXHANDLE handle, const D3DXMATRIX* kPMatrixDX, unsigned count)
{
	HRESULT hr = mPShaderEffect->SetMatrixArray(handle, kPMatrixDX, count);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[ϐw%sxւ̍sz̐ݒ肪s܂B"), handle);
}

/// float4x4zݒ
void ShaderEffectDX9::SetMatrixArray(EVariable eVariable, const D3DXMATRIX* kPMatrixDX, unsigned count)
{
	SetMatrixArray(stKPVariableNames[eVariable], kPMatrixDX, count);
}


/// boolݒ
void ShaderEffectDX9::SetBool(D3DXHANDLE handle, BOOL isFlag)
{
	HRESULT hr = mPShaderEffect->SetBool(handle, isFlag);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[ϐw%sxւ̘_^̐ݒ肪s܂B"), handle);
}

/// boolݒ
void ShaderEffectDX9::SetBool(EVariable eVariable, BOOL isFlag)
{
	SetBool(stKPVariableNames[eVariable], isFlag);
}

/// boolzݒ
void ShaderEffectDX9::SetBoolArray(D3DXHANDLE handle, BOOL isFlags[], unsigned count)
{
	HRESULT hr = mPShaderEffect->SetBoolArray(handle, isFlags, count);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[ϐw%sxւ̘_^̐ݒ肪s܂B"), StringHelper::ToWideChar(handle).c_str());
}

/// boolzݒ
void ShaderEffectDX9::SetBoolArray(EVariable eVariable, BOOL isFlags[], unsigned count)
{
	SetBoolArray(stKPVariableNames[eVariable], isFlags, count);
}


/// Textureݒ
void ShaderEffectDX9::SetTexture(D3DXHANDLE handle, IDirect3DTexture9* kPTexture)
{
	HRESULT hr = mPShaderEffect->SetTexture(handle, kPTexture);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[ϐw%sxւ̃eNX`̐ݒ肪s܂B"), handle);
}

/// Textureݒ
void ShaderEffectDX9::SetTexture(EVariable eVariable, IDirect3DTexture9* pTexture)
{
	SetTexture(stKPVariableNames[eVariable], pTexture);
}


/// ύXʒm
void ShaderEffectDX9::CommitChanges()
{
	HRESULT hr = S_OK;
	hr = mPShaderEffect->CommitChanges();
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[ւ̕ϐmʒms܂B"));
}


/// Z}eBNXϐ̃nh擾
D3DXHANDLE ShaderEffectDX9::GetParameterBySemantic(D3DXHANDLE level, LPCSTR name)
{
	D3DXHANDLE handle = mPShaderEffect->GetParameterBySemantic(level, name);
	WARNING(handle, _T("Z}eBNXu%sv܂łB"), name);

	return handle;
}


/// eNjbN擾
D3DXHANDLE ShaderEffectDX9::GetTechnique(unsigned index)
{
	return mPShaderEffect->GetTechnique(index);
}


/// eNjbNݒ
void ShaderEffectDX9::SetTechnique(D3DXHANDLE pName)
{
	HRESULT hr = mPShaderEffect->SetTechnique(pName);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("VF[_[eNjbN̐ݒɎs܂B"));
}

/// eNjbNݒ
void ShaderEffectDX9::SetTechnique(int index)
{
	// CfbNXɑΉeNjbNnh擾
	D3DXHANDLE handle = mPShaderEffect->GetTechnique(index);

	// Ϗ
	SetTechnique(handle);
}

/// eNjbNݒ
void ShaderEffectDX9::SetTechnique(ETechnique eTechnique)
{
	// eNjbN̕擾
	const CHAR* kPTechniqueName = stKPTechniqueNames[eTechnique];

	// Ϗ
	mPShaderEffect->SetTechnique(kPTechniqueName);
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// VF[_[GtFNg擾BconsttB
const CSP<ID3DXEffect> ShaderEffectDX9::GetShaderEffect() const { return mPShaderEffect; }

/// VF[_[GtFNg擾
CSP<ID3DXEffect> ShaderEffectDX9::GetShaderEffect() { return mPShaderEffect; }	///< const_castgȂ悤Ȃ̂ł̂܂return

/// t@CpX擾
const TCHAR* ShaderEffectDX9::GetFilePath() const { return mFilePathStr.c_str(); }

/// BeginσtO擾
bool ShaderEffectDX9::IsBegan() const { return mIsBegan; }


//====================================================================================================
// Field
//----------------------------------------------------------------------------------------------------

/// VF[_[GtFNg̎ނɑΉtpX
const TCHAR* const ShaderEffectDX9::stKPFullPaths[] =
{
	_T("./Res/Shader/StandardConstant.fx"),
	_T("./Res/Shader/StandardLambert.fx"),
	_T("./Res/Shader/StandardPhong.fx"),
	_T("./Res/Shader/StandardPrimitive.fx"),
	_T("./Res/Shader/Character.fx"),
	_T("./Res/Shader/Line3D.fx"),
	_T("./Res/Shader/Grid3D.fx"),
	_T("./Res/Shader/Crosshair.fx"),

	_T("./Res/Shader/Sprite2D.fx"),
	_T("./Res/Shader/Sprite3D.fx"),
	_T("./Res/Shader/Fade.fx"),
	_T("./Res/Shader/EffectTechniques.fx"),
	_T("./Res/Shader/SkinAnimationTechniques.fx"),
};

/// MEMO:񋓑̂ɑΉĂ܂B
/// O[oϐ̎ނɑΉϐ
const CHAR* const ShaderEffectDX9::stKPVariableNames[] =
{
	"gWorld",
	"gView",
	"gProjection",
	"gViewport",
	"gUVMatrix",
	"gWorldIT",
	"gWVP",
	"gViewI",
	"gPose",

	"gAmbientColor",
	"gDiffuseColor",
	"gPointPosition",
	"gPointColor",
	"gKs",
	"gSpecularExponent",
	"gBumpiness",
	"gKr",

	"gInstancePositions",
	"gInstanceVisibles",

	"gDiffuseTexture",
	"gNormalTexture",
	"gEnvironmentTexture",
	"gRuleTexture",

	"gCurrentPose",
};

/// eNjbN̎ނɑΉeNjbNQ
const CHAR* const ShaderEffectDX9::stKPTechniqueNames[] =
{
	"Solid",
	"WireFrame",
	"SolidWireFrame",

	"Wireframe",

	"Constant",
	"ConstantWireFrame",

	"Lambert",

	"Phong",
};