#include "Blast/Base/SequenceBase.h"

using namespace Blast::Base;
using namespace Blast::Input;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
SequenceBase::SequenceBase(bool isPopup, SP<ISequenceUserData> pUserData)
{
	Construct(isPopup, pUserData);
}

/// fXgN^
SequenceBase::~SequenceBase()
{
	// MEMO:vfGameComponentQƂĂ邽߁AŃNAȂƎQƂcĂ܂܂B
	// MEMO:GameComponent̎QƂX}[g|C^ɂȂ@͂ǂł傤B
	mPGameComponents->Clear();
}


/// 
void SequenceBase::Initialize()
{
}

/// ŏI
void SequenceBase::Finalize()
{
}

/// ͏
void SequenceBase::HandleInput(float delta)
{
#ifdef _DEBUG
	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();

	// BaskspaceL[ꂽȂ
	if (pKB->IsJustDown(Keys::eKEY_BACKSPACE))
	{
		// I
		Exit();
	}

	// Ctrl+DŃfobOj[̗LAgOύX
	if ((pKB->IsDown(Keys::eKEY_LCONTROL) || pKB->IsDown(Keys::eKEY_RCONTROL)) &&
		pKB->IsJustDown(Keys::eKEY_D))
	{
		mIsDebugEnable = !mIsDebugEnable;
	}

	// fobOj[̓͏
	if (mIsDebugEnable)
	{
		mPDebugMenu->HandleInput(delta);
	}
#endif // _DEBUG
}

/// XV
void SequenceBase::Update(float delta)
{
	// XVLȂ
	if (mIsEnable)
	{
		// Q[R|[lgXV
		mPGameComponents->Update(delta);


		// oߎԂZ
		mElapsedTime += delta;


		// JڏԂŕ
		switch (mETransitionState)
		{
			// ANeBuȂ
			case eTRANSITION_STATE_ACTIVE:

				// MEMO:܂B

				break;

			// lKeBuȂ
			case eTRANSITION_STATE_NEGATIVE:

				// MEMO:܂B

				break;

			// ANeBu֑JڒȂ
			case eTRANSITION_STATE_ON:

				// ANeBu܂ł̑JڎԂ0Ȃ
				if (mTransitionOnTime == 0)
				{
					// 1ݒ
					mTransitionPosition = 1;
				}
				else
				{
					// JڈʒuZo
					mTransitionPosition = mElapsedTime / mTransitionOnTime;
				}

				// Jڈʒu1ȏȂ
				if (1 <= mTransitionPosition)
				{
					// 1ݒ
					mTransitionPosition = 1;

					// JڏԂύX
					mETransitionState = eTRANSITION_STATE_ACTIVE;
				}

				break;

			// lKeBu֑JڒȂ
			case eTRANSITION_STATE_OFF:

				// lKeBu܂ł̑JڎԂ0Ȃ
				if (mTransitionOffTime == 0)
				{
					// 0
					mTransitionPosition = 0;
				}
				else
				{
					// JڈʒuZo
					double elapsedOffTime = mElapsedTime - mTransitionOffStartTime;
					mTransitionPosition = 1 - (elapsedOffTime / mTransitionOffTime);
				}

				// Jڈʒu0ȉȂ
				if (mTransitionPosition <= 0)
				{
					// 0
					mTransitionPosition = 0;

					// ItO𗧂Ă
					mIsExit = true;

					// ԂJ
					mETransitionState = eTRANSITION_STATE_NEGATIVE;
				}

				break;

			// P[XOȂ
			default:
				break;
		};

#ifdef _DEBUG

		// fobOj[̍XV
		if (mIsDebugEnable)
		{
			mPDebugMenu->Update(delta);
		}

#endif // _DEBUG
	}
}

/// `
void SequenceBase::Render()
{
	// `悪LȂ
	if (mIsVisible)
	{
		// Q[R|[lg`
		mPGameComponents->Render();

#ifdef _DEBUG
		// fobOj[̕`
		if (mIsDebugEnable)
		{
			mPDebugMenu->Render();
		}
#endif // _DEBUG
	}
}


/// I
void SequenceBase::Exit()
{
	// lKeBu֑Jڒł͂ȂAlKeBuԂłȂȂ
	if (mETransitionState != eTRANSITION_STATE_OFF &&
		mETransitionState != eTRANSITION_STATE_NEGATIVE)
	{
		// MEMO:lKeBu܂ł̎Ԃ0̏ꍇAڏItO𗧂Ăǂł傤B

		// IJnԂ}[N
		mTransitionOffStartTime = mElapsedTime;

		// JڏԂύX
		mETransitionState = eTRANSITION_STATE_OFF;
	}
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// RXgN^
void SequenceBase::Construct(bool isPopup, SP<ISequenceUserData> pUserData)
{
	mIsEnable = true;
	mIsVisible = true;
	mIsPopUp = isPopup;
	mIsExit = false;
	mElapsedTime = 0;
	mETransitionState = eTRANSITION_STATE_ON;
	mTransitionPosition = 0;
	mTransitionOnTime = 0;
	mTransitionOffTime = 0;
	mTransitionOffStartTime = 0;
	mPUserData = pUserData;
	mPGameComponents.SetPointer(NEW  GameComponentContainer());

#ifdef _DEBUG
	// fobOj[쐬
	mPDebugMenu.SetPointer(NEW Menu());
	mIsDebugEnable = true;
#endif // _DEBUG
}