#include "Blast/Base/SelectableColorComponent.h"

using namespace Blast::Base;
using namespace Blast::Graphic;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// I\őI𒆂̏F
const Color SelectableColorComponent::mStKInitialStateColors[] = 
{
	ColorCode::ToCode(ColorCode::eCOLOR_GOLD),
	ColorCode::ToCode(ColorCode::eCOLOR_WHITE),
	ColorCode::ToCode(ColorCode::eCOLOR_BLACK),
	ColorCode::ToCode(ColorCode::eCOLOR_GRAY),
};


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
SelectableColorComponent::SelectableColorComponent()
{
	// F
	for (int i = 0; i < eSTATE_COUNT; ++i)
	{
		mStateColors[i] = mStKInitialStateColors[i];
	}
}

/// fXgN^
SelectableColorComponent::~SelectableColorComponent()
{
}


/// Ԃ̐F擾
const Color& SelectableColorComponent::GetStateColorRef() const
{
	// I\Ȃ
	if (mIsSelectable)
	{
		// IĂȂ
		if (mIsSelected)
		{
			return mStateColors[eSTATE_SELECTABLE_SELECTED];
		}
		// IĂȂȂ
		else
		{
			return mStateColors[eSTATE_SELECTABLE_UNSELECTED];
		}
	}
	// Is\Ȃ
	else
	{
		// IĂȂ
		if (mIsSelected)
		{
			return mStateColors[eSTATE_UNSELECTABLE_SELECTED];
		}
		// IĂȂȂ
		else
		{
			return mStateColors[eSTATE_UNSELECTABLE_UNSELECTED];
		}
	}
}

/// Ԃ̐Fݒ
void SelectableColorComponent::SetStateColor(const Color& kRColor, EState eState)
{
	mStateColors[eState] = kRColor;
}