#include "Blast/Math/Point.h"

using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Point::Point() :
mX(0),
mY(0)
{
}

/// RXgN^
Point::Point(int x, int y) :
mX(x),
mY(y)
{
}

/// RXgN^
Point::Point(int a) :
mX(a),
mY(a)
{
}

/// fXgN^
Point::~Point()
{
}


/// e̘̓a擾
int Point::SquareLength() const
{
	return mX * mX + mY + mY;
}


/// =
void Point::operator= (const Point& kRA)
{
	mX = kRA.mX;
	mY = kRA.mY;
}

/// +
Point Point::operator+ (const Point& kRA) const
{
	Point value = *this;
	value.mX += kRA.mX;
	value.mY += kRA.mY;

	return value;
}

/// -
Point Point::operator- (const Point& kRA) const
{
	Point value = *this;
	value.mX -= kRA.mX;
	value.mY -= kRA.mY;

	return value;
}


/// ==
bool Point::operator== (const Point& kRA) const
{
	return (mX == kRA.mX && mY == kRA.mY);
}

/// +=
void Point::operator+= (const Point& kRA)
{
	mX += kRA.mX;
	mY += kRA.mY;
}

/// -=
void Point::operator-= (const Point& kRA)
{
	mX -= kRA.mX;
	mY -= kRA.mY;
}


/// []
int& Point::operator[] (int index)
{
	switch (index)
	{
		case 0:	return mX;
		case 1:	return mY;
		default:	HALT(_T("CfbNX̎w肪łB"));	break;
	};

	return mX;
}


//====================================================================================================
// PrivateStatic
//----------------------------------------------------------------------------------------------------

/// (0, 0)
const Point Point::stKZero(0, 0);

/// (1, 0)
const Point Point::stKUnitX(1, 0);

/// (0, 1)
const Point Point::stKUnitY(0, 1);

/// (1, 1)
const Point Point::stKOne(1, 1);