#include "Blast/Input/DirectX8/MouseDX8.h"

#include "Blast/Input/DirectX8/MouseDeviceDX8.h"

using namespace Blast::Input;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/* {^̏ */

/// Ԃ̍ől
const float MouseDX8::SButtonState::stKMaxTime = 1024;

/// RXgN^
MouseDX8::SButtonState::SButtonState() :
mDownDurationTime(0),
mDownDelayTime(0),
mUpDurationTime(0),
mUpDelayTime(0)
{
}

/// LȏԂ̍XV
void MouseDX8::SButtonState::UpdateEnable(const float& kRDelta)
{
	mDownDurationTime += kRDelta;
	mDownDelayTime += kRDelta;
	mUpDurationTime = 0;
	mUpDelayTime = 0;

	UpdateClamp();
}

/// ȏԂ̍XV
void MouseDX8::SButtonState::UpdateDisable(const float& kRDelta)
{
	mDownDurationTime = 0;
	mDownDelayTime = 0;
	mUpDurationTime += kRDelta;
	mUpDelayTime += kRDelta;

	UpdateClamp();
}

/// Nvs
void MouseDX8::SButtonState::UpdateClamp()
{
	// MEMO:I[o[̗}̂ݍsĂ܂B
	// MEMO:NvsĂ@\΁cB

	if (stKMaxTime <= mDownDurationTime)
	{
		mDownDurationTime = stKMaxTime;
	}

	if (stKMaxTime <= mDownDelayTime)
	{
		mDownDelayTime = stKMaxTime;
	}

	if (stKMaxTime <= mUpDurationTime)
	{
		mUpDurationTime = stKMaxTime;
	}

	if (stKMaxTime <= mUpDelayTime)
	{
		mUpDelayTime = stKMaxTime;
	}
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MouseDX8::MouseDX8() :
mPDevice(NULL),
mPositionX(0),
mPositionY(0)
{
	// }EX̏Ԃ
	ZeroMemory(mMouseStatus, sizeof(mMouseStatus));

	// {^̏Ԃ
	ZeroMemory(mMouseButtonStatus, sizeof(mMouseButtonStatus));
}

/// fXgN^
MouseDX8::~MouseDX8()
{
	SAFE_DELETE(mPDevice);
}

/// foCX쐬
bool MouseDX8::Create(HWND hWnd, LPDIRECTINPUT8 pDirectInput)
{
	bool isOk = false;

	// }EX쐬
	mPDevice = new MouseDeviceDX8();
	isOk = mPDevice->Create(hWnd, pDirectInput);
	
	return isOk;
}

/// XV
void MouseDX8::Update(const float& kRDelta)
{
	// }EX̏L擾
	HRESULT hr = mPDevice->GetInputDevice()->Acquire();

	// }EX̏L̎擾ɎsȂ
	if (FAILED(hr))
	{
		return;
	}

	// {^̍XV
	UpdateMouseStates(kRDelta);
}

/// {^Ă邩擾
bool MouseDX8::IsDown(Buttons::EButton eButton) const
{
	// MEMO:̏ԂLȂ牟Ă܂

	const c8& kRButton = mMouseStatus[eMOUSE_STATE_CURRENT].rgbButtons[eButton];

	bool isDown = IsEnable(kRButton);

	return isDown;
}

/// {^ꂽuԂ擾
bool MouseDX8::IsJustDown(Buttons::EButton eButton) const
{
	// MEMO:ȌԂŁȀԂLȎꂽuԂł

	const c8& kROldButton = mMouseStatus[eMOUSE_STATE_OLD].rgbButtons[eButton];
	const c8& kRCurrentButton = mMouseStatus[eMOUSE_STATE_CURRENT].rgbButtons[eButton];

	bool isOldDisable = IsDisable(kROldButton);
	bool isCurrentEnable = IsEnable(kRCurrentButton);

	bool isJustDown = (isOldDisable && isCurrentEnable);

	return isJustDown;
}

/// {^Ă邩擾
bool MouseDX8::IsUp(Buttons::EButton eButton) const
{
	// MEMO:̏ԂȂ痣Ă܂

	const c8& kRButton = mMouseStatus[eMOUSE_STATE_CURRENT].rgbButtons[eButton];

	bool isUp = IsDisable(kRButton);

	return isUp;
}

/// {^ꂽuԂ擾
bool MouseDX8::IsJustUp(Buttons::EButton eButton) const
{
	// MEMO:ȌԂLŁȀԂȎꂽuԂł

	const c8& kROldButton = mMouseStatus[eMOUSE_STATE_OLD].rgbButtons[eButton];
	const c8& kRCurrentButton = mMouseStatus[eMOUSE_STATE_CURRENT].rgbButtons[eButton];

	bool isOldDown = IsEnable(kROldButton);
	bool isCurrentUp = IsDisable(kRCurrentButton);

	bool isJustUp = (isOldDown && isCurrentUp);

	return isJustUp;
}

/// {^Ă邩ԊuŎ擾
bool MouseDX8::IsRapidDown(Buttons::EButton eButton, const float& kRInterval)
{
	// uԂȂ
	if (IsJustDown(eButton))
	{
		return true;
	}
	// uԂł͂ȂȂ
	else
	{
		// MEMO:Ă鎞Ԃ莞Ԃz画肵܂

		SButtonState& rSBS = mMouseButtonStatus[eButton];
		if (kRInterval <= rSBS.mDownDurationTime)
		{
			// MEMO:0ɂ͍̂l̂łcH
			rSBS.mDownDurationTime = 0;

			return true;
		}
	}

	return false;
}

/// {^Ă邩ԊuŎ擾
bool MouseDX8::IsRapidUp(Buttons::EButton eButton, const float& kRInterval)
{
	// uԂȂ
	if (IsJustUp(eButton))
	{
		return true;
	}
	// uԂł͂ȂȂ
	else
	{
		// MEMO:Ă鎞Ԃ莞Ԃz画肵܂

		SButtonState& rSBS = mMouseButtonStatus[eButton];
		if (kRInterval <= rSBS.mUpDurationTime)
		{
			// MEMO:0ɂ͍̂l̂łcH
			rSBS.mUpDurationTime = 0;

			return true;
		}
	}

	return false;
}

/// {^Ă邩莞ԌォԊuŎ擾
bool MouseDX8::IsDelayRapidDown(Buttons::EButton eButton, const float& kRInterval, const float& kRDelay)
{
	// uԂȂ
	if (IsJustDown(eButton))
	{
		return true;
	}
	// uԂł͂ȂȂ
	else
	{
		// MEMO:Ă鎞ԂxԂ𒴂画肵܂

		SButtonState& rSBS = mMouseButtonStatus[eButton];
		if (kRDelay <= rSBS.mDownDelayTime)
		{
			return IsRapidDown(eButton, kRInterval);
		}
	}

	return false;
}

/// {^Ă邩莞ԌォԊuŎ擾
bool MouseDX8::IsDelayRapidUp(Buttons::EButton eButton, const float& kRInterval, const float& kRDelay)
{
	// uԂȂ
	if (IsJustUp(eButton))
	{
		return true;
	}
	// uԂł͂ȂȂ
	else
	{
		// MEMO:Ă鎞ԂxԂ𒴂画肵܂

		SButtonState& rSBS = mMouseButtonStatus[eButton];
		if (kRDelay <= rSBS.mUpDelayTime)
		{
			return IsRapidUp(eButton, kRInterval);
		}
	}

	return false;
}



/// J[\XW擾
int MouseDX8::GetPositionX() const
{
	return mPositionX;
}

/// J[\YW擾
int MouseDX8::GetPositionY() const
{
	return mPositionY;
}

/// J[\XẄړʂ擾
int MouseDX8::GetDeltaPositionX() const
{
	// MEMO:lXɊi[Ă͈̂ʒuł͂ȂړʂłB

	return mMouseStatus[eMOUSE_STATE_CURRENT].lX;
}

/// J[\YẄړʂ擾
int MouseDX8::GetDeltaPositionY() const
{
	// MEMO:lYɊi[Ă͈̂ʒuł͂ȂړʂłB

	return mMouseStatus[eMOUSE_STATE_CURRENT].lY;
}

/// zC[̑ʂ擾
long MouseDX8::GetWheel() const
{
	// MEMO:}EXzC[̓͗plZɊi[Ă܂B

	return mMouseStatus[eMOUSE_STATE_CURRENT].lZ;
}

/// zC[̏]sꂽǂ擾
bool MouseDX8::IsWheelUp() const
{
	// MEMO:zC[̓͗ʂlĂȂtruełB

	const l32& kRWheel = GetWheel();

	bool isWheelUp = (stKWheelBorderValue <= kRWheel);

	return isWheelUp;
}

/// zC[̉]sꂽǂ擾
bool MouseDX8::IsWheelDown() const
{
	// MEMO:zC[̓͗ʂlĂȂtruełB

	const l32& kRWheel = GetWheel();

	bool isWheelDown = (kRWheel <= -stKWheelBorderValue);

	return isWheelDown;
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// ԂLǂ
bool MouseDX8::IsEnable(const c8& kRButton) const
{
	return (0 < (kRButton & 0x80));
}

/// Ԃǂ
bool MouseDX8::IsDisable(const c8& kRButton) const
{
	return !IsEnable(kRButton);
}

/// {^̍XV
void MouseDX8::UpdateMouseStates(const float& kRDelta)
{
	DIMOUSESTATE2& rCurrentMS = mMouseStatus[eMOUSE_STATE_CURRENT];

	// ̃}EX̏ԂOɈڂ
	mMouseStatus[eMOUSE_STATE_OLD] = rCurrentMS;

	// }EX̏Ԃ擾
	mPDevice->GetInputDevice()->GetDeviceState(sizeof(DIMOUSESTATE2), (LPVOID)&rCurrentMS);

	// {^̐Ń[v
	for (int i = 0; i < stKMouseButtonCount; ++i)
	{
		const DIMOUSESTATE2& kRMouseState = rCurrentMS;
		SButtonState& rSBS = mMouseButtonStatus[i];

		// {^̏ԂLȂ
		if (IsEnable(kRMouseState.rgbButtons[i]))
		{
			rSBS.UpdateEnable(kRDelta);
		}
		// {^̏ԂȂ
		else
		{
			rSBS.UpdateDisable(kRDelta);
		}
	}

	// W
	POINT pos;
	GetCursorPos(&pos);
	mPositionX = pos.x;
	mPositionY = pos.y;
}