#include "Blast/Graphic/DirectX9/MeshXDX9.h"

#include "Blast/Storage/Directory.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Storage;
using namespace Blast::String;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MeshXDX9::MeshXDX9() :
mSMaterials(NULL),
mMaterialCount(0)
{
}

/// fXgN^
MeshXDX9::~MeshXDX9()
{
	SAFE_DELETE_ARRAY(mSMaterials);
}


/// `
void MeshXDX9::Render()
{
	// foCXQ
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();


	/// MEMO:bV̂ł͂ȂƎv̂CO
	//// [h}gbNXݒ
	//D3DXMATRIX worldMatDX;
	//MathHelperDX::ToD3DXMATRIX(mWorld, &worldMatDX);

	//pDevice->SetTransform(D3DTS_WORLD, &worldMatDX);


	/// MEMO:bV̂ł͂ȂƎv̂CO
	//// r[}gbNXݒ
	//D3DXMATRIX viewMatDX;
	//MathHelperDX::ToD3DXMATRIX(mView, &viewMatDX);
	//
	//pDevice->SetTransform(D3DTS_VIEW, &viewMatDX);


	/// MEMO:bV̂ł͂ȂƎv̂CO
	//// vWFNV}gbNXݒ
	//D3DXMATRIX projMatDX;
	//MathHelperDX::ToD3DXMATRIX(mProjection, &projMatDX);

	//pDevice->SetTransform(D3DTS_PROJECTION, &projMatDX);
	

	// At@uh𖳌
	pDevice->SetRenderState(D3DRS_ALPHATESTENABLE, FALSE);
	pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);

	// Zobt@L
	pDevice->SetRenderState(D3DRS_ZENABLE, TRUE);
	pDevice->SetRenderState(D3DRS_ZWRITEENABLE, TRUE);

	// Cg𖳌
	pDevice->SetRenderState(D3DRS_LIGHTING, FALSE);

	// ArGgCgݒ
	pDevice->SetRenderState(D3DRS_AMBIENT, 0xff111111);

	// XyLL
	pDevice->SetRenderState(D3DRS_SPECULARENABLE, FALSE);

	// JOݒ
	pDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);


	// MEMO:Ă`悳܂Aʂ̃IuWFNg̕`Őݒ肪ύXĂƐ\Ȃ\łB
	//// eNX`Xe[WXe[gݒ
	//pDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
	//pDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
	//pDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
	//pDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_PASSTHRU);


	// }eA̐Ń[v
	for (UInt32 i = 0; i < mMaterialCount; ++i)
	{
		// }eAQ
		SMaterial& rSMaterial = mSMaterials[i];


		// }eAݒ
		pDevice->SetMaterial(&rSMaterial.mSMaterial9);


		//// ArGgCgݒ
		//DWORD ambient = 0x00111111;
		//pDevice->SetRenderState(D3DRS_AMBIENT, ambient);


		// eNX`ݒ
		CSP<IDirect3DTexture9>& pTexture = rSMaterial.mPTexture;
		pDevice->SetTexture(0, pTexture.GetInterface());


		// bṼTuZbg`
		mPMesh->DrawSubset(i);
	}
}


/// ǂݍ
bool MeshXDX9::Load(const TCHAR* kPFullPath)
{
	// ^C}[쐬
	Timer loadTimer;
	loadTimer.Start(_T("Load"));


	// foCXQ
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();


	// ΃pX擾
	tstring absFullPath = Directory::ToAbsolutePath(kPFullPath);

	// fBNgpX擾
	tstring absDirPathStr = Directory::GetDirectoryPath(absFullPath.c_str());


	// JgfBNgݒ
	Directory::SetCurrentDirectoryPath(absDirPathStr.c_str());
	{
		// P[ݒ
		StringHelper::SetLocaleJapan();


		// }eAobt@p
		ID3DXBuffer* pMaterialBuffer;

		// ǂݍ
		HRESULT hr = D3DXLoadMeshFromX(
			absFullPath.c_str(),
			D3DXMESH_SYSTEMMEM,
			pDevice,
			NULL,
			&pMaterialBuffer,
			NULL,
			&mMaterialCount,
			mPMesh.ToCreator()
			);

		// ASSERT:ǂݍ݂ɎsȂ玀
		ASSERT_PRINTF(SUCCEEDED(hr), _T("Xt@C̓ǂݍ݂Ɏs܂B"));


		// }eAz쐬
		SAFE_DELETE_ARRAY(mSMaterials);
		mSMaterials = NEW SMaterial[mMaterialCount];

		// obt@}eAzɃLXg
		D3DXMATERIAL* pD3DXMaterials = static_cast<D3DXMATERIAL*>(pMaterialBuffer->GetBufferPointer());

		// }eA̐Ń[v
		for (int i = 0; i < static_cast<int>(mMaterialCount); ++i)
		{
			// Q
			SMaterial& rSMaterial = mSMaterials[i];

			// }eAݒ
			rSMaterial.mSMaterial9 = pD3DXMaterials[i].MatD3D;
			

			// ɊgUˌ
			rSMaterial.mSMaterial9.Ambient = rSMaterial.mSMaterial9.Diffuse;


		#ifdef UNICODE
			// }`oCgChɕϊ
			WCHAR relTextureFileName[StringHelper::mStKDefaultBufferSize];
			ZeroMemory(relTextureFileName, StringHelper::mStKDefaultBufferSize);

			// eNX`pXȂ
			if (pD3DXMaterials[i].pTextureFilename != NULL)
			{
				StringHelper::ToWideChar(relTextureFileName, StringHelper::mStKDefaultBufferSize, pD3DXMaterials[i].pTextureFilename);
			}
		#else
			// eNX`pX擾
			CHAR textureFileName[StringHelper::mStKDefaultBufferSize];
			memcpy(textureFileName, StringHelper::mStKDefaultBufferSize, kRMaterial.pTextureFilename);
		#endif // UNICODE


			// eNX`̃pXȂ
			if (relTextureFileName != NULL &&
				0 < _tcslen(relTextureFileName))
			{
				// MEMO:Xt@C̃eNX`pX͑΃pXłB
				// ΃eNX`pX擾
				const tstring kAbsTexturePathStr = Directory::ToAbsolutePath(relTextureFileName);

				// eNX`쐬
				HRESULT hr = D3DXCreateTextureFromFile(
					pDevice,
					kAbsTexturePathStr.c_str(),
					rSMaterial.mPTexture.ToCreator());

				// eNX`̍쐬ɎsȂ
				WARNING(SUCCEEDED(hr), _T("eNX`̓ǂݍ݂Ɏs܂B\n΃pX=%s\n΃pX=%s"), relTextureFileName, kAbsTexturePathStr.c_str());
			}
		}

		// }eAobt@
		SAFE_RELEASE(pMaterialBuffer);
	}
	// JgfBNgZbg
	Directory::ResetCurrentDirectoryAbsolutePath();


	// ^C}[I
	loadTimer.End();
	loadTimer.OutputResult();


	return true;
}