#include "Blast/Graphic/DirectX9/MeshSpriteDX9.h"

#include "Blast/Graphic/VertexStreamType.h"
#include "Blast/Graphic/VertexElementType.h"
#include "Blast/Graphic/DirectX9/VertexElementFactoryDX9.h"

using namespace Blast::Graphic;
using namespace Blast::Base;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MeshSpriteDX9::MeshSpriteDX9(float width, float height)
{
	/* ʒuW */

	// n[tTCY

	// Zl͌Œ
	const float kZBuffer = 0.0f;


	// MEMO:XN[Wzׁ̈AY\ߔ]ĂB
	// _̈ʒupӁB
	// bV̒S[|CgzB
	const float kHalfWidth = width * 0.5f;
	const float kHalfHeight = height * 0.5f;
	const int kVertexCount = 4;
	VertexBufferDX9::SPosition sVertices[kVertexCount] =
	{
		{ -kHalfWidth,	-kHalfHeight,	kZBuffer }, // 
		{ kHalfWidth,	-kHalfHeight,	kZBuffer }, // E
		{ -kHalfWidth,	kHalfHeight,	kZBuffer }, // 
		{ kHalfWidth,	kHalfHeight,	kZBuffer }, // E
	};

	// MEMO:z̐ł͂܂BoCgłB
	// _̈ʒũTCY擾
	int vertexPositionSize = sizeof(VertexBufferDX9::SPosition) * kVertexCount;

	// _ʒũobt@쐬
	mPVertexBuffers[eVERTEXBUFFER_POSITION].SetPointer(NEW VertexBufferDX9());
	mPVertexBuffers[eVERTEXBUFFER_POSITION]->SetVertices(sVertices, kVertexCount, vertexPositionSize);


	/* F */

	// _̐Fp
	VertexBufferDX9::SColor sVertexColors[] =
	{
		ColorCode::ToCode(ColorCode::eCOLOR_WHITE),
		ColorCode::ToCode(ColorCode::eCOLOR_WHITE),
		ColorCode::ToCode(ColorCode::eCOLOR_WHITE),
		ColorCode::ToCode(ColorCode::eCOLOR_WHITE),
	};

	// _̐F̃TCY擾
	int vertexColorSize = sizeof(VertexBufferDX9::SColor) * kVertexCount;

	// _J[̃obt@쐬
	mPVertexBuffers[eVERTEXBUFFER_COLOR].SetPointer(NEW VertexBufferDX9());
	mPVertexBuffers[eVERTEXBUFFER_COLOR]->SetVertices(sVertexColors, kVertexCount, vertexColorSize);


	/* UV */

	// _UVp
	const int kUVCount = 4;
	VertexBufferDX9::SUV sVertexUVs[kUVCount] =
	{
		{ 0.0f, 0.0f },
		{ 1.0f, 0.0f },
		{ 0.0f, 1.0f },
		{ 1.0f, 1.0f },
	};

	// _UṼTCY擾
	int vertexUVSize = sizeof(VertexBufferDX9::SUV) * kVertexCount;

	// _UṼobt@쐬
	mPVertexBuffers[eVERTEXBUFFER_UV].SetPointer(NEW VertexBufferDX9());
	mPVertexBuffers[eVERTEXBUFFER_UV]->SetVertices(sVertexUVs, kVertexCount, vertexUVSize);


	/* _錾 */

	// _Hp
	VertexElementFactoryDX9 eElementFactory;

	// _쐬
	D3DVERTEXELEMENT9 sElements[] =
	{
		eElementFactory.CreateElement(VertexElementType::eELEMENT_POSITION),
		eElementFactory.CreateElement(VertexElementType::eELEMENT_COLOR),
		eElementFactory.CreateElement(VertexElementType::eELEMENT_UV),
		eElementFactory.CreateElement(VertexElementType::eELEMENT_END),
	};

	// _錾쐬
	mPVertexDeclaration.SetPointer(NEW VertexDeclarationDX9());
	mPVertexDeclaration->CreateDeclaration(sElements);


	/* CfbNX */

	// CfbNXz쐬
	const int kIndexCount = 4;
	int indices[kIndexCount] = 
	{
		0, 1, 2, 3
	};

	// CfbNXobt@쐬
	mPIndexBuffer.SetPointer(NEW IndexBufferDX9());
	mPIndexBuffer->SetIndices(indices, kIndexCount);
}

/// fXgN^
MeshSpriteDX9::~MeshSpriteDX9()
{
}


/// `
void MeshSpriteDX9::Render()
{
	// foCX擾
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();

	// o[ebNXXg[ݒ
	pDevice->SetStreamSource(VertexStreamType::eSTREAM_POSITION, mPVertexBuffers[eVERTEXBUFFER_POSITION]->GetBuffer(), 0, mPVertexBuffers[eVERTEXBUFFER_POSITION]->GetStride());
	pDevice->SetStreamSource(VertexStreamType::eSTREAM_COLOR, mPVertexBuffers[eVERTEXBUFFER_COLOR]->GetBuffer(), 0, mPVertexBuffers[eVERTEXBUFFER_COLOR]->GetStride());
	pDevice->SetStreamSource(VertexStreamType::eSTREAM_UV, mPVertexBuffers[eVERTEXBUFFER_UV]->GetBuffer(), 0, mPVertexBuffers[eVERTEXBUFFER_UV]->GetStride());

	// _錾ݒ
	pDevice->SetVertexDeclaration(mPVertexDeclaration->GetDeclaration());

	// CfbNXobt@ݒ
	pDevice->SetIndices(mPIndexBuffer->GetBuffer());


	// _擾
	const u32 kVertexCount = mPVertexBuffers[eVERTEXBUFFER_POSITION]->GetVertexCount();

	// v~eBu擾
	//const u32 kPrimitiveCount = mPIndexBuffer->GetPrimitiveCount();
	const u32 kPrimitiveCount = 2;

	// `
	HRESULT hr = pDevice->DrawIndexedPrimitive(
		D3DPT_TRIANGLESTRIP,
		0,
		0,
		kVertexCount,
		0,
		kPrimitiveCount
		);
}