#include "Blast/Graphic/DirectX9/MeshPlaneDX9.h"

#include "Blast/Graphic/DirectX9/VertexElementFactoryDX9.h"
#include "Blast/Graphic/VertexStreamType.h"

using namespace Blast::Graphic;
using namespace Blast::Base;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MeshPlaneDX9::MeshPlaneDX9() { }

/// fXgN^
MeshPlaneDX9::~MeshPlaneDX9() { }


/// `
void MeshPlaneDX9::Render()
{
	// foCX擾
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();
	

	// o[ebNXXg[ݒ
	pDevice->SetStreamSource(VertexStreamType::eSTREAM_POSITION, mPVertexBuffers[eVERTEX_BUFFER_POSITION]->GetBuffer(), 0, mPVertexBuffers[eVERTEX_BUFFER_POSITION]->GetStride());
	pDevice->SetStreamSource(VertexStreamType::eSTREAM_COLOR, mPVertexBuffers[eVERTEX_BUFFER_COLOR]->GetBuffer(), 0, mPVertexBuffers[eVERTEX_BUFFER_COLOR]->GetStride());
	pDevice->SetStreamSource(VertexStreamType::eSTREAM_NORMAL, mPVertexBuffers[eVERTEX_BUFFER_NORMAL]->GetBuffer(), 0, mPVertexBuffers[eVERTEX_BUFFER_NORMAL]->GetStride());

	// _`ݒ
	pDevice->SetVertexDeclaration(mPVertexDeclaration->GetDeclaration());

	// CfbNXobt@ݒ
	pDevice->SetIndices(mPIndexBuffer->GetBuffer());


	// _擾
	u32 vertexCount = mPVertexBuffers[eVERTEX_BUFFER_POSITION]->GetVertexCount();

	// v~eBu擾
	u32 primitiveCount = mPIndexBuffer->GetPrimitiveCount();


	// `
	HRESULT hr = pDevice->DrawIndexedPrimitive(
		D3DPT_TRIANGLELIST,
		0,
		0,
		vertexCount,
		0,
		primitiveCount
		);
}


/// bV쐬
void MeshPlaneDX9::CreateMesh(float width, float height, unsigned rowCount, unsigned columnCount)
{
	// foCX擾
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();


	// ƕ1񕪂̕Zo
	const float kOneWidth = width / columnCount;

	// cƕ1s̕Zo
	const float kOneHeight = height / rowCount;


	/* ʒu */

	// ʒuێϔz
	std::vector<VertexBufferDX9::SPosition> sPositions;

	// MEMO:A؎Ẑ߁A+1܂B
	// s̐Ń[v
	for (unsigned i = 0; i < rowCount + 1; ++i)
	{
		// MEMO:A؎Ẑ߁A+1܂B
		// ̐Ń[v
		for (unsigned j = 0; j < columnCount + 1; ++j)
		{
			// ̔̒l
			float halfWidth = width * 0.5f;

			// c̔̒l
			float halfHeight = height * 0.5f;

			// W
			float x = kOneWidth * j - halfWidth;
			float y = halfHeight - kOneHeight * i;
			const float kZ = 0;

			// ʒu
			VertexBufferDX9::SPosition sPosition;
			sPosition.mX = x;
			sPosition.mY= y;
			sPosition.mZ = kZ;

			// zɒǉ
			sPositions.push_back(sPosition);
		}
	}

	// ʒũo[ebNXobt@쐬
	mPVertexBuffers[eVERTEX_BUFFER_POSITION].SetPointer(NEW VertexBufferDX9());
	mPVertexBuffers[eVERTEX_BUFFER_POSITION]->SetVertices(
		&sPositions.front(),
		sPositions.size(),
		sizeof(VertexBufferDX9::SPosition) * sPositions.size());


	/* F */

	// F̔z쐬
	std::vector<VertexBufferDX9::SColor> sColors;
	for (unsigned i = 0; i < sPositions.size(); ++i)
	{
		VertexBufferDX9::SColor sColor;
		sColor.mColor = 0xffffffff;

		sColors.push_back(sColor);
	}

	// F̒_obt@쐬
	mPVertexBuffers[eVERTEX_BUFFER_COLOR].SetPointer(NEW VertexBufferDX9());
	mPVertexBuffers[eVERTEX_BUFFER_COLOR]->SetVertices(&sColors.front(), sColors.size(), sizeof(VertexBufferDX9::SColor) * sColors.size());


	/* @ */

	// @̔z쐬
	std::vector<VertexBufferDX9::SNormal> sNormals;
	for (unsigned i = 0; i < sPositions.size(); ++i)
	{
		// MEMO:͕KPZ-łB
		VertexBufferDX9::SNormal sNormal;
		sNormal.mX = 0;
		sNormal.mY = 0;
		sNormal.mZ = -1;

		sNormals.push_back(sNormal);
	}

	mPVertexBuffers[eVERTEX_BUFFER_NORMAL].SetPointer(NEW VertexBufferDX9());

	// @̃o[ebNXobt@쐬
	unsigned sNormalsSize = sizeof(VertexBufferDX9::SNormal) * sNormals.size();
	mPVertexBuffers[eVERTEX_BUFFER_NORMAL]->SetVertices(&sNormals.front(), sNormals.size(), sNormalsSize);


	/* CfbNX */

	// MEMO:
	//  1  2  3  4  5
	//  6  7  8  9 10
	// 11 12 13 14 15
	// {1,2,3},{2,3,7},{3,4,8}, ...
	// {6,2,7},{7,3,8},{8,4,9}, ...

	// CfbNXێϔz
	std::vector<int> indices;

	// MEMO:A؎Ẑ߁A+1܂B
	// s̐Ń[v
	for (unsigned i = 0; i < rowCount + 1; ++i)
	{
		// ̐Ń[v
		for (unsigned j = 0; j < columnCount; ++j)
		{
			unsigned base = j + i * (columnCount + 1);

			// Ō̍sŖȂ
			if (i != rowCount)
			{
				unsigned i0 = base + 0;
				unsigned i1 = base + 1;
				unsigned i2 = base + (columnCount + 1);

				indices.push_back(i0);
				indices.push_back(i1);
				indices.push_back(i2);
			}

			// ŏ̍sŖȂ
			if (i != 0)
			{
				unsigned i0 = base + 0;
				unsigned i1 = base + 1 - (columnCount + 1);
				unsigned i2 = base + 1;

				indices.push_back(i0);
				indices.push_back(i1);
				indices.push_back(i2);
			}
		}
	}

	// CfbNXobt@쐬
	mPIndexBuffer.SetPointer(NEW IndexBufferDX9());
	mPIndexBuffer->SetIndices(&indices.front(), indices.size());


	/* _` */

	// o[ebNXfN[V쐬
	VertexElementFactoryDX9 elementFactory;
	const D3DVERTEXELEMENT9 elements[] =
	{
		elementFactory.CreateElement(VertexElementType::eELEMENT_POSITION),
		elementFactory.CreateElement(VertexElementType::eELEMENT_COLOR),
		elementFactory.CreateElement(VertexElementType::eELEMENT_NORMAL),
		elementFactory.CreateElement(VertexElementType::eELEMENT_END),
	};

	mPVertexDeclaration.SetPointer(NEW VertexDeclarationDX9());
	mPVertexDeclaration->CreateDeclaration(elements);
}