#include "Blast/Graphic/DirectX9/MeshObjDX9.h"

#include "Blast/IO/File.h"
#include "Blast/Storage/Directory.h"
#include "Blast/Graphic/VertexStreamType.h"
#include "Blast/Graphic/DirectX9/VertexElementFactoryDX9.h"
#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Storage;
using namespace Blast::String;
using namespace Blast::Math;
using namespace Blast::IO;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// L[Q
const TCHAR* const MeshObjDX9::mStKPKeyStrings[eKEY_STRING_COUNT] =
{
	_T("#"),		// Rg
	_T("v"),		// _ʒu
	_T("vt"),		// UVW
	_T("vn"),		// @
	_T("f"),		// tFCX
	_T("mtllib"),	// }eAt@C
	_T("usemtl"),	// gp}eA
	_T("newmtl"),	// }eA
	_T("Ka"),		// ArGg
	_T("Kd"),		// fBt[Y
	_T("Ks"),		// XyL
	_T("Ns"),		// VClX
	_T("map_Kd"),	// fBt[Y}bv
};


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MeshObjDX9::MeshObjDX9()
{
	// o[ebNXobt@̐Ń[v
	for (int i = 0; i < eVERTEXBUFFER_COUNT; ++i)
	{
		// o[ebNXobt@쐬
		mPVertexBuffers[i].SetPointer(NEW VertexBufferDX9());
	}


	// _`쐬
	mPVertexDeclaration.SetPointer(NEW VertexDeclarationDX9());


	/// MEMO:bV̂ł͂ȂƎv̂CO
	//// eNjbNݒ
	//mPShaderEffect->SetTechnique(ShaderEffectDX9::eTECHNIQUE_PHONG);
}

/// fXgN^
MeshObjDX9::~MeshObjDX9()
{
}


/// `
void MeshObjDX9::Render()
{
	// ̕`揈
	MeshDX9::Render();


	// foCX擾
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();
	
	// o[ebNẌʒuXg[ݒ
	SP<VertexBufferDX9> pPositionBuffer = mPVertexBuffers[eVERTEXBUFFER_POSITION];
	pDevice->SetStreamSource(VertexStreamType::eSTREAM_POSITION, pPositionBuffer->GetBuffer(), 0, pPositionBuffer->GetStride());

	// o[ebNXUVXg[ݒ
	SP<VertexBufferDX9> pUVBuffer = mPVertexBuffers[eVERTEXBUFFER_UV];
	pDevice->SetStreamSource(VertexStreamType::eSTREAM_UV, pUVBuffer->GetBuffer(), 0, pUVBuffer->GetStride());

	// o[ebNX̖@Xg[ݒ
	SP<VertexBufferDX9> pNormalBuffer = mPVertexBuffers[eVERTEXBUFFER_NORMAL];
	pDevice->SetStreamSource(VertexStreamType::eSTREAM_NORMAL, pNormalBuffer->GetBuffer(), 0, pNormalBuffer->GetStride());


	// _錾ݒ
	pDevice->SetVertexDeclaration(mPVertexDeclaration->GetDeclaration());


	// _擾
	const UInt32 kVertexCount = pPositionBuffer->GetVertexCount();


	// }eA̐Ń[v
	for (unsigned i = 0; i < mSMaterials.size(); ++i)
	{
		// }eAQ
		SMaterial& rSMaterial = mSMaterials.at(i);


		// v~eBu0Ȃ
		if (rSMaterial.mPrimitiveCount == 0)
		{
			continue;
		}


		/// MEMO:bV̂ł͂ȂƎv̂CO
		//// ArGgݒ
		//mPShaderEffect->SetFloatArray(ShaderEffectDX9::eVARIABLE_AMBIENT_COLOR, rSMaterial.mAmbient.GetArray(), 3);

		//// fBt[Yݒ
		//mPShaderEffect->SetFloatArray(ShaderEffectDX9::eVARIABLE_DIFFUSE, rSMaterial.mDiffuse.GetArray(), 3);

		/// MEMO:bV̂ł͂ȂƎv̂CO
		//// XyLݒ
		//mPShaderEffect->SetFloatArray(ShaderEffectDX9::eVARIABLE_SPECULAR, rSMaterial.mSpecular.GetArray(), 3);

		//// ݒ
		//mPShaderEffect->SetValue(ShaderEffectDX9::eVARIABLE_SHININESS, &rSMaterial.mShininess, sizeof(float));


		/// MEMO:bV̂ł͂ȂƎv̂CO
		//// fBt[YeNX`Ȃ
		//if (rSMaterial.mPDiffuseTexture)
		//{
		//	// Texture2DDX9ɃLXg
		//	Texture2DDX9* pTexture = dynamic_cast<Texture2DDX9*>(rSMaterial.mPDiffuseTexture.GetSource());

		//	// LXgɐȂ
		//	if (pTexture)
		//	{
		//		// VF[_[ɃfBt[YeNX`ݒ
		//		mPShaderEffect->SetTexture(ShaderEffectDX9::eVARIABLE_DIFFUSE_TEXTURE, pTexture->GetTexturePtrRef().GetInterface());
		//	}
		//}

		//// fBt[YeNX`̎gptOݒ
		//bool isDiffuseTexture = true;
		//mPShaderEffect->SetBool(ShaderEffectDX9::eVARIABLE_USE_DIFFUSE_TEXTURE, isDiffuseTexture);


		// CfbNXobt@Q
		SP<IndexBufferDX9> pInexBuffer = mPIndexBuffers.at(i);

		// CfbNXobt@ݒ
		pDevice->SetIndices(pInexBuffer->GetBuffer());


		// MEMO:}eAǂł傤B
		// v~eBu擾
		const UInt32 kPrimitiveCount = pInexBuffer->GetPrimitiveCount();


		///// MEMO:bV̂ł͂ȂƎv̂CO
		//// `Jn
		//unsigned passCount = -1;
		//mPShaderEffect->Begin(&passCount);
		//{
		//	// pX̐Ń[v
		//	for (unsigned j = 0 ; j < passCount; ++j)
		//	{
		//		// pXJn
		//		mPShaderEffect->BeginPass(j);
		//		{
		//			// `
		//			HRESULT hr = pDevice->DrawIndexedPrimitive(
		//				D3DPT_TRIANGLELIST,
		//				0,
		//				0,
		//				kVertexCount,
		//				0,
		//				kPrimitiveCount
		//				);

		//			// ASSERT:`ɎsȂ玀B
		//			ASSERT_PRINTF(SUCCEEDED(hr), _T("`Ɏs܂B"));
		//		}
		//		mPShaderEffect->EndPass();
		//	}
		//}
		//mPShaderEffect->End();
	}
}


/// bVǂݍ
bool MeshObjDX9::Load(const TCHAR* kPFullPath)
{
	// ^C}[쐬
	Timer loadMeshTimer;
	loadMeshTimer.Start(_T("Load"));


	// ΃tpX擾
	TCHAR absFullPath[Directory::mStKMaxPath];
	Directory::ToAbsolutePath(kPFullPath, absFullPath);


	// t@CWJ
	File file;
	bool isSucceess = file.Open(absFullPath);

	// ASSERT:t@Cǂݍ߂ȂȂ玀B
	ASSERT_PRINTF(isSucceess, _T("t@Cǂݍ߂܂łB\npX=%s"), kPFullPath);


	// t@CJƂɐȂ
	if (isSucceess)
	{
		// 1s̕obt@
		const int kLineBufferCount = 1024 * 4;
		TCHAR lineBuffer[kLineBufferCount];
		ZeroMemory(lineBuffer, sizeof(lineBuffer));

		// ̃obt@
		const int kSplitBufferCount = 1024;
		TCHAR* splitBuffers[kSplitBufferCount];
		ZeroMemory(splitBuffers, sizeof(splitBuffers));


		// MEMO:zCgXy[XƉsR[hłB
		// ̃f~^
		const TCHAR* kDelimiter = _T(" \n");


		// QƗpʒu̐
		int refPositionCount = 0;

		// UVW̐
		int refUVCount = 0;

		// @̐
		int refNormalCount = 0;

		// tFCX̐
		int refFaceCount = 0;

		// EOF܂Ń[v
		while (!file.IsEOF())
		{
			// 1sǂݍ
			ZeroMemory(lineBuffer, sizeof(lineBuffer));
			file.ReadLine(lineBuffer, kLineBufferCount);

			// 
			int splitCount = 0;
			StringHelper::Split(lineBuffer, kDelimiter, splitBuffers, &splitCount);


			// MEMO:ŝݏ܂B
			// 0ȏȂ
			if (0 < splitCount)
			{
				// s̕擾
				const TCHAR* kPHeadToken = splitBuffers[0];
				

				// Pꕶ񂪈ʒũL[Ȃ
				if (_tcscmp(kPHeadToken, mStKPKeyStrings[eKEY_STRING_POSITION]) == 0)
				{
					++refPositionCount;
				}
				// PꕶUṼL[Ȃ
				else if (_tcscmp(kPHeadToken, mStKPKeyStrings[eKEY_STRING_UV]) == 0)
				{
					++refUVCount;
				}
				// Pꕶ񂪖@̃L[Ȃ
				else if (_tcscmp(kPHeadToken, mStKPKeyStrings[eKEY_STRING_NORMAL]) == 0)
				{
					++refNormalCount;
				}
				// Pꕶ񂪃tFCX̕Ȃ
				else if (_tcscmp(kPHeadToken, mStKPKeyStrings[eKEY_STRING_FACE]) == 0)
				{
					++refFaceCount;
				}
			}
		}


		// MEMO:Op`|SƂƂMĂ܂Aǂł傤B
		// 1|S̒_
		const int kFacePointCount = 3;

		// MEMO:SĂ̒_ʁXɍ쐬̂͏璷łAm܂B
		// _
		const int kVertexCount = refFaceCount * kFacePointCount;

		
		// QƗp̈ʒuێz𓮓Im
		SP<VertexBufferDX9::SPosition> pSRefPositions(NEW VertexBufferDX9::SPosition[refPositionCount], true);

		// QƗp̈ʒu̔zCfbNX
		int refPositionIndex = 0;


		// QƗpUVWێz𓮓Im
		SP<VertexBufferDX9::SUV> pSRefUVs(NEW VertexBufferDX9::SUV[refUVCount], true);

		// QƗpUVW̔zCfbNX
		int refUVIndex = 0;


		// QƗp̖@ێz𓮓Im
		SP<VertexBufferDX9::SNormal> pSRefNormals(NEW VertexBufferDX9::SNormal[refNormalCount], true);

		// QƗp̖@̔zCfbNX
		int refNormalIndex = 0;


		// V[Nʒu擪ɐݒ
		file.SeekStart();

		// EOF܂Ń[v
		while (!file.IsEOF())
		{
			// 1sǂݍ
			ZeroMemory(lineBuffer, sizeof(lineBuffer));
			file.ReadLine(lineBuffer, kLineBufferCount);


			// 
			int splitCount = 0;
			StringHelper::Split(lineBuffer, kDelimiter, splitBuffers, &splitCount);

			// 0Ȃ
			if (splitCount == 0)
			{
				continue;
			}


			// s̕擾
			const TCHAR* kPHeadToken = splitBuffers[0];

			// Rg\L[Ȃ
			if (_tcscmp(kPHeadToken, mStKPKeyStrings[eKEY_STRING_COMMENT]) == 0)
			{
				continue;
			}
			// _ʒũL[Ȃ
			else if (_tcscmp(kPHeadToken, mStKPKeyStrings[eKEY_STRING_POSITION]) == 0)
			{
				// Q
				VertexBufferDX9::SPosition& rSPos = pSRefPositions[refPositionIndex];

				_stscanf_s(splitBuffers[1], _T("%f"), &rSPos.mX);
				_stscanf_s(splitBuffers[2], _T("%f"), &rSPos.mY);
				_stscanf_s(splitBuffers[3], _T("%f"), &rSPos.mZ);

				// MEMO:OBJt@C͉EWnȂ̂XW]܂B
				// MEMO:Wnŕ`悳悤Ƀf[^o͑HvׂłB
				rSPos.mX *= -1;


				// CfbNXZ
				++refPositionIndex;
			}
			// UṼL[Ȃ
			else if (_tcscmp(kPHeadToken, mStKPKeyStrings[eKEY_STRING_UV]) == 0)
			{
				// Q
				VertexBufferDX9::SUV& rSUV = pSRefUVs[refUVIndex];

				_stscanf_s(splitBuffers[1], _T("%f"), &rSUV.mU);
				_stscanf_s(splitBuffers[2], _T("%f"), &rSUV.mV);

				// MEMO:OBJt@CYtȂ̂ő܂B
				// MEMO:肭`悳ȂꍇAf[^o͑HvׂłB
				// MEMO:
				rSUV.mV = 1 - rSUV.mV;


				// CfbNXZ
				++refUVIndex;
			}
			// @̃L[Ȃ
			else if (_tcscmp(kPHeadToken, mStKPKeyStrings[eKEY_STRING_NORMAL]) == 0)
			{
				// @
				VertexBufferDX9::SNormal& rSNormal = pSRefNormals[refNormalIndex];

				_stscanf_s(splitBuffers[1], _T("%f"), &rSNormal.mX);
				_stscanf_s(splitBuffers[2], _T("%f"), &rSNormal.mY);
				_stscanf_s(splitBuffers[3], _T("%f"), &rSNormal.mZ);

				// MEMO:ʒuɑĖ@XW𔽓]Kv悤łB
				rSNormal.mX *= -1;


				// CfbNXZ
				++refNormalIndex;
			}
			// }eAt@C̃L[Ȃ
			else if (_tcscmp(kPHeadToken, mStKPKeyStrings[eKEY_STRING_MATERIAL_FILENAME]) == 0)
			{
				// }eÃt@C擾
				TCHAR materialFileName[Directory::mStKMaxFileName];
				ZeroMemory(materialFileName, sizeof(materialFileName));

				memcpy(materialFileName, splitBuffers[1], sizeof(materialFileName));
				//_stscanf_s(splitBuffers[1], _T("%s"), materialFileName);


				// }eAt@CpX쐬
				TCHAR absMaterialFileFullPath[Directory::mStKMaxPath];
				ZeroMemory(absMaterialFileFullPath, sizeof(absMaterialFileFullPath));

				Directory::GetDirectoryPath(absFullPath, absMaterialFileFullPath);

				// fBNgƃt@CA
				_tcscat_s(absMaterialFileFullPath, Directory::mStKMaxPath, materialFileName);


				// }eAǂݍ
				LoadMaterial(absMaterialFileFullPath);
			}
		}


		// ʒu̔z𓮓Im
		SP<VertexBufferDX9::SPosition> pSPositions(NEW VertexBufferDX9::SPosition[kVertexCount], true);

		// UVWێz
		SP<VertexBufferDX9::SUV> pSUVs(NEW VertexBufferDX9::SUV[kVertexCount], true);

		// @Wێz
		SP<VertexBufferDX9::SNormal> pSNormals(NEW VertexBufferDX9::SNormal[kVertexCount], true);


		// v~eBu
		unsigned totalPrimitiveCount = 0;

		// CfbNXێϔz
		std::vector<int> indices;
		indices.reserve(kVertexCount * kFacePointCount);

		// }eA̐Ń[v
		for (unsigned i = 0; i < mSMaterials.size(); ++i)
		{
			// }eAQ
			SMaterial& rSMaterial = mSMaterials.at(i);


			// CfbNXێϔzNA
			indices.clear();

			// }eAvĂtFCXǂ
			bool isMatchFace = false;


			// gp}eA\L[
			const TCHAR* mStKPUseMaterialNameKey = _T("usemtl");


			// V[Nʒu擪ɐݒ
			file.SeekStart();

			// EOF܂Ń[v
			while (!file.IsEOF())
			{
				// Pꕶǂݍ
				ZeroMemory(lineBuffer, sizeof(lineBuffer));
				file.ReadFormat(_T("%s "), lineBuffer, &kLineBufferCount);


				// Pꕶ񂪎gp}eÃL[Ȃ
				if (_tcscmp(lineBuffer, mStKPUseMaterialNameKey) == 0)
				{
					// Pꕶǂݍ
					ZeroMemory(lineBuffer, sizeof(lineBuffer));
					file.ReadFormat(_T("%s "), lineBuffer, &kLineBufferCount);
					

					// }eAvȂ
					if (rSMaterial.mNameStr == lineBuffer)
					{
						isMatchFace = true;
					}
					// }eAvȂȂ
					else
					{
						isMatchFace = false;
					}
				}
				// }eAƈvĂtFCXłA
				// Pꕶ񂪃tFCX̃L[Ȃ
				else if (isMatchFace &&
					_tcscmp(lineBuffer, mStKPKeyStrings[eKEY_STRING_FACE]) == 0)
				{
					// CfbNX
					int tIndices[kFacePointCount];
					ZeroMemory(tIndices, sizeof(tIndices));

					int uvIndices[kFacePointCount];
					ZeroMemory(uvIndices, sizeof(uvIndices));

					int normalIndices[kFacePointCount];
					ZeroMemory(normalIndices, sizeof(normalIndices));

					// 1|S̒_Ń[v
					for (int i = 0; i < kFacePointCount; ++i)
					{
						// CfbNX𕪊擾
						file.ReadFormat(_T("%d/"), &tIndices[i]);
						file.ReadFormat(_T("%d/"), &uvIndices[i]);
						file.ReadFormat(_T("%d "), &normalIndices[i]);
					}

					// 1|S̒_Ń[v
					for (int i = 0; i < kFacePointCount; ++i)
					{
						// CfbNXp
						int index = totalPrimitiveCount * kFacePointCount + i;

						// CfbNXǉ
						indices.push_back(index);

						// ʒu
						const VertexBufferDX9::SPosition& kRSPos = pSRefPositions[tIndices[i] - 1];
						pSPositions[index] = kRSPos;

						// MEMO:UVCfbNXŎQƂUVWA_CfbNXɂčXɎQƂ܂B
						// UVW
						const VertexBufferDX9::SUV& kRSUV = pSRefUVs[uvIndices[i] - 1];
						pSUVs[index] = kRSUV;

						// @
						const VertexBufferDX9::SNormal& kRSNormal = pSRefNormals[normalIndices[i] - 1];
						pSNormals[index] = kRSNormal;
					}


					// tFCXZ
					++totalPrimitiveCount;
					++rSMaterial.mPrimitiveCount;
				}
			}


			// CfbNXobt@쐬
			SP<IndexBufferDX9> pIB(NEW IndexBufferDX9());

			// CfbNX񂪂Ȃ
			if (!indices.empty())
			{
				// CfbNXobt@쐬
				pIB->SetIndices(&indices.front(), indices.size());
			}

			// ǉ
			mPIndexBuffers.push_back(pIB);
		}

		// t@C
		file.Close();


		// ʒu񂪂Ȃ
		if (pSPositions)
		{
			// ʒuobt@쐬
			mPVertexBuffers[eVERTEXBUFFER_POSITION]->SetVertices(pSPositions.GetSource(), kVertexCount, sizeof(VertexBufferDX9::SPosition) * kVertexCount);
		}

		// UV񂪂Ȃ
		if (pSUVs)
		{
			// UVobt@쐬
			mPVertexBuffers[eVERTEXBUFFER_UV]->SetVertices(pSUVs.GetSource(), kVertexCount, sizeof(VertexBufferDX9::SUV) * kVertexCount);
		}

		// @񂪂Ȃ
		if (pSNormals)
		{
			// @obt@쐬
			mPVertexBuffers[eVERTEXBUFFER_NORMAL]->SetVertices(pSNormals.GetSource(), kVertexCount, sizeof(VertexBufferDX9::SNormal) * kVertexCount);
		}


		// _z쐬
		VertexElementFactoryDX9 veFactory;
		const D3DVERTEXELEMENT9 elements[] =
		{
			veFactory.CreateElement(VertexElementType::eELEMENT_POSITION),
			veFactory.CreateElement(VertexElementType::eELEMENT_UV),
			veFactory.CreateElement(VertexElementType::eELEMENT_NORMAL),
			veFactory.CreateElement(VertexElementType::eELEMENT_END),
		};

		// _`쐬
		mPVertexDeclaration->CreateDeclaration(elements);
	

		// ^C}[I
		loadMeshTimer.End();
		loadMeshTimer.OutputResult();


		return true;
	}
	// t@Cǂݍ߂ȂȂ
	else
	{
		return false;
	}
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// }eAǂݍ
void MeshObjDX9::LoadMaterial(const TCHAR* kPFullPath)
{
	//kPFullPath = _T("B:\\P1\\Trunk\\Program\\Projects\\BlastLibrary\\BlastLibraryLaboratory\\Res\\Test\\Model\\Kirisame Marisa\\Obj\\Marisa_TriangleOnly_Face&VInvert.mtl");

	// t@CWJ
	FILE* pFile = NULL;
	_tfopen_s(&pFile, kPFullPath, _T("rt"));

	// ASSET:t@CWJɎsȂ玀
	ASSERT_PRINTF(pFile, _T("}eAt@C̓WJɎs܂B\n%s"), kPFullPath);


	// t@CWJɐȂ
	if (pFile)
	{
		// }eA̐
		int materialCount = 0;


		// Pǂݍރobt@
		const int kLineBufferCount = 128;
		TCHAR lineBuffer[kLineBufferCount];
		ZeroMemory(lineBuffer, sizeof(lineBuffer));


		// EOF܂Ń[v
		while (!feof(pFile))
		{
			// Pꕶǂݍ
			ZeroMemory(lineBuffer, sizeof(lineBuffer));
			_ftscanf_s(pFile, _T("%s "), lineBuffer, kLineBufferCount);

			// Pꕶ񂪃}eÃL[Ȃ
			if (_tcscmp(lineBuffer, mStKPKeyStrings[eKEY_STRING_MATERIAL_NAME]) == 0)
			{
				// Z
				++materialCount;
			}
		}

		// }eA̐0Ȃ玀
		ASSERT_PRINTF(0 < materialCount, _T("}eA񂪈܂B"));

		// }eA̐0Ȃ
		if (materialCount == 0)
		{
			return;
		}

		// }eAzm
		mSMaterials.resize(materialCount);


		// QƗp}eȂΏۃCfbNX
		int materialIndex = -1;

		// V[Nʒu擪ɐݒ
		fseek(pFile, SEEK_SET, 0);

		// EOF܂Ń[v
		while (!feof(pFile))
		{
			// Pꕶǂݍ
			ZeroMemory(lineBuffer, sizeof(lineBuffer));
			_ftscanf_s(pFile, _T("%s "), lineBuffer, kLineBufferCount);


			// Pꕶ񂪃}eÃL[Ȃ
			if (_tcscmp(lineBuffer, mStKPKeyStrings[eKEY_STRING_MATERIAL_NAME]) == 0)
			{
				// ΏۃCfbNXZ
				++materialIndex;


				// }eA擾
				const int kMaterialNameCharacterCount = 128;
				TCHAR materialName[kMaterialNameCharacterCount];
				ZeroMemory(materialName, sizeof(materialName));

				_ftscanf_s(pFile, _T("%s"), materialName, kMaterialNameCharacterCount);

				// 
				mSMaterials.at(materialIndex).mNameStr = materialName;
			}
			// Pꕶ񂪃ArGg̃L[
			else if (_tcscmp(lineBuffer, mStKPKeyStrings[eKEY_STRING_AMBIENT]) == 0)
			{
				// ASSERT:͈͊OQƂȂ玀
				ASSERT_PRINTF(materialIndex < static_cast<int>(mSMaterials.size()),
					_T("͈͊OQƂ悤ƂĂ܂BCfbNX=%d, TCY=%u"), materialIndex, mSMaterials.size());

				// Q
				SMaterial& rSMaterial = mSMaterials.at(materialIndex);

				// ێ
				_ftscanf_s(pFile, _T("%f %f %f"),
					&rSMaterial.mAmbient.mX,
					&rSMaterial.mAmbient.mY,
					&rSMaterial.mAmbient.mZ
					);
			}
			// Pꕶ񂪃fBt[ỸL[
			else if (_tcscmp(lineBuffer, mStKPKeyStrings[eKEY_STRING_DIFFUSE]) == 0)
			{
				// ASSERT:͈͊OQƂȂ玀
				ASSERT_PRINTF(materialIndex < static_cast<int>(mSMaterials.size()),
					_T("͈͊OQƂ悤ƂĂ܂BCfbNX=%d, TCY=%u"), materialIndex, mSMaterials.size());

				// Q
				SMaterial& rSMaterial = mSMaterials.at(materialIndex);

				// ێ
				_ftscanf_s(pFile, _T("%f %f %f"),
					&rSMaterial.mDiffuse.mX,
					&rSMaterial.mDiffuse.mY,
					&rSMaterial.mDiffuse.mZ
					);
			}
			// Pꕶ񂪃XyL̃L[
			else if (_tcscmp(lineBuffer, mStKPKeyStrings[eKEY_STRING_SPECULAR]) == 0)
			{
				// ASSERT:͈͊OQƂȂ玀
				ASSERT_PRINTF(materialIndex < static_cast<int>(mSMaterials.size()),
					_T("͈͊OQƂ悤ƂĂ܂BCfbNX=%d, TCY=%u"), materialIndex, mSMaterials.size());

				// Q
				SMaterial& rSMaterial = mSMaterials.at(materialIndex);

				// ێ
				_ftscanf_s(pFile, _T("%f %f %f"),
					&rSMaterial.mSpecular.mX,
					&rSMaterial.mSpecular.mY,
					&rSMaterial.mSpecular.mZ
					);
			}
			// Pꕶ񂪃VClX̃L[
			else if (_tcscmp(lineBuffer, mStKPKeyStrings[eKEY_STRING_SHININESS]) == 0)
			{
				// ASSERT:͈͊OQƂȂ玀
				ASSERT_PRINTF(materialIndex < static_cast<int>(mSMaterials.size()),
					_T("͈͊OQƂ悤ƂĂ܂BCfbNX=%d, TCY=%u"), materialIndex, mSMaterials.size());

				// Q
				SMaterial& rSMaterial = mSMaterials.at(materialIndex);

				// ێ
				_ftscanf_s(pFile, _T("%f"), &rSMaterial.mShininess);
			}
			// Pꕶ񂪃fBt[Y}bṽL[
			else if (_tcscmp(lineBuffer, mStKPKeyStrings[eKEY_STRING_DIFFUSE_TEXTURE]) == 0)
			{
				// ASSERT:͈͊OQƂȂ玀
				ASSERT_PRINTF(materialIndex < static_cast<int>(mSMaterials.size()),
					_T("͈͊OQƂ悤ƂĂ܂BCfbNX=%d, TCY=%u"), materialIndex, mSMaterials.size());

				// Q
				SMaterial& rSMaterial = mSMaterials.at(materialIndex);


				// t@C擾
				const int kDiffuseTextureFullFileNameCharacterCount = 128;
				TCHAR textureFullFileName[kDiffuseTextureFullFileNameCharacterCount];
				ZeroMemory(textureFullFileName, sizeof(textureFullFileName));

				_ftscanf_s(pFile, _T("%s"), textureFullFileName, kDiffuseTextureFullFileNameCharacterCount);


				// pX擾
				tstring directoryPathStr = Directory::GetDirectoryPath(kPFullPath);

				// eNX`pX쐬
				tstring textureFullPathStr = directoryPathStr + textureFullFileName;

				// eNX`ǂݍ
				FileTexture2DDX9* pTexture = NEW FileTexture2DDX9();
				pTexture->Load(textureFullPathStr.c_str());

				// ێ
				rSMaterial.mPDiffuseTexture.SetPointer(pTexture);
			}
		}
	}
}
