#include "Blast/Graphic/DirectX9/MeshHierarchyFbxDX9.h"

#include "Blast/String/StringHelper.h"

using namespace Blast::Graphic;
using namespace Blast::String;
using namespace Blast::Math;
using namespace fbxsdk_2012_2;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MeshHierarchyFbxDX9::MeshHierarchyFbxDX9() :
mPFbxSdkManager(NULL),
mPFbxScene(NULL),
mFrame(0)
{
	// FbxSdkManager쐬
	mPFbxSdkManager = KFbxSdkManager::Create();


	// [gbV쐬
	mPRootMesh.SetPointer(NEW MeshFbxDX9());
}

/// fXgN^
MeshHierarchyFbxDX9::~MeshHierarchyFbxDX9()
{
	// FbxSdkManagerj
	SAFE_DESTROY(mPFbxSdkManager);
}

/// `
void MeshHierarchyFbxDX9::Render()
{
	// Ϗ
	mPRootMesh->Render();
}


/// r[sݒ
void MeshHierarchyFbxDX9::SetView(const Matrix& kRView)
{
	// Ϗ
	mPRootMesh->SetView(kRView);
}

/// ˉesݒ
void MeshHierarchyFbxDX9::SetProjection(const Matrix& kRPojection)
{
	// Ϗ
	mPRootMesh->SetProjection(kRPojection);
}


/// ǂݍ
bool MeshHierarchyFbxDX9::Load(const TCHAR* kPFullPath)
{
	// KFbxIOSettings쐬Aݒ
	KFbxIOSettings* pFbxIOSettings = KFbxIOSettings::Create(mPFbxSdkManager, IOSROOT);
	mPFbxSdkManager->SetIOSettings(pFbxIOSettings);


	// C|[^[쐬
	KFbxImporter* pFbxImporter = KFbxImporter::Create(mPFbxSdkManager, "Importer");

	// C|[^[̐tO
	bool isSuceededImporterInitialize = false;

	// t@CtH[}bg
	int fileFormat = -1;

#ifdef UNICODE
	// pXCHAR^ɕϊ
	CHAR fullPath[StringHelper::mStKDefaultBufferSize];
	StringHelper::ToMultiByteChar(fullPath, sizeof(fullPath), kPFullPath);

	// C|[^[
	isSuceededImporterInitialize = pFbxImporter->Initialize(fullPath, fileFormat, mPFbxSdkManager->GetIOSettings());
#else
	// C|[^[
	isSuceededImporterInitialize = pFbxImporter->Initialize(kPFullPath, fileFormat, pFbxIOSettings);
#endif // UNICODE

	// ASSERT:C|[^[̏ɎsȂ玀B
	ASSERT_PRINTF(isSuceededImporterInitialize, _T("KFbxImporteȑɎs܂B\nPath=%s\n%s"), kPFullPath, pFbxImporter->GetLastErrorString());

	// C|[^[̏ɐȂ
	if (isSuceededImporterInitialize)
	{
		// t@C̃o[W擾
		int mejorVersion = 0;
		int minorVersion = 0;
		int revisionVersion = 0;
		pFbxImporter->GetFileVersion(mejorVersion, minorVersion, revisionVersion);

		PFL(_T("t@Co[W:%d.%d.%d"), mejorVersion, minorVersion, revisionVersion);


		// V[̍쐬
		mPFbxScene = KFbxScene::Create(mPFbxSdkManager, "Scene");

		// ASSERT:V[̍쐬ɎsȂ玀
		ASSERT_PRINTF(mPFbxScene, _T("KFbxScene̍쐬Ɏs܂B"));

		// V[̍쐬ɐȂ
		if (mPFbxScene)
		{
			// MEMO:ɏdłBƂƂłB
			// MEMO:f[^oCiƋقǍłB
			// C|[g
			bool isSucceededImporterImport = pFbxImporter->Import(mPFbxScene);

			// ASSERT:C|[gɎsȂ玀B
			ASSERT_PRINTF(isSucceededImporterImport, _T("C|[gɎs܂B"));


			// [gm[h擾
			KFbxNode* pRootNode = mPFbxScene->GetRootNode();
			if (pRootNode)
			{
				// bVǂݍ
				mPRootMesh->Load(kPFullPath);
			}
		}
	}


	return true;
}